(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    952609,      21467]
NotebookOptionsPosition[    935243,      21194]
NotebookOutlinePosition[    935674,      21211]
CellTagsIndexPosition[    935631,      21208]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Deriving  Zerilli  equation", "Title",
 CellChangeTimes->{{3.9629495547203045`*^9, 
  3.9629495725819073`*^9}},ExpressionUUID->"126057e4-1e58-e644-8cf7-\
813f47a30703"],

Cell["\<\
I  follow conventions of arXiv:2410.03542v2
and the paper of Zerilli: 
\[OpenCurlyDoubleQuote] EFFECTIVE POTENTIAL FOR EVEN-PARITY
REGGE-WHEELER GRAVITATIONAL PERTURBATION EQUATIONS\[CloseCurlyDoubleQuote] \
(1970)
and the Regge-Wheeler paper
\[OpenCurlyDoubleQuote]Stability of a Schwarzschild Singularity\
\[CloseCurlyDoubleQuote] (1957)\
\>", "Text",
 CellChangeTimes->{{3.96295027459252*^9, 3.962950299176134*^9}, {
  3.963030882042633*^9, 3.9630309304553795`*^9}, {3.9630385702049217`*^9, 
  3.9630386141185265`*^9}, {3.9632929927089996`*^9, 
  3.963292993179613*^9}},ExpressionUUID->"07d34d65-b7f3-d843-b666-\
483d22d4d880"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "EDCRGTCcode.m"}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"a59f75b5-4b5b-2749-95b9-2f86d14d629d"],

Cell[BoxData[
 TemplateBox[{
  "SetDelayed", "write", 
   "\"Tag \\!\\(\\*RowBox[{\\\"Classify\\\"}]\\) in \
\\!\\(\\*RowBox[{\\\"Classify\\\", \\\"[\\\", \\\"x_\\\", \\\"]\\\"}]\\) is \
Protected.\"", 2, 0, 1, 30043934366218325810, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.962949670472534*^9, 3.9632895595211906`*^9, 
  3.9637198708678627`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"d5f175e6-2c54-8b4a-b83f-b3754dea8e0e"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "r_", "]"}], ":=", 
   RowBox[{"1", "-", 
    FractionBox["rs", "r"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"coords", "=", 
   RowBox[{"{", 
    RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g0", "=", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"f", "[", "r", "]"}]}], ",", 
      FractionBox["1", 
       RowBox[{"f", "[", "r", "]"}]], ",", 
      SuperscriptBox["r", "2"], ",", 
      RowBox[{
       SuperscriptBox["r", "2"], 
       SuperscriptBox[
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"heven", "=", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{
        RowBox[{"f", "[", "r", "]"}], 
        RowBox[{"H0", "[", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
       RowBox[{"H1", "[", 
        RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Theta]"], 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Phi]"], 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}]},
      {
       RowBox[{"H1", "[", 
        RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
       RowBox[{
        FractionBox["1", 
         RowBox[{"f", "[", "r", "]"}]], 
        RowBox[{"H2", "[", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Theta]"], 
         RowBox[{"\[Beta]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Phi]"], 
         RowBox[{"\[Beta]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}]},
      {
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Theta]"], 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Theta]"], 
         RowBox[{"\[Beta]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}], 
       RowBox[{
        SuperscriptBox["r", "2"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ScriptCapitalK]", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
          "+", 
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"\[Theta]", ",", "\[Theta]"}]], 
           RowBox[{"G", "[", 
            RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], 
            "]"}]}]}], " ", ")"}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}]], 
           RowBox[{"G", "[", 
            RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
          "-", 
          RowBox[{
           FractionBox[
            RowBox[{"Cos", "[", "\[Theta]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]], 
           RowBox[{
            SubscriptBox["\[PartialD]", "\[Phi]"], 
            RowBox[{"G", "[", 
             RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], 
             "]"}]}]}]}], ")"}]}]},
      {
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Phi]"], 
         RowBox[{"\[Alpha]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}], 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Phi]"], 
         RowBox[{"\[Beta]", "[", 
          RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
        ")"}], 
       RowBox[{
        SuperscriptBox["r", "2"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[PartialD]", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}]], 
           RowBox[{"G", "[", 
            RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
          "-", 
          RowBox[{
           FractionBox[
            RowBox[{"Cos", "[", "\[Theta]", "]"}], 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]], 
           RowBox[{
            SubscriptBox["\[PartialD]", "\[Phi]"], 
            RowBox[{"G", "[", 
             RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], 
             "]"}]}]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["r", "2"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"\[ScriptCapitalK]", "[", 
            RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
           SuperscriptBox[
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubscriptBox["\[PartialD]", 
              RowBox[{"\[Phi]", ",", "\[Phi]"}]], 
             RowBox[{"G", "[", 
              RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], 
              "]"}]}], "+", 
            RowBox[{
             RowBox[{"Sin", "[", "\[Theta]", "]"}], 
             RowBox[{"Cos", "[", "\[Theta]", "]"}], 
             RowBox[{
              SubscriptBox["\[PartialD]", "\[Theta]"], 
              RowBox[{"G", "[", 
               RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], 
               "]"}]}]}]}], ")"}]}], ")"}]}]}
     }], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hodd", "=", 
   RowBox[{"(*", "fix", "*)"}], 
   RowBox[{"(", GridBox[{
      {"0", "0", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Phi]"], 
          RowBox[{"h0", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}], 
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Theta]"], 
          RowBox[{"h0", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}]},
      {"0", "0", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Phi]"], 
          RowBox[{"h1", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}], 
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Theta]"], 
          RowBox[{"h1", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}]},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Phi]"], 
          RowBox[{"h0", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}], 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]]}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Phi]"], 
          RowBox[{"h1", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}], "0", "0"},
      {
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Theta]"], 
          RowBox[{"h0", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}], 
       RowBox[{
        RowBox[{"Sin", "[", "\[Theta]", "]"}], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["\[PartialD]", "\[Theta]"], 
          RowBox[{"h1", "[", 
           RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], 
         ")"}]}], "0", "0"}
     }], ")"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.962949715025934*^9, 3.9629498446121693`*^9}, {
  3.9629498884551964`*^9, 3.962949937220146*^9}, {3.962950054193371*^9, 
  3.962950088722147*^9}, {3.962950125435842*^9, 3.9629502195408573`*^9}, {
  3.9629503107798605`*^9, 3.962950330219883*^9}, {3.962950430382927*^9, 
  3.962950483862585*^9}, {3.9629505179384136`*^9, 3.962950569283945*^9}, {
  3.962950741464678*^9, 3.9629508877631264`*^9}, {3.962950955226251*^9, 
  3.962950976985365*^9}, {3.962951112434189*^9, 3.9629511513756905`*^9}, {
  3.962951185032179*^9, 3.962951206264185*^9}, {3.963027353098643*^9, 
  3.963027368165447*^9}, {3.9632929029901333`*^9, 
  3.963292908224783*^9}},ExpressionUUID->"b2852a14-b6fe-d84a-ba3e-\
5c5cb70cf409"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Xk0lN//APDnmZnHTqMdpZV8Sqm0kBZbqxRStC9UUiJJUUlSUkKLVq1I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    "], {{0, 175.5}, {535.5, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{535.5, 175.5},
  PlotRange->{{0, 535.5}, {0, 175.5}}]], "Input",ExpressionUUID->"abb2cc15-\
7602-1444-8e96-4ab696e2f0cf"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RWgauge", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Alpha]", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        "0"}], "]"}]}], ",", 
     RowBox[{"\[Beta]", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        "0"}], "]"}]}], ",", 
     RowBox[{"G", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        "0"}], "]"}]}], ",", 
     RowBox[{"h2", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        "0"}], "]"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"subFourier", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"H0", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]", " ", "t"}], "]"}], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
         RowBox[{"H0", "[", "r", "]"}]}]}], "]"}]}], ",", 
     RowBox[{"H1", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]", " ", "t"}], "]"}], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
         RowBox[{"H1", "[", "r", "]"}]}]}], "]"}]}], ",", 
     RowBox[{"H2", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]", " ", "t"}], "]"}], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
         RowBox[{"H2", "[", "r", "]"}]}]}], "]"}]}], ",", 
     RowBox[{"\[ScriptCapitalK]", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]", " ", "t"}], "]"}], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}]}], "]"}]}], ",", 
     RowBox[{"h0", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]", " ", "t"}], "]"}], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
         RowBox[{"h0", "[", "r", "]"}]}]}], "]"}]}], ",", 
     RowBox[{"h1", "->", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"t", ",", "r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
        RowBox[{
         RowBox[{"Exp", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]", " ", "t"}], "]"}], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
         RowBox[{"h1", "[", "r", "]"}]}]}], "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"YLMeq\[Theta]", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Theta]", ",", "n_"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Phi]", ",", "m_"}], "}"}]}], "]"}], "/;", 
       RowBox[{
        RowBox[{"n", ">=", "2"}], "&&", 
        RowBox[{"m", ">=", "0"}]}]}], ")"}], "\[Rule]", " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cot", "[", "\[Theta]", "]"}]}], 
         RowBox[{
          SuperscriptBox["YLM", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"1", ",", "0"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{
         FractionBox["1", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]], 
         RowBox[{
          SuperscriptBox["YLM", 
           TagBox[
            RowBox[{"(", 
             RowBox[{"0", ",", "2"}], ")"}],
            Derivative],
           MultilineFunction->None], "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
        RowBox[{"L", 
         RowBox[{"(", 
          RowBox[{"L", "+", "1"}], ")"}], " ", 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Theta]", ",", 
         RowBox[{"n", "-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", "m"}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.962951287753847*^9, 3.962951432528871*^9}, {
  3.962951469027408*^9, 3.962951543667254*^9}, {3.9629516470429*^9, 
  3.962951652835371*^9}, {3.962951726769722*^9, 3.962951736217123*^9}, {
  3.963027389256487*^9, 3.963027395970389*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"2d02405f-cc43-ed48-9460-6d2c0f858c99"],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[Del]", "2"], 
    SubscriptBox["Y", "lm"]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "a0d32bc7-8ead-b74a-bb26-d2209ed0827c"],
 "= - L(L+1)",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "lm"], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "3078ba26-a1c7-8942-bac0-db3f8822a707"],
 " :"
}], "Text",
 CellChangeTimes->{{3.9629518156554813`*^9, 
  3.9629518841018715`*^9}},ExpressionUUID->"c1b744dd-f370-e740-8e51-\
9017cb56ceeb"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Laplacian", "[", 
  RowBox[{
   RowBox[{"YLM", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Theta]", ",", "\[Phi]"}], "}"}], ",", 
   "\"\<Spherical\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"{", 
     RowBox[{"r", "->", "1"}], "}"}]}], "//.", "YLMeq\[Theta]"}], "//", 
  "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.9629516657380047`*^9, 3.9629517069645653`*^9}, {
  3.962951744531044*^9, 3.9629517591206894`*^9}},
 CellLabel->
  "In[435]:=",ExpressionUUID->"ca727eb4-280a-7a46-bd1e-116de95ea538"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
        RowBox[{
         SuperscriptBox["YLM", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"0", ",", "2"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "r"], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
        RowBox[{
         SuperscriptBox["YLM", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "r"]}], ")"}]}], "r"], 
  "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["YLM", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"2", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], 
   SuperscriptBox["r", "2"]]}]], "Output",
 CellChangeTimes->{{3.962951677695719*^9, 3.962951707342417*^9}, {
   3.9629517383095894`*^9, 3.9629517595196743`*^9}, 3.963027404279331*^9},
 CellLabel->
  "Out[435]=",ExpressionUUID->"78d17398-d593-d341-8741-b03ad3434950"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "L"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "L"}], ")"}], " ", 
  RowBox[{"YLM", "[", 
   RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]], "Output",
 CellChangeTimes->{{3.962951677695719*^9, 3.962951707342417*^9}, {
   3.9629517383095894`*^9, 3.9629517595196743`*^9}, 3.963027404279331*^9},
 CellLabel->
  "Out[436]=",ExpressionUUID->"99c4b367-e55f-ae43-a729-f1f9e4505aeb"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"simplin", "[", "expr_", "]"}], ":=", 
   RowBox[{"Collect", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"H0", "[", "r", "]"}], ",", 
       RowBox[{"H1", "[", "r", "]"}], ",", 
       RowBox[{"H2", "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"H0", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"H1", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"H2", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"\[ScriptCapitalK]", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"H0", "''"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"H1", "''"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"H2", "''"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"\[ScriptCapitalK]", "''"}], "[", "r", "]"}], ",", 
       RowBox[{"\[ScriptCapitalR]", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"\[ScriptCapitalR]", "[", "r", "]"}], "'"}], ",", 
       RowBox[{
        RowBox[{"\[ScriptCapitalR]", "[", "r", "]"}], "''"}], ",", 
       RowBox[{"k", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"k", "[", "r", "]"}], "'"}], ",", 
       RowBox[{
        RowBox[{"k", "[", "r", "]"}], "''"}], ",", 
       RowBox[{"Rp", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"Rp", "[", "r", "]"}], "'"}], ",", 
       RowBox[{
        RowBox[{"Rp", "[", "r", "]"}], "''"}], ",", 
       RowBox[{"h0", "[", "r", "]"}], ",", 
       RowBox[{"h1", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"h0", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"h1", "'"}], "[", "r", "]"}], ",", 
       RowBox[{"Q", "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"Q", "'"}], "[", "r", "]"}], ",", 
       RowBox[{
        RowBox[{"Q", "''"}], "[", "r", "]"}]}], "}"}], ",", "FullSimplify"}], 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9629523909182167`*^9, 3.962952472433738*^9}, {
  3.962971413056211*^9, 3.9629714249656754`*^9}, {3.962972952594612*^9, 
  3.962973007551678*^9}, {3.963027410892599*^9, 3.963027435643379*^9}, {
  3.9630360071289234`*^9, 3.963036024114025*^9}, {3.9630387812176933`*^9, 
  3.963038786296934*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"8aa4269d-c129-5044-9a44-383b5657d2a5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Series", "[", 
       RowBox[{
        RowBox[{"g0", "+", 
         RowBox[{"\[Epsilon]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[Xi]even", " ", "heven"}], "+", 
            RowBox[{"\[Xi]odd", " ", "hodd"}]}], ")"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Epsilon]", ",", "0", ",", "1"}], "}"}]}], "]"}], "/.", 
      "RWgauge"}], "/.", "subFourier"}], "//.", "YLMeq\[Theta]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RGtensors", "[", 
  RowBox[{"g", ",", "coords"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9629512278205986`*^9, 3.962951241610628*^9}, {
  3.962951585343757*^9, 3.962951592025818*^9}, {3.9629518920198364`*^9, 
  3.9629518937100067`*^9}, {3.9630360304405193`*^9, 3.963036035468899*^9}, {
  3.9630376256033707`*^9, 3.963037653888788*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"09c949f0-bb25-ae4e-82a8-5dc592aa9505"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"gdd = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           FractionBox["rs", "r"]}], ")"}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            FractionBox["rs", "r"]}], ")"}], " ", "\[Xi]even", " ", 
          RowBox[{"H0", "[", "r", "]"}], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-1 + $CellContext`r^(-1) $CellContext`rs, 
          E^(Complex[0, -1] $CellContext`t $CellContext`\[Omega]) (
           1 - $CellContext`r^(-1) $CellContext`rs) $CellContext`\[Xi]even \
$CellContext`H0[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]even", " ", 
          RowBox[{"H1", "[", "r", "]"}], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]even $CellContext`H1[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h0", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}]}],
          "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]odd", " ", 
          RowBox[{"h0", "[", "r", "]"}], " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
          RowBox[{
           SuperscriptBox["YLM", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`h0[$CellContext`r] 
          Sin[$CellContext`\[Theta]] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]even", " ", 
          RowBox[{"H1", "[", "r", "]"}], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]even $CellContext`H1[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         FractionBox["1", 
          RowBox[{"1", "-", 
           FractionBox["rs", "r"]}]], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "r", " ", "\[Xi]even", " ", 
           RowBox[{"H2", "[", "r", "]"}], " ", 
           RowBox[{"YLM", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
          RowBox[{"r", "-", "rs"}]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {(1 - $CellContext`r^(-1) $CellContext`rs)^(-1), 
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]even \
$CellContext`H2[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h1", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}]}],
          "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]odd", " ", 
          RowBox[{"h1", "[", "r", "]"}], " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
          RowBox[{
           SuperscriptBox["YLM", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`h1[$CellContext`r] 
          Sin[$CellContext`\[Theta]] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h0", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}]}],
          "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h1", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}]}],
          "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         SuperscriptBox["r", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Xi]even", " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {$CellContext`r^2, 
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even $CellContext`YLM[$CellContext`\[Theta], $CellContext`\
\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r]}, 0, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
        SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1],
        Editable->False]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]odd", " ", 
          RowBox[{"h0", "[", "r", "]"}], " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
          RowBox[{
           SuperscriptBox["YLM", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`h0[$CellContext`r] 
          Sin[$CellContext`\[Theta]] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]odd", " ", 
          RowBox[{"h1", "[", "r", "]"}], " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
          RowBox[{
           SuperscriptBox["YLM", 
            TagBox[
             RowBox[{"(", 
              RowBox[{"1", ",", "0"}], ")"}],
             Derivative],
            MultilineFunction->None], "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`h1[$CellContext`r] 
          Sin[$CellContext`\[Theta]] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
        SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Xi]even", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {$CellContext`r^2 Sin[$CellContext`\[Theta]]^2, 
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even 
          Sin[$CellContext`\[Theta]]^2 \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] $CellContext`\
\[ScriptCapitalK][$CellContext`r]}, 0, 2, 1],
        Editable->False]}], "}"}]}], "}"}]}],
  SequenceForm["gdd = ", {{
     SeriesData[$CellContext`\[Epsilon], 
      0, {-1 + $CellContext`r^(-1) $CellContext`rs, 
       E^(Complex[0, -1] $CellContext`t $CellContext`\[Omega]) (
        1 - $CellContext`r^(-1) $CellContext`rs) $CellContext`\[Xi]even \
$CellContext`H0[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]even \
$CellContext`H1[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd \
$CellContext`h0[$CellContext`r] Sin[$CellContext`\[Theta]] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1]}, {
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]even \
$CellContext`H1[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {(1 - $CellContext`r^(-1) $CellContext`rs)^(-1), 
       E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]even \
$CellContext`H2[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd \
$CellContext`h1[$CellContext`r] Sin[$CellContext`\[Theta]] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1]}, {
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {$CellContext`r^2, 
       E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even $CellContext`YLM[$CellContext`\[Theta], $CellContext`\
\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r]}, 0, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1]}, {
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd \
$CellContext`h0[$CellContext`r] Sin[$CellContext`\[Theta]] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd \
$CellContext`h1[$CellContext`r] Sin[$CellContext`\[Theta]] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {$CellContext`r^2 Sin[$CellContext`\[Theta]]^2, 
       E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even 
       Sin[$CellContext`\[Theta]]^2 $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r]}, 0, 2, 
      1]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.9632897188044987`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"bfbc0420-8985-ba4f-9893-7ed533396884"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LineElement = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"r", " ", 
          SuperscriptBox[
           RowBox[{"d", "[", "r", "]"}], "2"]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"d", "[", "t", "]"}], "2"]}], "r"], "+", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"d", "[", "\[Theta]", "]"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         SuperscriptBox[
          RowBox[{"d", "[", "\[Phi]", "]"}], "2"], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"]}]}], ")"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Xi]even", " ", 
           SuperscriptBox[
            RowBox[{"d", "[", "t", "]"}], "2"], " ", 
           RowBox[{"H0", "[", "r", "]"}], " ", 
           RowBox[{"YLM", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "r"], "+", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "r", " ", "\[Xi]even", " ", 
           SuperscriptBox[
            RowBox[{"d", "[", "r", "]"}], "2"], " ", 
           RowBox[{"H2", "[", "r", "]"}], " ", 
           RowBox[{"YLM", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], 
          RowBox[{"r", "-", "rs"}]], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Xi]even", " ", 
          SuperscriptBox[
           RowBox[{"d", "[", "\[Theta]", "]"}], "2"], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
          SuperscriptBox["r", "2"], " ", "\[Xi]even", " ", 
          SuperscriptBox[
           RowBox[{"d", "[", "\[Phi]", "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "2"], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
         RowBox[{
          RowBox[{"d", "[", "t", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
             " ", "\[Xi]odd", " ", 
             RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
             RowBox[{"d", "[", "\[Theta]", "]"}], " ", 
             RowBox[{"h0", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["YLM", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
             " ", "\[Xi]odd", " ", 
             RowBox[{"d", "[", "\[Phi]", "]"}], " ", 
             RowBox[{"h0", "[", "r", "]"}], " ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
             RowBox[{
              SuperscriptBox["YLM", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"d", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
             " ", "\[Xi]even", " ", 
             RowBox[{"d", "[", "t", "]"}], " ", 
             RowBox[{"H1", "[", "r", "]"}], " ", 
             RowBox[{"YLM", "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
             " ", "\[Xi]odd", " ", 
             RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
             RowBox[{"d", "[", "\[Theta]", "]"}], " ", 
             RowBox[{"h1", "[", "r", "]"}], " ", 
             RowBox[{
              SuperscriptBox["YLM", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"0", ",", "1"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{
               RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
             " ", "\[Xi]odd", " ", 
             RowBox[{"d", "[", "\[Phi]", "]"}], " ", 
             RowBox[{"h1", "[", "r", "]"}], " ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
             RowBox[{
              SuperscriptBox["YLM", 
               TagBox[
                RowBox[{"(", 
                 RowBox[{"1", ",", "0"}], ")"}],
                Derivative],
               MultilineFunction->None], "[", 
              RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}], 
        ")"}], " ", "\[Epsilon]"}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
       SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`\[Epsilon], 
      0, {$CellContext`r ($CellContext`r - $CellContext`rs)^(-1) \
$CellContext`d[$CellContext`r]^2 - $CellContext`r^(-1) ($CellContext`r - \
$CellContext`rs) $CellContext`d[$CellContext`t]^2 + $CellContext`r^2 \
$CellContext`d[$CellContext`\[Theta]]^2 + $CellContext`r^2 \
$CellContext`d[$CellContext`\[Phi]]^2 Sin[$CellContext`\[Theta]]^2, 
       E^(Complex[
           0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]even \
$CellContext`d[$CellContext`t]^2 $CellContext`H0[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] + 
       E^(Complex[
           0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]even \
$CellContext`d[$CellContext`r]^2 $CellContext`H2[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] + 
       E^(Complex[
           0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even $CellContext`d[$CellContext`\[Theta]]^2 \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] $CellContext`\
\[ScriptCapitalK][$CellContext`r] + 
       E^(Complex[
           0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even $CellContext`d[$CellContext`\[Phi]]^2 
        Sin[$CellContext`\[Theta]]^2 $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r] + \
$CellContext`d[$CellContext`t] ((-2) 
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`d[$CellContext`\[Theta]] \
$CellContext`h0[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]] + 
         2 E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`d[$CellContext`\[Phi]] \
$CellContext`h0[$CellContext`r] Sin[$CellContext`\[Theta]] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]) + $CellContext`d[$CellContext`r] (
         2 E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]even $CellContext`d[$CellContext`t] \
$CellContext`H1[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]] - 2 
         E^(Complex[
            0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd 
         Csc[$CellContext`\[Theta]] $CellContext`d[$CellContext`\[Theta]] \
$CellContext`h1[$CellContext`r] 
         Derivative[
          0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]] + 
         2 E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`d[$CellContext`\[Phi]] \
$CellContext`h1[$CellContext`r] Sin[$CellContext`\[Theta]] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]])}, 0, 2, 1],
     Editable->False],
    Short[#, 32]& ]}],
  SequenceForm["LineElement = ", 
   Short[
    SeriesData[$CellContext`\[Epsilon], 
     0, {$CellContext`r ($CellContext`r - $CellContext`rs)^(-1) \
$CellContext`d[$CellContext`r]^2 - $CellContext`r^(-1) ($CellContext`r - \
$CellContext`rs) $CellContext`d[$CellContext`t]^2 + $CellContext`r^2 \
$CellContext`d[$CellContext`\[Theta]]^2 + $CellContext`r^2 \
$CellContext`d[$CellContext`\[Phi]]^2 Sin[$CellContext`\[Theta]]^2, 
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]even \
$CellContext`d[$CellContext`t]^2 $CellContext`H0[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] + 
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]even \
$CellContext`d[$CellContext`r]^2 $CellContext`H2[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] + 
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even $CellContext`d[$CellContext`\[Theta]]^2 \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] $CellContext`\
\[ScriptCapitalK][$CellContext`r] + 
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^2 \
$CellContext`\[Xi]even $CellContext`d[$CellContext`\[Phi]]^2 
       Sin[$CellContext`\[Theta]]^2 $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r] + \
$CellContext`d[$CellContext`t] ((-2) 
         E^(Complex[
            0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd 
         Csc[$CellContext`\[Theta]] $CellContext`d[$CellContext`\[Theta]] \
$CellContext`h0[$CellContext`r] 
         Derivative[
          0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]] + 
        2 E^(Complex[
            0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`d[$CellContext`\[Phi]] \
$CellContext`h0[$CellContext`r] Sin[$CellContext`\[Theta]] 
         Derivative[
          1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]) + $CellContext`d[$CellContext`r] (
        2 E^(Complex[
            0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]even $CellContext`d[$CellContext`t] \
$CellContext`H1[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]] - 2 
        E^(Complex[
           0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]odd 
        Csc[$CellContext`\[Theta]] $CellContext`d[$CellContext`\[Theta]] \
$CellContext`h1[$CellContext`r] 
        Derivative[
         0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]] + 
        2 E^(Complex[
            0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]odd $CellContext`d[$CellContext`\[Phi]] \
$CellContext`h1[$CellContext`r] Sin[$CellContext`\[Theta]] 
         Derivative[
          1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]])}, 0, 2, 1], 32]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.9632897190267525`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"0b89eb6e-fe74-3a41-996a-b2f82d10189b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"gUU = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox["r", 
           RowBox[{"r", "-", "rs"}]]}], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "r", " ", "\[Xi]even", " ", 
           RowBox[{"H0", "[", "r", "]"}], " ", 
           RowBox[{"YLM", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
          RowBox[{"r", "-", "rs"}]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-$CellContext`r/($CellContext`r - $CellContext`rs), -
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]even \
$CellContext`H0[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]even", " ", 
          RowBox[{"H1", "[", "r", "]"}], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]even $CellContext`H1[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
            " ", "\[Xi]odd", " ", 
            RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
            RowBox[{"h0", "[", "r", "]"}], " ", 
            RowBox[{
             SuperscriptBox["YLM", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}]}]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h0", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}]}]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ",
           "\[Xi]even", " ", 
          RowBox[{"H1", "[", "r", "]"}], " ", 
          RowBox[{"YLM", "[", 
           RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
         "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) \
$CellContext`\[Xi]even $CellContext`H1[$CellContext`r] \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         FractionBox[
          RowBox[{"r", "-", "rs"}], "r"], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Xi]even", " ", 
           RowBox[{"H2", "[", "r", "]"}], " ", 
           RowBox[{"YLM", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
          "r"], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {$CellContext`r^(-1) ($CellContext`r - $CellContext`rs), -
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]even \
$CellContext`H2[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h1", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
          SuperscriptBox["r", "3"]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
            " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Xi]odd", " ", 
            RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
            RowBox[{"h1", "[", "r", "]"}], " ", 
            RowBox[{
             SuperscriptBox["YLM", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
           SuperscriptBox["r", "3"]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
            " ", "\[Xi]odd", " ", 
            RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
            RowBox[{"h0", "[", "r", "]"}], " ", 
            RowBox[{
             SuperscriptBox["YLM", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"0", ",", "1"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}]}]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h1", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
          SuperscriptBox["r", "3"]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
          Derivative[
           0, 1][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         FractionBox["1", 
          SuperscriptBox["r", "2"]], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]even", " ", 
           RowBox[{"YLM", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
           RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}], " ", "\[Epsilon]"}], 
          SuperscriptBox["r", "2"]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {$CellContext`r^(-2), -
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-2) \
$CellContext`\[Xi]even $CellContext`YLM[$CellContext`\[Theta], $CellContext`\
\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r]}, 0, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
        SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1],
        Editable->False]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       InterpretationBox[
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]odd", " ", 
           RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
           RowBox[{"h0", "[", "r", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "0"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
          RowBox[{"r", " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}]}]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 0, {
         E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
            " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Xi]odd", " ", 
            RowBox[{"Csc", "[", "\[Theta]", "]"}], " ", 
            RowBox[{"h1", "[", "r", "]"}], " ", 
            RowBox[{
             SuperscriptBox["YLM", 
              TagBox[
               RowBox[{"(", 
                RowBox[{"1", ",", "0"}], ")"}],
               Derivative],
              MultilineFunction->None], "[", 
             RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "\[Epsilon]"}], 
           SuperscriptBox["r", "3"]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 1, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {-E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
          Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
          Derivative[
           1, 0][$CellContext`YLM][$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        SuperscriptBox[
         RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
        SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1],
        Editable->False], ",", 
       InterpretationBox[
        RowBox[{
         FractionBox[
          SuperscriptBox[
           RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], 
          SuperscriptBox["r", "2"]], "-", 
         FractionBox[
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], 
           " ", "\[Xi]even", " ", 
           SuperscriptBox[
            RowBox[{"Csc", "[", "\[Theta]", "]"}], "2"], " ", 
           RowBox[{"YLM", "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
           RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}], " ", "\[Epsilon]"}], 
          SuperscriptBox["r", "2"]], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", "\[Epsilon]", "]"}], "2"],
          SeriesData[$CellContext`\[Epsilon], 0, {}, 0, 2, 1],
          Editable->False]}],
        SeriesData[$CellContext`\[Epsilon], 
         0, {$CellContext`r^(-2) Csc[$CellContext`\[Theta]]^2, -
          E^(Complex[
             0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-2) \
$CellContext`\[Xi]even 
          Csc[$CellContext`\[Theta]]^2 \
$CellContext`YLM[$CellContext`\[Theta], $CellContext`\[Phi]] $CellContext`\
\[ScriptCapitalK][$CellContext`r]}, 0, 2, 1],
        Editable->False]}], "}"}]}], "}"}]}],
  SequenceForm["gUU = ", {{
     SeriesData[$CellContext`\[Epsilon], 
      0, {-$CellContext`r/($CellContext`r - $CellContext`rs), -
       E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]even \
$CellContext`H0[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]even \
$CellContext`H1[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1]}, {
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`\[Xi]even \
$CellContext`H1[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {$CellContext`r^(-1) ($CellContext`r - $CellContext`rs), -
       E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]even \
$CellContext`H2[$CellContext`r] $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]]}, 0, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1]}, {
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
       Derivative[
        0, 1][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {$CellContext`r^(-2), -
       E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-2) \
$CellContext`\[Xi]even $CellContext`YLM[$CellContext`\[Theta], $CellContext`\
\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r]}, 0, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1]}, {
     SeriesData[$CellContext`\[Epsilon], 0, {
      E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-1) \
($CellContext`r - $CellContext`rs)^(-1) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h0[$CellContext`r] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {-E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-3) \
($CellContext`r - $CellContext`rs) $CellContext`\[Xi]odd 
       Csc[$CellContext`\[Theta]] $CellContext`h1[$CellContext`r] 
       Derivative[
        1, 0][$CellContext`YLM][$CellContext`\[Theta], $CellContext`\[Phi]]}, 
      1, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 2, 1], 
     SeriesData[$CellContext`\[Epsilon], 
      0, {$CellContext`r^(-2) Csc[$CellContext`\[Theta]]^2, -
       E^(Complex[
          0, -1] $CellContext`t $CellContext`\[Omega]) $CellContext`r^(-2) \
$CellContext`\[Xi]even 
       Csc[$CellContext`\[Theta]]^2 $CellContext`YLM[$CellContext`\[Theta], \
$CellContext`\[Phi]] $CellContext`\[ScriptCapitalK][$CellContext`r]}, 0, 2, 
      1]}}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.963289719258156*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"b30be0a6-fe33-7145-b2ab-fca9d2590ab7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"gUU computed in \"\>", "\[InvisibleSpace]", 
   "0.18799999999998818`", "\[InvisibleSpace]", "\<\" sec\"\>"}],
  SequenceForm["gUU computed in ", 0.18799999999998818`, " sec"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.963289719271492*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"3c1601ee-692a-564d-9ca8-23a0b59deff5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Gamma computed in \"\>", "\[InvisibleSpace]", 
   "2.953000000000088`", "\[InvisibleSpace]", "\<\" sec\"\>"}],
  SequenceForm["Gamma computed in ", 2.953000000000088, " sec"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.963289722682926*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"fee0139f-c37c-b349-95aa-465c86a73480"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Riemann(dddd) computed in \"\>", "\[InvisibleSpace]", 
   "10.171999999999912`", "\[InvisibleSpace]", "\<\" sec\"\>"}],
  SequenceForm["Riemann(dddd) computed in ", 10.171999999999912`, " sec"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.9632897333646393`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"882d7c58-be5e-5e47-a237-cbee2f9bb349"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Riemann(Uddd) computed in \"\>", "\[InvisibleSpace]", 
   "28.687000000000012`", "\[InvisibleSpace]", "\<\" sec\"\>"}],
  SequenceForm["Riemann(Uddd) computed in ", 28.687000000000012`, " sec"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.9632897629644375`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"fd6cc806-bb61-364f-a504-490199e6218a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Ricci computed in \"\>", "\[InvisibleSpace]", 
   "10.422000000000025`", "\[InvisibleSpace]", "\<\" sec\"\>"}],
  SequenceForm["Ricci computed in ", 10.422000000000025`, " sec"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.9629512312077065`*^9, 3.962951243495388*^9}, 
   3.962951592498522*^9, 3.962951894297343*^9, 3.9630274456310678`*^9, 
   3.9630376586960907`*^9, 3.9632897737270203`*^9},
 CellLabel->
  "During evaluation of \
In[10]:=",ExpressionUUID->"bff40a1f-d8ae-ad47-8d75-119c92720d77"]
}, Open  ]],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.9630377479414253`*^9, 3.9632898085527344`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"75a554eb-739a-5644-bcf3-a21f9cd8452b"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RddEven", "=", 
   RowBox[{"Rdd", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]odd", "->", "0"}], ",", 
      RowBox[{"\[Xi]even", "->", "1"}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RddOdd", "=", 
   RowBox[{"Rdd", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Xi]odd", "->", "1"}], ",", 
      RowBox[{"\[Xi]even", "->", "0"}]}], "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9630376817919655`*^9, 3.9630377216898727`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"77c0511b-4178-394c-b5ba-6288a275ae58"],

Cell[CellGroupData[{

Cell["Zerilli", "Section",
 CellChangeTimes->{{3.962951915255947*^9, 3.962951919554779*^9}, {
  3.9630354770378685`*^9, 
  3.963035478071192*^9}},ExpressionUUID->"597002aa-d8c5-7f4a-ab2e-\
5ea3c3b98fa0"],

Cell[CellGroupData[{

Cell["Even  equation", "Subsection",
 CellChangeTimes->{{3.9630354814700584`*^9, 
  3.963035485094057*^9}},ExpressionUUID->"30c7e1e4-9dfa-5049-b477-\
575cc1827bc8"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddEven", "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", "4"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solveH2", "=", 
   RowBox[{"{", 
    RowBox[{"H2", "->", 
     RowBox[{"Function", "[", 
      RowBox[{"r", ",", 
       RowBox[{"H0", "[", "r", "]"}]}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.96295208988998*^9, 3.962952145275942*^9}, {
  3.9630377642860394`*^9, 3.9630377650668106`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"0c6fbdfb-f280-df49-affe-537596afd1be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
  "\[Epsilon]", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"H0", "[", "r", "]"}], "-", 
    RowBox[{"H2", "[", "r", "]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Cot", "[", "\[Theta]", "]"}], " ", 
     RowBox[{
      SuperscriptBox["YLM", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
    RowBox[{
     SuperscriptBox["YLM", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.962952093535856*^9, {3.9629521243193846`*^9, 3.962952145988384*^9}, 
   3.963027453572907*^9, 3.9630377753383255`*^9, 3.9632898248901176`*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"3e900b2d-5356-f044-bb6e-ec8c57bddc87"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddEven", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqtt", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", 
      FractionBox[
       SuperscriptBox["r", "3"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], "2"]], 
      RowBox[{"Exp", "[", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
      FractionBox["%", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"YLM", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]]}], "/.", "solveH2"}], "//",
     "FullSimplify"}], "//", "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.9629519238979664`*^9, 3.9629519386471844`*^9}, {
   3.9629519719132175`*^9, 3.962952001089292*^9}, {3.962952031431862*^9, 
   3.962952065560219*^9}, {3.96295213343535*^9, 3.96295213551679*^9}, {
   3.9629524832980165`*^9, 3.962952510042848*^9}, 3.963037772984108*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"bdb92867-513b-964b-9124-24e9f6f9117c"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    SuperscriptBox["r", "3"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"YLM", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", "L", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"H0", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "r"}], "-", 
        RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "3"], " ", 
      SuperscriptBox["\[Omega]", "2"], " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["r", "3"], " ", 
      SuperscriptBox["\[Omega]", "2"], " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"5", " ", "r", " ", "rs", " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["rs", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
      RowBox[{
       SuperscriptBox["H1", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"4", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["r", "2"], " ", "rs", " ", "\[Omega]", " ", 
      RowBox[{
       SuperscriptBox["H1", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"r", " ", "rs", " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["rs", "2"], " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", "r", " ", "rs", " ", 
      RowBox[{
       SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["rs", "2"], " ", 
      RowBox[{
       SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", "r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.962951956840669*^9, 3.9629520026887703`*^9, {3.962952035548176*^9, 
   3.9629520662122726`*^9}, {3.96295213652683*^9, 3.962952147258974*^9}, 
   3.962952188714706*^9, {3.962952485151268*^9, 3.962952510480226*^9}, 
   3.96302745889481*^9, 3.963037777684187*^9, 3.963289976270052*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"72104e2c-7bd0-1944-9a0b-c077962aac73"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"L", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"H0", "[", "r", "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "r"}], "-", 
      RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["r", "3"], " ", 
    SuperscriptBox["\[Omega]", "2"], " ", 
    RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"4", " ", "r", " ", 
    RowBox[{
     SuperscriptBox["H0", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{
    RowBox[{"-", "r"}], "+", "rs"}]], "-", 
  FractionBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
    RowBox[{
     SuperscriptBox["H1", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{"r", "-", "rs"}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "rs", " ", 
    RowBox[{
     SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{"r", "-", "rs"}]], "-", 
  RowBox[{"2", " ", "r", " ", 
   RowBox[{
    SuperscriptBox["H0", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{
  3.962951956840669*^9, 3.9629520026887703`*^9, {3.962952035548176*^9, 
   3.9629520662122726`*^9}, {3.96295213652683*^9, 3.962952147258974*^9}, 
   3.962952188714706*^9, {3.962952485151268*^9, 3.962952510480226*^9}, 
   3.96302745889481*^9, 3.963037777684187*^9, 3.96328997661471*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"c0e663cd-6556-4641-9f63-9b0e89bea46c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddEven", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "2"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqtr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"4", 
      SuperscriptBox["r", "3"], 
      FractionBox["1", 
       RowBox[{"2", "r"}]], 
      RowBox[{"Exp", "[", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
      FractionBox["%", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"YLM", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]]}], "/.", "solveH2"}], "//",
     "FullSimplify"}], "//", "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.962952224238678*^9, 3.962952288007078*^9}, {
  3.962952523240532*^9, 3.9629525242447443`*^9}, {3.963037782139221*^9, 
  3.9630377854224873`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"a619a783-c5a9-d344-bda1-bda64dafb128"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"YLM", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{"H2", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "-", 
           RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.962952232197153*^9, 3.9629522883517666`*^9}, 
   3.962952524694603*^9, 3.963027465634035*^9, 3.9630377870330486`*^9, 
   3.9632900382879944`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"a77ae5e0-d3ea-f745-a82a-a9f46c6850af"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
   RowBox[{"H0", "[", "r", "]"}]}], "+", 
  RowBox[{"L", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "L"}], ")"}], " ", 
   RowBox[{"H1", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "r"}], "-", 
      RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
    RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
   RowBox[{"r", "-", "rs"}]], "+", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
   RowBox[{
    SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.962952232197153*^9, 3.9629522883517666`*^9}, 
   3.962952524694603*^9, 3.963027465634035*^9, 3.9630377870330486`*^9, 
   3.9632900386790695`*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"a61c2196-67bf-2a42-8a86-5be3e8608386"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddEven", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "2"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqrr", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", 
         RowBox[{"4", " ", "r", " "}]], ")"}], 
       RowBox[{"-", "1"}]], 
      RowBox[{"Exp", "[", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
      FractionBox["%", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"YLM", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]]}], "/.", "solveH2"}], "//",
     "FullSimplify"}], "//", "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.962952310102184*^9, 3.962952364221756*^9}, {
   3.96295253440097*^9, 3.9629525550883217`*^9}, 3.9630377980362225`*^9},
 CellLabel->"In[20]:=",ExpressionUUID->"a479a80e-60ce-d745-908e-0628f287b65e"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", "r", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}], "2"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"YLM", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
     "2", " ", "\[ImaginaryI]", " ", "r", " ", "rs", " ", "\[Omega]", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"rs", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["H0", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "-", 
           RowBox[{"3", " ", 
            RowBox[{
             SuperscriptBox["H2", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "+", 
           RowBox[{"6", " ", 
            RowBox[{
             SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "-", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{
             SuperscriptBox["H0", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
            RowBox[{
             SuperscriptBox["H1", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{
             SuperscriptBox["H2", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{
             SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}], "+", 
           RowBox[{"r", " ", 
            RowBox[{
             SuperscriptBox["H0", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], "+", 
        RowBox[{"4", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.962952323721206*^9, 3.962952364824423*^9}, {
   3.962952539068756*^9, 3.962952557723844*^9}, 3.963027468433876*^9, 
   3.9630378005873165`*^9, 3.9632900436685257`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"da61b4fd-f33a-1b47-8abb-a3c39f64202e"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"L", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"H0", "[", "r", "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{
   "2", " ", "\[ImaginaryI]", " ", "r", " ", "rs", " ", "\[Omega]", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"4", " ", "r", " ", 
    RowBox[{
     SuperscriptBox["H0", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{"r", "-", "rs"}]], "+", 
  FractionBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
    RowBox[{
     SuperscriptBox["H1", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{"r", "-", "rs"}]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     FractionBox[
      RowBox[{"2", " ", "r"}], 
      RowBox[{
       RowBox[{"-", "r"}], "+", "rs"}]]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  RowBox[{"2", " ", "r", " ", 
   RowBox[{
    SuperscriptBox["H0", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "-", 
  RowBox[{"4", " ", "r", " ", 
   RowBox[{
    SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.962952323721206*^9, 3.962952364824423*^9}, {
   3.962952539068756*^9, 3.962952557723844*^9}, 3.963027468433876*^9, 
   3.9630378005873165`*^9, 3.9632900441978893`*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"0042915e-34fb-7c4d-bd80-12c879360d8c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tr", "[", 
     RowBox[{
      RowBox[{"RddEven", "[", 
       RowBox[{"[", 
        RowBox[{
         RowBox[{"3", ";;", "4"}], ",", 
         RowBox[{"3", ";;", "4"}]}], "]"}], "]"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "\[Theta]", "]"}], 
           RowBox[{"-", "2"}]]}], "}"}]}], "}"}]}], "]"}], "//.", 
    "YLMeq\[Theta]"}], "//", "Normal"}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqtrace", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
      FractionBox["%", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"YLM", "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]]}], "/.", "solveH2"}], "//",
     "FullSimplify"}], "//", "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.962952579322185*^9, 3.9629526528989697`*^9}, 
   3.9630378112042847`*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"db5393c8-728a-0341-b89b-f991b154fa6b"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"YLM", "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "L"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"H0", "[", "r", "]"}]}], "+", 
     RowBox[{"4", " ", "\[ImaginaryI]", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{"4", " ", "r", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "+", 
     RowBox[{"L", " ", "r", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["L", "2"], " ", "r", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", "rs", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"L", " ", "rs", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["L", "2"], " ", "rs", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", "r", " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", "L", " ", "r", " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["L", "2"], " ", "r", " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
     RowBox[{"4", " ", "rs", " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", "L", " ", "rs", " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["L", "2"], " ", "rs", " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "3"], " ", 
      SuperscriptBox["\[Omega]", "2"], " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", "r", " ", "rs", " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["rs", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"4", " ", "r", " ", "rs", " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["rs", "2"], " ", 
      RowBox[{
       SuperscriptBox["H2", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"8", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"14", " ", "r", " ", "rs", " ", 
      RowBox[{
       SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"6", " ", 
      SuperscriptBox["rs", "2"], " ", 
      RowBox[{
       SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", "r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.9629526190303383`*^9, 3.962952654452581*^9}, 
   3.963027474150301*^9, 3.963037813488243*^9, 3.9632900453360157`*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"9b49b95c-b145-6646-a680-7a63483b9fc0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"H0", "[", "r", "]"}]}], "+", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
   RowBox[{"H1", "[", "r", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "L", "+", 
     SuperscriptBox["L", "2"], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}], 
      RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
   RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"r", "-", "rs"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H0", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "r"}], "+", 
     RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  RowBox[{"r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.9629526190303383`*^9, 3.962952654452581*^9}, 
   3.963027474150301*^9, 3.963037813488243*^9, 3.963290045519396*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"430fc601-6090-2943-a47d-5070d84f4f52"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddEven", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "3"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqtAeven", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", "1", ")"}], 
       RowBox[{"-", "1"}]], 
      RowBox[{"Exp", "[", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
      FractionBox["%", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Theta]"], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]]}], "/.", 
     "solveH2"}], "//", "FullSimplify"}], "//", "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.9629526739004135`*^9, 3.9629526977192507`*^9}, {
  3.963037816797905*^9, 3.9630378220346603`*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"249b553c-7d70-d24f-966c-995162612d12"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"rs", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"H2", "[", "r", "]"}], "+", 
           RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["H1", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], ")"}], 
   " ", 
   RowBox[{
    SuperscriptBox["YLM", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["r", "2"]}]]], "Output",
 CellChangeTimes->{3.9629526983920345`*^9, 3.9630274772843895`*^9, 
  3.9630378691006794`*^9, 3.9632900461481724`*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"e5db8684-8dc8-b84e-8e8a-0bce1eaea57c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{"H0", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{"rs", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"]}]], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
   RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["H1", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{"2", " ", "r"}]]}]], "Output",
 CellChangeTimes->{3.9629526983920345`*^9, 3.9630274772843895`*^9, 
  3.9630378691006794`*^9, 3.9632900461921387`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"f7efe659-4f2e-c94b-8309-a74daa0291af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddEven", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "3"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqrAeven", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      SuperscriptBox[
       RowBox[{"(", "1", ")"}], 
       RowBox[{"-", "1"}]], 
      RowBox[{"Exp", "[", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
      FractionBox["%", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{
         SubscriptBox["\[PartialD]", "\[Theta]"], 
         RowBox[{"YLM", "[", 
          RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]]}], "/.", 
     "solveH2"}], "//", "FullSimplify"}], "//", "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.9629527172557144`*^9, 3.962952742983761*^9}, {
  3.963037872135586*^9, 3.9630378781963577`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"9ed95719-4cac-d446-9a73-7b94c784d4d4"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "r"}], "+", 
        RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
      RowBox[{"H0", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
      RowBox[{"H1", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "-", 
     RowBox[{"rs", " ", 
      RowBox[{"H2", "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "-", 
     RowBox[{"2", " ", "r", " ", "rs", " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], "+", 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["YLM", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.9629527222252274`*^9, 3.962952743941889*^9}, 
   3.9630274836216526`*^9, 3.9630378793578186`*^9, 3.963290048010439*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"7aceef0e-6ce9-0d42-92f3-1cff9002cad2"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"rs", " ", 
    RowBox[{"H0", "[", "r", "]"}]}], 
   RowBox[{
    SuperscriptBox["r", "2"], "-", 
    RowBox[{"r", " ", "rs"}]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
    RowBox[{"H1", "[", "r", "]"}]}], 
   RowBox[{"r", "-", "rs"}]], "+", 
  RowBox[{
   SuperscriptBox["H0", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}], "-", 
  RowBox[{
   SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{{3.9629527222252274`*^9, 3.962952743941889*^9}, 
   3.9630274836216526`*^9, 3.9630378793578186`*^9, 3.96329004814526*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"29c10ffc-00e4-224d-a7fb-72c8b7db1d04"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"all", " ", "the", " ", 
    RowBox[{"equations", ":"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"eqsEven", "=", 
     RowBox[{"{", 
      RowBox[{
      "eqtt", ",", "eqtr", ",", "eqrr", ",", "eqtrace", ",", "eqtAeven", ",", 
       "eqrAeven"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"MatrixForm", "[", "eqsEven", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.962952755776516*^9, 3.96295279304067*^9}, {
  3.9630308234525185`*^9, 3.9630308304633465`*^9}, {3.9630378930155754`*^9, 
  3.9630378962658787`*^9}, {3.963038253336754*^9, 3.9630382542167664`*^9}, {
  3.9632900865124435`*^9, 3.9632900870761127`*^9}},
 Background->RGBColor[1, 1, 0.85],
 CellLabel->"In[30]:=",ExpressionUUID->"8f80057c-616f-334a-876f-5ac7eb50e20f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "r"}], "-", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"-", "r"}], "+", "rs"}]], "-", 
        FractionBox[
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        FractionBox[
         RowBox[{"2", " ", "rs", " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["H0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", 
         " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", 
         RowBox[{"H1", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{
         "2", " ", "\[ImaginaryI]", " ", "r", " ", "rs", " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        FractionBox[
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "6"}], "+", 
           FractionBox[
            RowBox[{"2", " ", "r"}], 
            RowBox[{
             RowBox[{"-", "r"}], "+", "rs"}]]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["H0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
         RowBox[{"H1", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"], "-", 
           FractionBox[
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["H0", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "r"}], "+", 
           RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"rs", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r"}]]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"rs", " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox["r", "2"], "-", 
          RowBox[{"r", " ", "rs"}]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{
         SuperscriptBox["H0", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}], "-", 
        RowBox[{
         SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9629527939581733`*^9, 3.963027486834343*^9, 3.963037897139759*^9, 
   3.963038264367796*^9, {3.963290081423126*^9, 3.963290087493185*^9}},
 CellLabel->
  "Out[31]//MatrixForm=",ExpressionUUID->"c36b0f81-ca30-8d47-8aad-\
4cea4bc2868b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating  equtions and deriving Zerilli eq", "Subsection",
 CellChangeTimes->{{3.963035509288002*^9, 
  3.963035528786022*^9}},ExpressionUUID->"5eaaff71-01c3-0249-a696-\
1a46ada72e4f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Deriving", " ", "algebraic", " ", "relation", " ", "between", " ", 
     "H0"}], ",", " ", 
    RowBox[{"H1", " ", "and", " ", "\[ScriptCapitalK]"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"eqsEven", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}], "==", "0"}], ",", 
         RowBox[{
          RowBox[{"H0", "'"}], "[", "r", "]"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
     "simplin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"eqsEven", "[", 
         RowBox[{"[", 
          RowBox[{"1", ";;", "5"}], "]"}], "]"}], "/.", 
        RowBox[{"D", "[", 
         RowBox[{"%", ",", "r"}], "]"}]}], "/.", "%"}], "//", 
      "FullSimplify"}], "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"%%", "-", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ".", 
        "%%"}]}], "//", "FullSimplify"}], "//", "simplin"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"%%", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "==", "0"}], ",", 
        RowBox[{
         RowBox[{"H1", "'"}], "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
    "simplin"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"%%%", "/.", 
        RowBox[{"D", "[", 
         RowBox[{"%", ",", "r"}], "]"}]}], "/.", "%"}], "//", 
      "FullSimplify"}], "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"%%", "[", 
           RowBox[{"[", 
            RowBox[{"-", "1"}], "]"}], "]"}], "==", "0"}], ",", 
         RowBox[{
          RowBox[{"%%", "[", 
           RowBox[{"[", 
            RowBox[{"-", "4"}], "]"}], "]"}], "==", "0"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"\[ScriptCapitalK]", "''"}], "[", "r", "]"}], ",", 
         RowBox[{
          RowBox[{"\[ScriptCapitalK]", "'"}], "[", "r", "]"}]}], "}"}]}], 
      "]"}], "//", "FullSimplify"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"%%%", "/.", "%"}], "//", "FullSimplify"}], "//", "simplin"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"algrel", "=", 
     RowBox[{"%%", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "4"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.962967583175093*^9, 3.962967632897705*^9}, {
  3.962967774322752*^9, 3.96296779213274*^9}, {3.962967848180893*^9, 
  3.962967884030758*^9}, {3.962967918961994*^9, 3.962967948269449*^9}, {
  3.9629680042973785`*^9, 3.9629680404251957`*^9}, {3.962968096282316*^9, 
  3.962968273662985*^9}, {3.962968332985586*^9, 3.96296834405542*^9}, {
  3.9630274960069942`*^9, 3.963027500422867*^9}, {3.9630308423100014`*^9, 
  3.9630308607968445`*^9}, {3.963038261167595*^9, 3.963038261725788*^9}, {
  3.963290116359705*^9, 3.963290116880953*^9}},
 CellLabel->"In[44]:=",ExpressionUUID->"ae1a4069-8312-c247-8722-583a4ed34201"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", "rs"}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "-", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", 
         " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", 
         RowBox[{"H1", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "-", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "-", 
           FractionBox[
            RowBox[{"2", " ", "rs"}], "r"]}], ")"}], " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"], "-", 
           FractionBox[
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"rs", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r"}]]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.962967628262099*^9, 3.962967633666376*^9}, 
   3.962967794219045*^9, {3.9629678511236935`*^9, 3.9629678845214386`*^9}, {
   3.962967935556061*^9, 3.962967948966175*^9}, 3.962968040910078*^9, 
   3.9629681308953853`*^9, 3.9629682424581757`*^9, 3.9629682853374424`*^9, 
   3.962968334555355*^9, 3.963027501771797*^9, 3.96303827919104*^9, {
   3.9632901126526165`*^9, 3.96329011881176*^9}},
 CellLabel->
  "Out[46]//MatrixForm=",ExpressionUUID->"db8ba8f6-c255-c44c-8299-\
541c5770d23c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{
         "4", " ", "\[ImaginaryI]", " ", "r", " ", "rs", " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}]}], 
            RowBox[{
             RowBox[{"-", "r"}], "+", "rs"}]], "+", 
           RowBox[{"2", " ", "r", " ", "\[Omega]", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], "+", 
              FractionBox[
               RowBox[{
                SuperscriptBox["r", "2"], " ", "\[Omega]"}], 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}], "2"]]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"L", "+", 
           SuperscriptBox["L", "2"], "+", 
           FractionBox[
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r"}], "-", 
               RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]"}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], "2"]]}], ")"}], " ", 
         RowBox[{"H1", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            SuperscriptBox["r", "2"], " ", "\[Omega]"}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {"0"},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "-", 
           FractionBox[
            RowBox[{"2", " ", "rs"}], "r"], "+", 
           FractionBox[
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "L"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["r", "3"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], "2"]]}], ")"}], " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"], "-", 
           FractionBox[
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "-", 
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "-", 
           RowBox[{"2", " ", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", "r", "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}]}], 
            RowBox[{
             RowBox[{"-", "r"}], "+", "rs"}]], "+", 
           RowBox[{
            FractionBox["1", "2"], " ", "\[Omega]", " ", 
            RowBox[{"(", 
             RowBox[{"\[ImaginaryI]", "+", 
              FractionBox[
               RowBox[{"4", " ", 
                SuperscriptBox["r", "3"], " ", "\[Omega]"}], 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}], "2"]]}], ")"}]}]}], ")"}], 
         " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["rs", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]], "+", 
           FractionBox[
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r"}], "-", 
               RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]"}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], "2"]]}], ")"}], " ", 
         RowBox[{"H1", "[", "r", "]"}]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Omega]", " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "-", 
           FractionBox["rs", 
            RowBox[{"2", " ", "r"}]], "-", 
           FractionBox[
            RowBox[{"2", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["r", "2"], " ", "\[Omega]"}], 
            RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["H1", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.962967628262099*^9, 3.962967633666376*^9}, 
   3.962967794219045*^9, {3.9629678511236935`*^9, 3.9629678845214386`*^9}, {
   3.962967935556061*^9, 3.962967948966175*^9}, 3.962968040910078*^9, 
   3.9629681308953853`*^9, 3.9629682424581757`*^9, 3.9629682853374424`*^9, 
   3.962968334555355*^9, 3.963027501771797*^9, 3.96303827919104*^9, {
   3.9632901126526165`*^9, 3.9632901223667736`*^9}},
 CellLabel->
  "Out[48]//MatrixForm=",ExpressionUUID->"2e82485d-0937-ff4a-ab75-\
9df7e28ec2a7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["H1", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
       RowBox[{"H0", "[", "r", "]"}]}], 
      RowBox[{"r", "-", "rs"}]]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "r"], "+", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"-", "r"}], "+", "rs"}]]}], ")"}], " ", 
     RowBox[{"H1", "[", "r", "]"}]}], "-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
     RowBox[{"r", "-", "rs"}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.962967628262099*^9, 3.962967633666376*^9}, 
   3.962967794219045*^9, {3.9629678511236935`*^9, 3.9629678845214386`*^9}, {
   3.962967935556061*^9, 3.962967948966175*^9}, 3.962968040910078*^9, 
   3.9629681308953853`*^9, 3.9629682424581757`*^9, 3.9629682853374424`*^9, 
   3.962968334555355*^9, 3.963027501771797*^9, 3.96303827919104*^9, {
   3.9632901126526165`*^9, 3.9632901224143314`*^9}},
 CellLabel->"Out[49]=",ExpressionUUID->"b593a21d-351c-444d-afa9-b52524e2a1d4"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"0"},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}]}], 
            RowBox[{
             RowBox[{"-", "r"}], "+", "rs"}]], "-", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]"}]}], 
          ")"}], " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"L", "+", 
           SuperscriptBox["L", "2"], "+", 
           FractionBox[
            RowBox[{"4", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]"}], 
            RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
         RowBox[{"H1", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"r", " ", "\[Omega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"\[ImaginaryI]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r"}], "-", 
               RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", "\[Omega]"}]}], ")"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "+", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            SuperscriptBox["r", "2"], " ", "\[Omega]"}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {"0"},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "-", 
           FractionBox[
            RowBox[{"2", " ", "rs"}], "r"], "+", 
           FractionBox[
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}]}], 
            RowBox[{
             RowBox[{"-", "r"}], "+", "rs"}]]}], ")"}], " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"4", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"], "+", 
           FractionBox[
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "-", "r", "+", "rs"}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], "2"]]}], ")"}], " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"4", "-", 
           RowBox[{"2", " ", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"2", "-", "r", "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"-", "r"}], "+", "rs"}]], "+", 
        FractionBox[
         RowBox[{"4", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
        RowBox[{"4", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.962967628262099*^9, 3.962967633666376*^9}, 
   3.962967794219045*^9, {3.9629678511236935`*^9, 3.9629678845214386`*^9}, {
   3.962967935556061*^9, 3.962967948966175*^9}, 3.962968040910078*^9, 
   3.9629681308953853`*^9, 3.9629682424581757`*^9, 3.9629682853374424`*^9, 
   3.962968334555355*^9, 3.963027501771797*^9, 3.96303827919104*^9, {
   3.9632901126526165`*^9, 3.9632901235987473`*^9}},
 CellLabel->
  "Out[51]//MatrixForm=",ExpressionUUID->"79d123a2-a727-1245-8d47-\
3d13f63780a9"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", "0", 
      RowBox[{
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], "r"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", "\[Omega]"}]]}], "+", 
          RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]"}]}], 
         ")"}], " ", 
        RowBox[{"H1", "[", "r", "]"}]}], "-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "L", "+", 
              SuperscriptBox["L", "2"]}], ")"}], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", "L", "+", 
              SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["rs", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["r", "4"], " ", 
            SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
         RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}]}]]}], "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.962967628262099*^9, 3.962967633666376*^9}, 
   3.962967794219045*^9, {3.9629678511236935`*^9, 3.9629678845214386`*^9}, {
   3.962967935556061*^9, 3.962967948966175*^9}, 3.962968040910078*^9, 
   3.9629681308953853`*^9, 3.9629682424581757`*^9, 3.9629682853374424`*^9, 
   3.962968334555355*^9, 3.963027501771797*^9, 3.96303827919104*^9, {
   3.9632901126526165`*^9, 3.963290124395544*^9}},
 CellLabel->
  "Out[54]//MatrixForm=",ExpressionUUID->"cfc079d3-0727-fb45-a390-\
ecf32d7946b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["algrel"], "Input",
 CellChangeTimes->{{3.962968349294031*^9, 3.962968353449589*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"6f2f0334-a6ae-1c45-8f9b-8fb06cd08c0e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
     RowBox[{"H0", "[", "r", "]"}]}], "r"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "2"], " ", "\[Omega]"}]]}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]"}]}], ")"}], 
   " ", 
   RowBox[{"H1", "[", "r", "]"}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["rs", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
   RowBox[{"2", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.962968354776413*^9, 3.963027513634809*^9, 
  3.963290141924942*^9},
 Background->RGBColor[1, 1, 0.85],
 CellLabel->"Out[56]=",ExpressionUUID->"03de9e34-7df0-e24b-a514-5bc8f1fe8c57"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solH0", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"algrel", "==", "0"}], ",", 
       RowBox[{"H0", "[", "r", "]"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
   "simplin"}]}]], "Input",
 CellChangeTimes->{{3.962968975806772*^9, 3.9629690301019115`*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"95345ecb-f096-e143-8943-bfb81f2032c3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"H0", "[", "r", "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
       RowBox[{"H1", "[", "r", "]"}]}], 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
         RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]"}]]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"]}], ")"}], " ", 
         SuperscriptBox["r", "2"]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "3"}], "+", "L", "+", 
           SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["rs", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["r", "4"], " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
      RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{"3", " ", "rs"}]}], ")"}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.962969013883314*^9, 3.962969030688038*^9}, 
   3.963027516570246*^9, 3.9632901721089134`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"9a5f84e9-58cc-c349-beb2-ee1100ddee30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"eqsEven", "/.", 
       RowBox[{"D", "[", 
        RowBox[{"solH0", ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "2"}], "}"}]}], "]"}]}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"solH0", ",", "r"}], "]"}]}], "/.", "solH0"}], "//", 
    "FullSimplify"}], "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"eq1", ",", "eq2"}], "}"}], "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        FractionBox[
         RowBox[{"%%", "[", 
          RowBox[{"[", "2", "]"}], "]"}], 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", "\[Omega]"}]], ",", 
        FractionBox[
         RowBox[{"%%", "[", 
          RowBox[{"[", "5", "]"}], "]"}], 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]"}], 
          RowBox[{"2", " ", "r"}]]]}], "}"}], "/.", 
      RowBox[{"{", 
       RowBox[{"H1", "->", 
        RowBox[{"Function", "[", 
         RowBox[{"r", ",", 
          RowBox[{"\[Omega]", " ", 
           RowBox[{"\[ScriptCapitalR]", "[", "r", "]"}]}]}], "]"}]}], "}"}]}],
      "//", "FullSimplify"}], "//", "simplin"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.962969034305353*^9, 3.96296908035926*^9}, {
  3.962969165488838*^9, 3.962969204499592*^9}, {3.962969280960493*^9, 
  3.962969307343872*^9}, {3.962969597512356*^9, 3.962969604922489*^9}, {
  3.962970882380804*^9, 3.962970903599565*^9}, {3.9629711182950916`*^9, 
  3.9629711210070877`*^9}, {3.9629711844191847`*^9, 3.962971197739525*^9}, {
  3.962971350379801*^9, 3.9629713629282436`*^9}, {3.9630383029058704`*^9, 
  3.9630383034619064`*^9}},
 CellLabel->"In[58]:=",ExpressionUUID->"8733b388-29b0-5440-89f6-d7906eb9b957"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{
             FractionBox[
              RowBox[{"2", " ", 
               SuperscriptBox["r", "3"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "r"}], "-", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
               SuperscriptBox["\[Omega]", "2"]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
             FractionBox[
              RowBox[{"24", " ", 
               SuperscriptBox["r", "3"], " ", 
               SuperscriptBox["\[Omega]", "2"]}], 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"3", " ", "rs"}]}]], "-", 
             FractionBox[
              RowBox[{"24", " ", 
               SuperscriptBox["r", "3"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
               SuperscriptBox["\[Omega]", "2"]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], "2"]], "-", 
             FractionBox[
              RowBox[{"6", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
                  SuperscriptBox["r", "2"]}], "+", 
                 RowBox[{"3", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                 "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"L", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], "3"]], "+", 
             FractionBox[
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"L", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"L", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["r", "3"], " ", 
                  SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                 RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
             FractionBox[
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"L", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}], " ", "rs", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                    RowBox[{"3", " ", "rs"}]}], ")"}]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                    RowBox[{"6", " ", "rs"}]}], ")"}], " ", 
                  SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"r", "-", "rs"}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                  RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]]}], ")"}], " ", 
           RowBox[{"H1", "[", "r", "]"}]}], 
          RowBox[{
           SuperscriptBox["r", "2"], " ", "\[Omega]"}]]}], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            FractionBox[
             RowBox[{"4", " ", "r", " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"], "-", 
                RowBox[{"12", " ", 
                 SuperscriptBox["r", "2"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
              RowBox[{"3", " ", "rs"}]}]], "+", 
            FractionBox[
             RowBox[{"4", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "-", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "5"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "rs"}]}], ")"}], 
              " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "rs"}], "+", 
                RowBox[{"8", " ", 
                 SuperscriptBox["r", "3"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"]], "-", 
            FractionBox[
             RowBox[{"2", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
                 SuperscriptBox["r", "2"]}], "-", 
                RowBox[{"3", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"2", "+", "L"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "5"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"19", "+", 
                   RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "7"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}]}]}], ")"}], " ", 
                 SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["rs", "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "4"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "3"]], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["r", "3"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "2"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "3"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["rs", "2"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "4"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
              RowBox[{"3", " ", "rs"}]}]], "+", 
            FractionBox[
             RowBox[{"2", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"rs", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                   RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                   "+", 
                   RowBox[{"3", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                    SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "3"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                   RowBox[{"3", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "5"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                   "+", 
                   RowBox[{"12", " ", 
                    SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"]]}], ")"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "3"]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                  SuperscriptBox["r", "2"]}], ")"}]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"5", "+", 
                  RowBox[{"2", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                "rs"}], "-", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "14"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"], " ", "rs"}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", 
               RowBox[{"3", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["rs", "3"]}], "+", 
            RowBox[{"12", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "5"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"48", " ", 
             SuperscriptBox["r", "4"], " ", "rs", " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"2", " ", "rs"}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{"3", " ", "rs"}]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "6"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
              ")"}]}], "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", "rs", " ", 
              SuperscriptBox["\[Omega]", "2"]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"]], "+", 
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}], 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
              RowBox[{"3", " ", "rs"}]}]], "-", 
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["r", "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
              SuperscriptBox["\[Omega]", "2"]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"]], "-", 
            FractionBox[
             RowBox[{"6", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{"3", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                "+", 
                RowBox[{"3", " ", 
                 SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "3"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "3"]], "+", 
            FractionBox[
             RowBox[{"r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "3"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "L"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["r", "3"], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
            FractionBox[
             RowBox[{"2", " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", "rs", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                   RowBox[{"3", " ", "rs"}]}], ")"}]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "3"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                   RowBox[{"6", " ", "rs"}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]]}], ")"}], " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"], "-", 
               RowBox[{"12", " ", 
                SuperscriptBox["r", "2"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "5"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "rs"}]}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "rs"}], "+", 
               RowBox[{"8", " ", 
                SuperscriptBox["r", "3"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "-", 
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "5"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"19", "+", 
                  RowBox[{"L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "7"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}]}]}], ")"}], " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "4"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "L"}], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["r", "3"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "4"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"rs", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"4", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                   SuperscriptBox["r", "2"]}], "-", 
                  RowBox[{"6", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                  "+", 
                  RowBox[{"3", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                   SuperscriptBox["r", "2"]}], "+", 
                  RowBox[{"3", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "5"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                  "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "3"]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "-", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"5", "+", 
                  RowBox[{"2", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                "rs"}], "-", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"3", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "2"], " ", "rs"}], "+", 
            RowBox[{"30", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"54", " ", 
             SuperscriptBox["rs", "3"]}], "-", 
            RowBox[{"24", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "5"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "-", 
            RowBox[{"96", " ", 
             SuperscriptBox["r", "4"], " ", "rs", " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[ImaginaryI]"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "+", 
            RowBox[{"4", " ", "\[ImaginaryI]", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "7"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["rs", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", "rs", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", 
                 SuperscriptBox["r", "2"]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                "-", 
                RowBox[{"3", " ", 
                 SuperscriptBox["rs", "2"]}]}], ")"}]}], 
             RowBox[{
              SuperscriptBox["r", "2"], " ", "\[Omega]"}]], "+", 
            RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"5", "+", 
                  RowBox[{"2", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                "rs"}], "-", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", "\[Omega]"}]}], 
           ")"}], " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "8"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"], " ", "rs"}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}]}]}], ")"}], " ", "r", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"6", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["rs", "3"]}], "+", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"10", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"6", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "10"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "-", 
               RowBox[{"39", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "3"}], "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"4", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["rs", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{"3", " ", "rs"}]}]], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["\[ScriptCapitalK]", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
             "rs"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["rs", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r"}]]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "-", 
               RowBox[{"6", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"6", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H1", "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"6", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"9", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H1", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", "r", " ", "rs"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["rs", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.962969069015825*^9, 3.962969129752168*^9, 
  3.962969231830755*^9, 3.962969330957184*^9, 3.962969625134895*^9, 
  3.962971385228683*^9, 3.963027569578829*^9, 3.9630383353865376`*^9, 
  3.9632902179005375`*^9},
 CellLabel->
  "Out[59]//MatrixForm=",ExpressionUUID->"cd848394-4315-7f43-a0ad-\
c73751feeae3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"eq1", "\[IndentingNewLine]", "eq2"}], "Input",
 CellChangeTimes->{{3.9629692497707863`*^9, 3.9629692535117474`*^9}},
 CellLabel->
  "In[684]:=",ExpressionUUID->"db98f108-002b-ba41-8acc-23d17118515c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "6"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["rs", "2"]}], "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "4"], " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
     RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
    RowBox[{"2", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"3", " ", "rs"}]}], ")"}]}]]}], "-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"L", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", "rs"}]}], ")"}]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalR]", "[", "r", "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
      RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
  RowBox[{
   SuperscriptBox["\[ScriptCapitalK]", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{3.9629692548607674`*^9, 3.962969331036384*^9, 
  3.9629696513305435`*^9, 3.962969765171482*^9, 3.962974484249958*^9, 
  3.9630275770350943`*^9, 3.9630383432261925`*^9},
 CellLabel->
  "Out[684]=",ExpressionUUID->"cb2212e2-478a-914c-b1db-6b943ce58062"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "4"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", 
        SuperscriptBox["r", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
       RowBox[{"9", " ", 
        SuperscriptBox["rs", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "4"], " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
     RowBox[{"\[ScriptCapitalK]", "[", "r", "]"}]}], 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"3", " ", "rs"}]}], ")"}]}]]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{"3", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", "rs"}], 
      "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["rs", "2"]}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
    RowBox[{"\[ScriptCapitalR]", "[", "r", "]"}]}], 
   RowBox[{"2", " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
      RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
  RowBox[{
   SuperscriptBox["\[ScriptCapitalR]", "\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{3.9629692548607674`*^9, 3.962969331036384*^9, 
  3.9629696513305435`*^9, 3.962969765171482*^9, 3.962974484249958*^9, 
  3.9630275770350943`*^9, 3.963038343240265*^9},
 CellLabel->
  "Out[685]=",ExpressionUUID->"40c40e6e-4636-2448-99b6-f18e8c9a6293"]
}, Open  ]],

Cell["\<\
Now  we  \[OpenCurlyQuote]rotate\[CloseCurlyQuote] the variables to put them \
in a Schrodinger like form:\
\>", "Text",
 CellChangeTimes->{{3.9630311125247707`*^9, 
  3.9630311423615894`*^9}},ExpressionUUID->"88ccb73d-179b-6d41-9b07-\
a9e23a66d893"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQm4T1X3x4+kpFAqQ5IQKUOJoihUpoq4XsqbIlHKUEmDkkSR6u1SRFQI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    "], {{0, 32.}, {351.5, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{351.5, 32.},
  PlotRange->{{0, 351.5}, {0, 32.}}]], "Input",ExpressionUUID->"ace34631-9dbb-\
5a4a-be25-f1849051d1be"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQmcTvX+x89l7BJD9nXIkojIniWR6gpZIlKWppRM0ZB0UfeGrlSoKN1s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    "], {{0, 36.5}, {346.5, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{346.5, 36.5},
  PlotRange->{{0, 346.5}, {0, 36.5}}]], "Input",ExpressionUUID->"4d0221ac-\
c552-424a-be9c-5d906686d9f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"rotate", ",", " ", 
    RowBox[{"and", " ", "then", " ", "impose", " ", "what", " ", "we", " ", 
     RowBox[{"want", ":"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"eq1", ",", "eq2"}], "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[ScriptCapitalK]", "->", 
          RowBox[{"Function", "[", 
           RowBox[{"r", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"ff", "[", "r", "]"}], 
              RowBox[{"k", "[", "r", "]"}]}], "+", 
             RowBox[{"Rp", "[", "r", "]"}]}]}], "]"}]}], ",", 
         RowBox[{"\[ScriptCapitalR]", "->", 
          RowBox[{"Function", "[", 
           RowBox[{"r", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"h", "[", "r", "]"}], 
              RowBox[{"k", "[", "r", "]"}]}], "+", 
             RowBox[{
              RowBox[{"kk", "[", "r", "]"}], 
              RowBox[{"Rp", "[", "r", "]"}]}]}]}], "]"}]}]}], "}"}]}], "//", 
      "FullSimplify"}], "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"%", "//.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"k", "[", "r", "]"}], ",", "r"}], "]"}], "->", 
          RowBox[{
           FractionBox["1", 
            RowBox[{"f", "[", "r", "]"}]], 
           RowBox[{"Rp", "[", "r", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"Rp", "[", "r", "]"}], ",", "r"}], "]"}], "->", 
          RowBox[{
           FractionBox["1", 
            RowBox[{"f", "[", "r", "]"}]], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"VZ", "[", "r", "]"}], "-", 
             SuperscriptBox["\[Omega]", "2"]}], ")"}], 
           RowBox[{"k", "[", "r", "]"}]}]}]}], "}"}]}], "//", 
      "FullSimplify"}], "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"isolate", " ", "eqs", " ", "for", " ", "coefficients", " ", 
      RowBox[{"ff", "[", "r", "]"}]}], ",", " ", 
     RowBox[{"h", "[", "r", "]"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"kk", "[", "r", "]"}], " ", "and", " ", 
       RowBox[{"VZ", "[", "r", "]"}]}], ":"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"newEqs", "=", 
     RowBox[{"Collect", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"%", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Rp", "[", "r", "]"}], ",", 
              RowBox[{"k", "[", "r", "]"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Coefficient", "[", 
           RowBox[{
            RowBox[{"%", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Rp", "[", "r", "]"}], ",", 
              RowBox[{"k", "[", "r", "]"}]}], "}"}]}], "]"}]}], "}"}], "//", 
        "Flatten"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ff", "[", "r", "]"}], ",", 
         RowBox[{"h", "[", "r", "]"}], ",", 
         RowBox[{"kk", "[", "r", "]"}], ",", 
         RowBox[{
          RowBox[{"ff", "'"}], "[", "r", "]"}], ",", 
         RowBox[{
          RowBox[{"h", "'"}], "[", "r", "]"}], ",", 
         RowBox[{
          RowBox[{"kk", "'"}], "[", "r", "]"}]}], "}"}], ",", 
       "FullSimplify"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.962969841862948*^9, 3.962969844951813*^9}, {
   3.9629716770538025`*^9, 3.9629717818117294`*^9}, {3.962971912815657*^9, 
   3.962971965924869*^9}, 3.962972069408407*^9, {3.962972111719238*^9, 
   3.9629721137675323`*^9}, {3.962972179777832*^9, 3.9629721930472746`*^9}, {
   3.962972249798527*^9, 3.962972310576496*^9}, {3.962972459378982*^9, 
   3.962972461371033*^9}, {3.9629726612779636`*^9, 3.9629727552536793`*^9}, {
   3.962972790128301*^9, 3.9629727913884735`*^9}, {3.962972833878088*^9, 
   3.962972854599842*^9}, {3.96297304527631*^9, 3.962973066088449*^9}, {
   3.96297316150918*^9, 3.9629732115129232`*^9}, {3.9629734055809574`*^9, 
   3.9629734664118385`*^9}, {3.962973558011069*^9, 3.962973605629378*^9}, {
   3.9629741968264465`*^9, 3.962974203184829*^9}, {3.963027082116089*^9, 
   3.96302709351396*^9}, {3.9630275931235676`*^9, 3.963027594708498*^9}, {
   3.963027641732666*^9, 3.963027677735935*^9}, {3.9630277654768085`*^9, 
   3.9630277661595154`*^9}, {3.963027813009676*^9, 3.9630278247929535`*^9}, {
   3.9630281126199207`*^9, 3.9630281512211647`*^9}, {3.963028186607378*^9, 
   3.9630282026571846`*^9}, {3.9630282843558807`*^9, 
   3.9630282846400948`*^9}, {3.9630313263351936`*^9, 
   3.9630313930132294`*^9}, {3.963031452196707*^9, 3.963031470623123*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"0697a9bc-f232-3849-affe-2a4960e46dea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"newEqs", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"eliminate", " ", 
    RowBox[{"ff", "[", "r", "]"}], " ", "and", " ", 
    RowBox[{"h", "[", "r", "]"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"%%", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "==", "0"}], ",", 
        RowBox[{
         RowBox[{"%%", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "==", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ff", "[", "r", "]"}], ",", 
        RowBox[{"h", "[", "r", "]"}]}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"%%%", "/.", 
      RowBox[{"D", "[", 
       RowBox[{"%", ",", "r"}], "]"}]}], "/.", "%"}], "//", "FullSimplify"}], 
   "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"eliminate", " ", "VZ"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"solVZ", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"%%", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "==", "0"}], ",", 
      RowBox[{"VZ", "[", "r", "]"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], "//", 
   "FullSimplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"eqkk", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"%%%", "[", 
      RowBox[{"[", "4", "]"}], "]"}], "/.", 
     RowBox[{"D", "[", 
      RowBox[{"%", ",", "r"}], "]"}]}], "/.", "%"}], "//", 
   "FullSimplify"}]}]}], "Input",
 CellChangeTimes->{{3.96297354297958*^9, 3.962973544204111*^9}, {
   3.962973635337848*^9, 3.962973643556278*^9}, {3.962973678377865*^9, 
   3.962973745958*^9}, {3.962973787701042*^9, 3.962973790317377*^9}, {
   3.962973923872156*^9, 3.962973935224716*^9}, {3.962974011156193*^9, 
   3.962974061705448*^9}, {3.9629741091309757`*^9, 3.9629741509611034`*^9}, {
   3.962974243262064*^9, 3.9629742607716107`*^9}, 3.9630283379884605`*^9, {
   3.9630284400662613`*^9, 3.963028455216755*^9}, {3.963028512886841*^9, 
   3.9630285209928455`*^9}, {3.9630285965964355`*^9, 3.963028605251915*^9}, {
   3.9630299788725853`*^9, 3.963029979734684*^9}, {3.963030242993332*^9, 
   3.9630302449648457`*^9}, {3.9630314979324856`*^9, 
   3.9630315195811424`*^9}},ExpressionUUID->"56629b9f-85ef-2743-9e21-\
4ef0f6018d50"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"r", " ", "rs", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "6"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
              RowBox[{"6", " ", "rs"}]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["r", "5"], " ", 
            SuperscriptBox["\[Omega]", "2"]}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}]}]]}], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"ff", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"2", " ", "rs"}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"kk", "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]]}]},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "6"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["rs", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["r", "4"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
           RowBox[{"ff", "[", "r", "]"}]}], 
          RowBox[{"2", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}]}]]}], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"2", " ", "rs"}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"h", "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"VZ", "[", "r", "]"}]}], ")"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{
         SuperscriptBox["ff", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "4"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
             RowBox[{"9", " ", 
              SuperscriptBox["rs", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["r", "4"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}]}]]}], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"h", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
             "rs"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["rs", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"kk", "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
        RowBox[{
         SuperscriptBox["kk", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", 
              SuperscriptBox["r", "2"]}], "+", 
             RowBox[{"4", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "4"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
             RowBox[{"9", " ", 
              SuperscriptBox["rs", "2"]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["r", "4"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
           RowBox[{"ff", "[", "r", "]"}]}], 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}]}]]}], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", 
               RowBox[{"3", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
             "rs"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["rs", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"h", "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"kk", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"VZ", "[", "r", "]"}]}], ")"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        RowBox[{
         SuperscriptBox["h", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9630285230729065`*^9, 3.9630296630689583`*^9, 
  3.963029981150524*^9, 3.9630302457938023`*^9},
 CellLabel->
  "Out[521]//MatrixForm=",ExpressionUUID->"f240b0a3-5849-dd48-a5e8-\
40616649c9eb"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"0"},
      {
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], "2"]}], " ", 
                SuperscriptBox["r", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "7"}], "+", 
                  RowBox[{"2", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                SuperscriptBox["r", "2"], " ", "rs"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "19"}], "+", 
                  RowBox[{"8", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                SuperscriptBox["rs", "2"]}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "3"]}]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "4"], " ", "rs", " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"kk", "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"VZ", "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["L", "5"], " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{
           SuperscriptBox["L", "6"], " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{
           SuperscriptBox["L", "3"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"7", " ", "r"}], "-", 
             RowBox[{"10", " ", "rs"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["L", "4"], " ", 
           SuperscriptBox["r", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"5", " ", "rs"}]}], ")"}]}], "-", 
          RowBox[{"3", " ", "rs", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"6", " ", "r", " ", "rs"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["r", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
           SuperscriptBox["\[Omega]", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["L", "2"], " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"11", " ", "r", " ", "rs"}], "-", 
             RowBox[{"12", " ", 
              SuperscriptBox["rs", "2"]}], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["r", "4"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", "L", " ", "r", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["r", "2"], "-", 
             RowBox[{"4", " ", "r", " ", "rs"}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["rs", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["r", "4"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"2", " ", "rs"}]}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
           RowBox[{
            SuperscriptBox["kk", "\[Prime]",
             MultilineFunction->None], "[", "r", "]"}]}]}], 
         RowBox[{
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "2"}], "+", "L", "+", 
                SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]]}]},
      {"0"},
      {
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", 
          SuperscriptBox["r", "3"], " ", "rs", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "\[ImaginaryI]", " ", 
          SuperscriptBox["r", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"6", " ", "rs"}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{
          RowBox[{"kk", "[", "r", "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["L", "5"], " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "r"}], "+", "rs"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["L", "6"], " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "r"}], "+", "rs"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["L", "3"], " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"7", " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"9", " ", "r", " ", "rs"}], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["L", "4"], " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["r", "2"], "-", 
               RowBox[{"2", " ", "r", " ", "rs"}], "-", 
               SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["L", "2"], " ", "r", " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"16", " ", "r", " ", "rs"}], "-", 
               RowBox[{"18", " ", 
                SuperscriptBox["rs", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "4"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
            RowBox[{"rs", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "r"}], "-", 
                  RowBox[{"3", " ", "rs"}]}], ")"}], "3"], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "5"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
            RowBox[{"L", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                SuperscriptBox["r", "3"]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"], " ", "rs"}], "+", 
               RowBox[{"17", " ", "r", " ", 
                SuperscriptBox["rs", "2"]}], "-", 
               RowBox[{"18", " ", 
                SuperscriptBox["rs", "3"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "4"], " ", "rs", " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
             RowBox[{"VZ", "[", "r", "]"}]}]}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "rs"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "6"}], " ", "r"}], "+", 
                  RowBox[{"4", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "+", 
                  RowBox[{"9", " ", "rs"}]}], ")"}]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "4"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["kk", "\[Prime]",
               MultilineFunction->None], "[", "r", "]"}]}], "-", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
             RowBox[{
              SuperscriptBox["kk", "\[Prime]\[Prime]",
               MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
            RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9630285230729065`*^9, 3.9630296630689583`*^9, 
  3.963029981150524*^9, 3.96303024885235*^9},
 CellLabel->
  "Out[524]//MatrixForm=",ExpressionUUID->"fa577eb8-e822-c344-9bbb-\
ce977ed33ba3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VZ", "[", "r", "]"}], "\[Rule]", 
   RowBox[{"-", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["r", "5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"L", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "L"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
               SuperscriptBox["r", "3"]}], "-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"2", "+", "L"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "7"}], "+", 
                 RowBox[{"2", " ", "L", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
               SuperscriptBox["r", "2"], " ", "rs"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"19", "-", 
                 RowBox[{"8", " ", "L", " ", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
               SuperscriptBox["rs", "2"]}], "-", 
              RowBox[{"9", " ", 
               SuperscriptBox["rs", "3"]}]}], ")"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "L", "+", 
              SuperscriptBox["L", "2"]}], ")"}], " ", 
            SuperscriptBox["r", "4"], " ", "rs", " ", 
            SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
         RowBox[{"kk", "[", "r", "]"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "L"}], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "L"}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "L"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "6"}], "+", 
              RowBox[{"5", " ", "L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox["r", "2"], " ", "rs"}], "-", 
           RowBox[{"6", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "3"}], "+", 
              RowBox[{"2", " ", "L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox["rs", "2"]}], "-", 
           RowBox[{"9", " ", 
            SuperscriptBox["rs", "3"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["r", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
              RowBox[{"6", " ", "rs"}]}], ")"}], " ", 
            SuperscriptBox["\[Omega]", "2"]}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
              RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                 RowBox[{"2", " ", "rs"}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["r", "3"], " ", 
               SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["kk", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.9630285230729065`*^9, 3.9630296630689583`*^9, 
  3.963029981150524*^9, 3.9630302493190536`*^9},
 CellLabel->
  "Out[525]=",ExpressionUUID->"72666932-fa77-4444-b14c-24d7d1ca7498"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "L", "+", 
       SuperscriptBox["L", "2"]}], ")"}], " ", 
     SuperscriptBox["r", "3"], " ", "rs", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"3", " ", "rs"}]}], ")"}]}], "+", 
    RowBox[{"4", " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["r", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"6", " ", "rs"}]}], ")"}], " ", 
     SuperscriptBox["\[Omega]", "2"]}], "+", 
    RowBox[{
     RowBox[{"kk", "[", "r", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"rs", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "L"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "5"}], "+", 
             RowBox[{"2", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "L"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "11"}], "+", 
             RowBox[{"2", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
           SuperscriptBox["r", "2"], " ", "rs"}], "-", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "27"}], "+", 
             RowBox[{"10", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
           SuperscriptBox["rs", "2"]}], "-", 
          RowBox[{"36", " ", 
           SuperscriptBox["rs", "3"]}]}], ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "4"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"9", " ", "r", " ", "rs"}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "-", 
       RowBox[{
        FractionBox["1", "r"], 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], "2"]}], " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", "L"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "7"}], "+", 
                    RowBox[{"2", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                  SuperscriptBox["r", "2"], " ", "rs"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "19"}], "+", 
                    RowBox[{"8", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                  SuperscriptBox["rs", "2"]}], "+", 
                 RowBox[{"9", " ", 
                  SuperscriptBox["rs", "3"]}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", 
               SuperscriptBox["r", "4"], " ", "rs", " ", 
               SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
            RowBox[{"kk", "[", "r", "]"}]}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", "L", "+", 
                 SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
              RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
                 RowBox[{"2", " ", "rs"}]}], ")"}]}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["r", "3"], " ", 
               SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
            RowBox[{
             SuperscriptBox["kk", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}]}], 
      ")"}]}], "+", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "rs"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "6"}], "+", 
                RowBox[{"4", " ", "L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r"}], "+", 
             RowBox[{"9", " ", "rs"}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["kk", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}], "-", 
       RowBox[{"r", " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["kk", "\[Prime]\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], ")"}], 
  "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["r", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.9630285230729065`*^9, 3.9630296630689583`*^9, 
  3.963029981150524*^9, 3.96303024957753*^9},
 CellLabel->
  "Out[526]=",ExpressionUUID->"760c9e12-45bb-9748-a274-efd989cd5917"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"kk", "[", "r", "]"}], " ", "has", " ", "to", " ", "be", " ", 
     "independent", " ", "of", " ", "\[Omega]"}], ",", " ", 
    RowBox[{"so", " ", "we", " ", "just", " ", "take", " ", "the", " ", 
     SuperscriptBox["\[Omega]", "2"], " ", "coeff", " ", "and", " ", "solve", 
     " ", "this", "\[IndentingNewLine]", "we", " ", "check", " ", "that", " ",
      "the", " ", "full", " ", "eq", " ", "is", " ", "solved", " ", "by", " ",
      "this", " ", 
     RowBox[{"solution", ":"}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Coefficient", "[", 
     RowBox[{"eqkk", ",", 
      SuperscriptBox["\[Omega]", "2"]}], "]"}], "//", "FullSimplify"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DSolve", "[", 
      RowBox[{
       RowBox[{"%", "==", "0"}], ",", 
       RowBox[{"kk", "[", "r", "]"}], ",", "r"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"eqkk", "/.", 
       RowBox[{"D", "[", 
        RowBox[{"%", ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "2"}], "}"}]}], "]"}]}], "/.", 
      RowBox[{"D", "[", 
       RowBox[{"%", ",", "r"}], "]"}]}], "/.", "%"}], "//", "FullSimplify"}], 
   "\[IndentingNewLine]", 
   RowBox[{"VZerilli", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"VZ", "[", "r", "]"}], "/.", "solVZ"}], "/.", 
       RowBox[{"D", "[", 
        RowBox[{"%%", ",", "r"}], "]"}]}], "/.", "%%"}], "//", 
     "FullSimplify"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9630299896868286`*^9, 3.963030009983492*^9}, {
  3.9630301395388165`*^9, 3.9630301671946983`*^9}, {3.9630302610989475`*^9, 
  3.9630302964429493`*^9}, {3.9630315266708813`*^9, 3.9630316204596615`*^9}},
 CellLabel->
  "In[573]:=",ExpressionUUID->"7cfdc42b-7ce0-504c-aff7-31dee3168f8d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["r", "2"], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}], " ", 
       RowBox[{"kk", "[", "r", "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
         RowBox[{"6", " ", "rs"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", "rs", " ", 
       RowBox[{"kk", "[", "r", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
         RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["kk", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
       RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.9630300122514267`*^9, {3.9630301413538437`*^9, 3.963030167521517*^9}, {
   3.963030281012108*^9, 3.9630303018814983`*^9}, 3.9630316320906487`*^9},
 CellLabel->
  "Out[573]=",ExpressionUUID->"02d1fa48-185e-e84e-ac3b-39f3b6fd0125"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"kk", "[", "r", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["r", "2"]}], 
    RowBox[{
     RowBox[{"-", "r"}], "+", "rs"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9630300122514267`*^9, {3.9630301413538437`*^9, 3.963030167521517*^9}, {
   3.963030281012108*^9, 3.9630303018814983`*^9}, 3.963031632231699*^9},
 CellLabel->
  "Out[574]=",ExpressionUUID->"69de6f97-c102-7347-bad9-907a27e55d73"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{
  3.9630300122514267`*^9, {3.9630301413538437`*^9, 3.963030167521517*^9}, {
   3.963030281012108*^9, 3.9630303018814983`*^9}, 3.9630316322377224`*^9},
 CellLabel->
  "Out[575]=",ExpressionUUID->"e76d9078-40d6-7241-959a-50c4c6c6fa0a"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["r", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "L"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox["r", "4"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "L", "+", 
        SuperscriptBox["L", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox["r", "3"], " ", "rs"}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", "L", "+", 
        SuperscriptBox["L", "2"]}], ")"}], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox["rs", "2"]}], "+", 
     RowBox[{"9", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "L", "+", 
        SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", 
      SuperscriptBox["rs", "3"]}], "+", 
     RowBox[{"9", " ", 
      SuperscriptBox["rs", "4"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.9630300122514267`*^9, {3.9630301413538437`*^9, 3.963030167521517*^9}, {
   3.963030281012108*^9, 3.9630303018814983`*^9}, 3.9630316324361*^9},
 CellLabel->
  "Out[576]=",ExpressionUUID->"7c4d194f-fb3c-1f4c-aef4-e87ddec4d1ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VZerilli", "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.963030307902334*^9, 3.963030316457344*^9}},
 CellLabel->
  "In[534]:=",ExpressionUUID->"90fe1fdb-25ae-2944-a9bc-534d6b88f33d"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["r", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
        RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "L"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox["r", "4"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "L", "+", 
        SuperscriptBox["L", "2"]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
      SuperscriptBox["r", "3"], " ", "rs"}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", "L", "+", 
        SuperscriptBox["L", "2"]}], ")"}], " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox["rs", "2"]}], "+", 
     RowBox[{"9", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "L", "+", 
        SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", 
      SuperscriptBox["rs", "3"]}], "+", 
     RowBox[{"9", " ", 
      SuperscriptBox["rs", "4"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.9630303104919434`*^9, 3.9630303168173485`*^9}},
 Background->RGBColor[1, 1, 0.85],
 CellLabel->
  "Out[534]=",ExpressionUUID->"70f2a68e-9fdc-6745-8a88-2a2edcbc99c3"]
}, Open  ]],

Cell["Check:", "Text",
 CellChangeTimes->{{3.9630304009731636`*^9, 3.9630304104061337`*^9}, 
   3.963030706389887*^9},ExpressionUUID->"d112a4c1-ceb0-994a-a230-\
a5a8300534e8"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztXQeUFUXWbphVYARJQ5CcFViC5CAMAgKuIEkEASXnoCBIElEUQVCSoiCY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    "], {{0, 47.}, {357., 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{357., 47.},
  PlotRange->{{0, 357.}, {0, 47.}}]], "Input",ExpressionUUID->"9d9bb1de-cd1c-\
5945-a940-21aa53f3a1c5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"VZpaper", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"2", "m"}], "r"]}], ")"}], 
    FractionBox[
     RowBox[{
      RowBox[{"2", 
       SuperscriptBox["\[Lambda]", "2"], 
       RowBox[{"(", 
        RowBox[{"\[Lambda]", "+", "1"}], ")"}], 
       SuperscriptBox["r", "3"]}], "+", 
      RowBox[{"6", 
       SuperscriptBox["\[Lambda]", "2"], "m", " ", 
       SuperscriptBox["r", "2"]}], "+", 
      RowBox[{"18", " ", "\[Lambda]", " ", 
       SuperscriptBox["m", "2"], "r"}], "+", 
      RowBox[{"18", 
       SuperscriptBox["m", "3"]}]}], 
     RowBox[{
      SuperscriptBox["r", "3"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[Lambda]", " ", "r"}], " ", "+", " ", 
         RowBox[{"3", "m"}]}], ")"}], "2"]}]]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VZpaper", "/.", 
      RowBox[{"{", 
       RowBox[{"m", "->", 
        RowBox[{"rs", "/", "2"}]}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"\[Lambda]", "->", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"(", 
         RowBox[{"L", "+", "2"}], ")"}], 
        RowBox[{"(", 
         RowBox[{"L", "-", "1"}], ")"}]}]}], "}"}]}], "//", "Expand"}], "//", 
   "FullSimplify"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "==", "VZerilli"}], "//", "FullSimplify"}]}], "Input",
 CellChangeTimes->{{3.963030425728533*^9, 3.963030697103462*^9}},
 CellLabel->
  "In[555]:=",ExpressionUUID->"d5a01250-c4b3-c442-b697-6594fc7880ca"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.9630305863509693`*^9, 3.963030697729187*^9}},
 CellLabel->
  "Out[557]=",ExpressionUUID->"c0d77639-cf01-3b49-b13e-3dd734c699e4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"VZZZ", "[", 
    RowBox[{"r_", ",", "L_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
          RowBox[{"3", " ", "rs"}]}], ")"}], "2"]}]]}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "L"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "4"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", "L", "+", 
          SuperscriptBox["L", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["r", "3"], " ", "rs"}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "5"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", 
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox["rs", "2"]}], "+", 
      RowBox[{"9", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "L", "+", 
         SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", 
       SuperscriptBox["rs", "3"]}], "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["rs", "4"]}]}], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9630320010180206`*^9, 3.9630320230050793`*^9}, 
   3.9630350102597675`*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"6653e569-f085-aa4c-9fc4-d17017fbacfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Plot  of  VZerilli", "Subsection",
 CellChangeTimes->{{3.963035545149473*^9, 3.9630355557350445`*^9}, 
   3.9630383522347507`*^9},ExpressionUUID->"839be787-367b-154b-ba82-\
10e63fb6cc78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"VZerilli", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rs", "->", "1"}], ",", 
     RowBox[{"L", "->", "2"}]}], "}"}]}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"VZZZ", "[", 
      RowBox[{"r", ",", "2"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{"rs", "->", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0.5", ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9630316614313564`*^9, 3.96303171614472*^9}, {
  3.96303499900082*^9, 3.9630349992020054`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"95135afd-cd20-bd4c-bc6d-9a5fd6c87817"],

Cell[BoxData["VZerilli"], "Output",
 CellChangeTimes->{{3.963031699013956*^9, 3.963031716761448*^9}, 
   3.963032031117502*^9, 3.9630348780023804`*^9, {3.9630349995783043`*^9, 
   3.963035012138628*^9}, 3.963290583728813*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"87785ed9-9352-6647-abbc-c08a54ad6591"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], LineBox[CompressedData["
1:eJwd13k4Fe/7B3CSkN0pkhYhFO2WUL0nbShLUihLX5FWUlKfsiSJZEmSEEmK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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwd13k4Fe/7B3CSkN0pkhYhFO2WUL0nbShLUihLX5FWUlKfsiSJZEmSEEmK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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0.5, 5}, {-0.35982108893920206`, 
             0.6052424161948331}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0.5000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0.5, 5}, {-0.35982108893920206`, 
            0.6052424161948331}}, "Frame" -> {{False, False}, {False, False}},
           "AxesOrigin" -> {0.5000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwd13k4Fe/7B3CSkN0pkhYhFO2WUL0nbShLUihLX5FWUlKfsiSJZEmSEEmK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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{0.5, 5}, {-0.35982108893920206`, 0.6052424161948331}},
        "Frame" -> {{False, False}, {False, False}}, 
       "AxesOrigin" -> {0.5000000000000011, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.5000000000000011, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.5, 5}, {-0.35982108893920206`, 0.6052424161948331}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.963031699013956*^9, 3.963031716761448*^9}, 
   3.963032031117502*^9, 3.9630348780023804`*^9, {3.9630349995783043`*^9, 
   3.963035012138628*^9}, 3.9632905839636307`*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"dc737ec5-a9e3-954f-b897-aa4bfc8dc021"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQt8ztUfx59Yotas0MWaKKUwwohFJaIbYa6vTCgWNZe5NMumaLmliEYX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    "], {{0, 22.5}, {159.5, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{159.5, 22.5},
  PlotRange->{{0, 159.5}, {0, 22.5}}]], "Input",ExpressionUUID->"ef1f6bb4-\
14e6-b743-8a4a-cd0ca223a172"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VZZZ", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VZZZ", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "3"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VZZZ", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "5"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<L=2\>\"", ",", "\"\<L=3\>\"", ",", "\"\<L=5\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9630354307100735`*^9, 3.963035446356287*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"3e750fad-e195-0245-a9fb-b40fd2272208"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVUnk41P0XlS1LZAm9QpZsUVRjkLgflG2SpV7Zl7KUImmxFKGQ14SylXUU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            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVlHk41PsXx4WS7CTLlYsoS9lNlsv52CvKUhclaUFF1ksm2ihKhJskNSN7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            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVU3k01IsXZ5B95pslkYQQEWIMUt0rqaRS9KREenmlSCiFqOxlT5LIUkk8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            "]]}, Annotation[#, "Charting`Private`Tag#3"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
               Line[CompressedData["
1:eJwVUnk41P0XlS1LZAm9QpZsUVRjkLgflG2SpV7Zl7KUImmxFKGQ14SylXUU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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Line[CompressedData["
1:eJwVlHk41PsXx4WS7CTLlYsoS9lNlsv52CvKUhclaUFF1ksm2ihKhJskNSN7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                "]]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Line[CompressedData["
1:eJwVU3k01IsXZ5B95pslkYQQEWIMUt0rqaRS9KREenmlSCiFqOxlT5LIUkk8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                "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
             "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.560181, 0.691569, 0.194885]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.880722, 0.611041, 0.142051]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.368417, 0.506779, 0.709798]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>], 
        ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]], 
           Line[CompressedData["
1:eJwVUnk41P0XlS1LZAm9QpZsUVRjkLgflG2SpV7Zl7KUImmxFKGQ14SylXUU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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Line[CompressedData["
1:eJwVlHk41PsXx4WS7CTLlYsoS9lNlsv52CvKUhclaUFF1ksm2ihKhJskNSN7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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Line[CompressedData["
1:eJwVU3k01IsXZ5B95pslkYQQEWIMUt0rqaRS9KREenmlSCiFqOxlT5LIUkk8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            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> Identity, 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> 1, Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, 
    Method -> {
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None}, PlotRange -> {All, All}, PlotRangeClipping -> 
    True, PlotRangePadding -> {{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"L=2\"", "\"L=3\"", "\"L=5\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.9630354402445965`*^9, 3.9630354469805717`*^9}, 
   3.9632906002828827`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"fd9b7e52-b61e-c84c-b3e6-1715b550479d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"VZZZ", "[", 
           RowBox[{"r", ",", "L"}], "]"}], 
          SuperscriptBox["L", "2"]], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"VZZZ", "[", 
           RowBox[{"r", ",", "L"}], "]"}], 
          SuperscriptBox["L", "2"]], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "5"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"VZZZ", "[", 
           RowBox[{"r", ",", "L"}], "]"}], 
          SuperscriptBox["L", "2"]], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "20"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<L=2\>\"", ",", "\"\<L=3\>\"", ",", "\"\<L=5\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9630319469991207`*^9, 3.963031978522726*^9}, {
  3.9630320343997803`*^9, 3.9630321076922474`*^9}, {3.9630345939578247`*^9, 
  3.963034621545227*^9}, {3.9630348529066334`*^9, 3.9630348539564667`*^9}, {
  3.9630348867223816`*^9, 3.9630349123728848`*^9}, {3.9630350587513294`*^9, 
  3.963035124123087*^9}, {3.96303516608922*^9, 3.9630352681396713`*^9}, {
  3.9630353643634796`*^9, 3.9630354081647663`*^9}},
 CellLabel->
  "In[622]:=",ExpressionUUID->"a3c4a65c-d541-4c4e-9a73-1746d97db1fa"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVVHc81f0XV0ZGZIQe2VsU1XUjcT4o60pGj8xQqLiEZBWhkEehrDKvQvaM
MuqOL6FSIp5s2STzEuXhd39/nNd5ndcZ7/N6n/frSF26bum2m4mJqZZh//ch
XrpVbImiFAMUI13sdgysMS3UEM9LIctnaP4hBYDz47+e0KO4KKRY4gMlFA3P
NMeWSVrsFEnuazMq1xIhXUM0JmqMlcLW/DVJKioF7JWYx1K5WSidEtq6oTfT
wSDkzGu9B7spZimC+EatHPD5latOOr2Lkkg4KZw3nwuxAqOyGgpMlK4W2ztU
hTzIK82OkDq/TX6flpY6fK4ANLXPlb98sEV+m2NCy3IrhF6BFI4jfptkFt28
Wi+HUpgjpg/482+Qk/xmvubrlMMPvX01nB/WyVvpj55eYa+EdxWmyCGITk5S
bVCKwqqAaMt9TeXqKvlJvpwSd2o1MHvMy6u6r5Cf3ig+8cClBmxUL+6eiF4i
L396ofP3xEugDJsG6AbPkTPDY8/+yH4FmUFxNdYPR8j5wiYH5PmawLyt8E2N
+hDZtvy4peE/TUBffswn/rOfLMU553hkpwlO7dnfXBHVS8acv5V1Dr6BoHvt
56SSPpIFS8o13nqQQS16nyRPSRt5o/qGvncLGb6JSZaG9DaTZboFcq/wUCBx
8Xmvd1sD2XZ8QJTFhQJMyU2al2wCwTDGNfAGnQLoZdC0300SbGQytfQLUoFy
g+YF7WVQZ1g3TFengrP1XmibawSnVXOJq35UeNJYGx4pS4WMC3793fFUYL9d
xLJu2Ay/Pt1KEC6mwkwsbddDr/dw1SDit9EQFWzyxR1CfDrgc7KigOEaFWQh
5WUhrhN2jmQtau+lgY1jSOFeiW6Yc1rnxJ2gQSLp0+yFt9/gTN+LtT2RNAjb
+RbLo9kP7N4zLQtJNOjKkEOaFQOwWML8ZzSPBpUlfDfC44eBLTTuDmszDfwo
3GfGf40Au1OhikEXDb77Sd9/Xj4KsvNG2+UjNDBvEYsx4BmDxwLydgIbNFiW
S2093zgGSik7UQeZMYiOvj6d5T4Og9HaYm7cGHASrBeP8E6Aylw/fU0Ig/VM
Drv9ryegtNy6plsCgw5tgqjdxUnwxBG6mBUx+GGgX8rFPAX3z67nxKli8OX0
ZXZcwRQIulcjHzwGxhzdb4YMp8He16Wy7hQGW099FvhnpqEU9x67rMfAa/G0
HoqegeLwGaXbhhiMS0RZGMjOgtm4mheLKQbn7v4asabMAuuFNjqTOQZng/hL
hO3noJpYyRpghUFDcBzHI/ocBFybwa5YM+q94pg/PPgBg+/vHu+3weCJbqh1
h8w8FOXUaX6xwyAb9ywop34eZMW/ZZk7YECavp5pZPYTnAftOR0cMVDibqr5
/P0neHDSuH8x4iXVej8t/wXg5bxzUO4iBrPtrZaPWRdBsKn/wSwjT8gVT+lP
WYSK3tZcQ0aMSyqQfsi/BE9SaiL0GPNvK3dkldguQSiv2akhBr64dm4CgbQE
dhGE9yK2GJxYMHl5fWoJdlHFebYZ+5/UD60SUVkGK+2yr7HnMaC5XhM+57sM
QUVbPRQLDF4r5bvsq1sGen5/bb4ZBhGVrBuOv5ehKSOMRYuAwSHMW1VbZwU2
d8vDXQafnrVpJhURK0AhlHSG62PQdPFdSF3zClRnCvPjAYOu1vDR83tW4flT
VUL+ScZ9zoyEOcWtQtSqsU+DGgZ7WZ8Uf/64CilSaumuyhi0XlJbHeamA8vp
uxpf5Bj6qd+RG4ung+AsoXDzLwzKO0RT+j7Rwd7MQLdeAAMe1kHlQJ41EHJ5
NKzH0FekEfV8yYM1ePnKSbpxhwZjuPoP0lHr8C6bldl7jAYF83dYAmnrENgZ
aF7aT4Pw+hP2oTvrIBqKc6My9P3qyK4X+UG/QGxK/eZNGg3mLB++i7myAby5
kyyHSDSIy9r8Xpi9ASKK/qSBNBqoY/jw+J4N6Nu6LOKXQAO2+qgPxXqbsKZT
a2IRRgOdikgNEPkNQy0Fb5bsaLBRRsuLIv+BdvX76DIvDSjv27dw09tgO4rt
I/lQwe33Rs3ZAzsweahPxsKdCpNCBz6A8Q5kH7p1/I89FTpU3q9UFe9AxsJO
v5YhFSyKrlj9VGdCIyzPuoPFqJBymYXUscqEJmXSfuHaKeBhQ56ru7wbeSkU
Sz2ToECk98V0oaQ9qMFpgfDxbCNUb0Z+//NiLwqz+ON4q70O2tvMe0tjeZF9
75mksEs1sDqU/P2/x7zoppD7F+O/a2BM33fZNJMXdQR8PyNlVANhfZyHJst5
0dX8xGf0wzVgcEyOsN3Ni7LtpEeVf1fD3pDOrB4xPmRLFJbtSq6GrLXtTaVK
PqTCX5pb2lUFYBInOfWZH21K3MiW964E0jjuXu43fhSU/qij93IldA0cjbb/
zo9KargPJNpWQp5qpueHFX5UKGfWJ3amEmJmOmfSBQWQjrQCW75oJfiTX7P/
thNA2SJ1IzXpFcBl34zHJgTQ6FlTPh2PcnCvxbw/0vej8dPi1QEapdB39iiP
66QQ4opKftNfVQiOf7Il81YOoO7s2hLWh/nwUU/k9lyXCDpES3vLJv4cfga6
Fy3kiqKLJ72ON4nkgmVAF+dKojjSPbwl3BaZDerHmKcDVSSRlPUAffBRBtTz
Nw/8KymF3slLdRr3PIHCHeRowSONfBzmte9EpQJ3T47F2Kw0qtOIn4vMS4bd
Gi4iar0y6Eqa5T7fgccAJ+wHcVWyiKRmy8/s+giC5q0QW5YculLwkf31RgKU
mdqYHL4rj1J0HKMbYh6CUJHW8jsbBTTWlKP/MSwOnFRaZfRBEUlNGLc634uF
rU//lUQKKqHPjGegNBADx0tqpZumlBDXVu8LHZdoIGmSI4bbDqGV/J/a4T/v
gbjFvv+UMpQZ/HJkq1ffhVJnZl2bMBWk7hbh0R8SCU7MHm/LHQ6je3WdG3au
ESCd+unNLeUjyEKg/aJMQDgcq5XsU+RSRTIbvkfC+O7AOd2RUJ8BVVRYzBkS
HRwK/wbJJCdbqaEES+P3p/fchlerGleHqWpId2LKKDApBDS+cQTHKx5FeBmh
oP8sgsFv0VexMO0oYjU56BPLEwQ6Ogf9cDtHkfWBlyF9awGg+O326APXY6jO
hA0bot+Ekb0sXYSuY2juZotv9ZI/WOlLKiRoHEd9VCnbLm5/sCQ89FJ/cRzR
BVzqehRugGuPUW2ZAA5Zff2y0HTeD7wv83nWB+HQyQ4tncEMX/BpnxiXncKh
FOawlMARHxC7KaasbKqOyo6u7ec46QN6moPG/JXqqHLXbo/Putfh0fA+YWtR
PGI9AQHG7N6QPS/3GSLw6L6zZjEXnQj0oT3Ku+/ikbN2kYrDIhEkz/Tda76H
R9nH1r+UzRGBuEQ4Znwfj0gfK+6e/04EdcFb/pYJePS20zW44hMRTgtbpbpm
4VHl+jWHjCIijH4JsoypxyP+PLFQI2ciyF3bIRo3MuZRmQub7IlQIBURxfUG
j7p3WcwdvUAEfbfAygQKHk3WNNZImBFB5KTmQlorHgmoCJqznyLC9rgLR2EP
HsXQ3V24DxAh2KGF2eNfPHLUVul7LECE2QKlLeU+PHrT3X3pr31EiBVZn6oY
xKO6217FSmxEaPu7MO/VOB6ZXiDsukD3hPgTognBk3gkWvVse2LRE543JAVq
TeMRG5MCl/8PTyjkTNAjz+FRtcNF85QxT7D6R0AuYh6Prle43VcY9oRm3ixW
/QVGf4Tep4Y+TxD9pTzBsoRHEsY5Uud6PME9lUJ5t4xHGEk+cqLTE/4Hxl1i
zg==
            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVVXk0FP4XtSbZt8QXyZKmUbJNJtX7WMvSYsiXLKloZClpsYTskjV7RRIx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            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVVHk41HsXxxDKvsaVixCpbGOQ6nyllLhkeV1lrUZliZIYQiEia8lSIWMJ
2bNknzE/WZIsWUP2bUL2pMU794/znOfznPOcz9mlL7ubObIwMTG1MeQ/7XtD
t2RXrAR147llU+2kOlhiOqg6mo/qEG+5ddWTBA5PxJLWQ/ZQ3+//qifKGQbp
2hMraTocVI5jk9OKlY/huZbEw5AJNupyZoP0W+1EsFbETSRws1JfyuhzTj9K
Bn3f05UnI1mo1viXsa/70uDmd7JG2ilm6oykSoWRaQaEC47Jah1goioYc4aJ
V2RBZn5qoLTFH0p0zwfSR7Yc0D5uUlgW+YsyF8AqL6H7GvoE4zmPePygjEjd
z1fzLwS66/MhT4EtSvn2kxAyFMPXk7ylu9s2KZRZHat6zRJoKjJCNqR1yvG/
OjjteErB9QK306Hra5SfPULOboulgHNekFe+ukpxbw7IKmwsAytlO5ap0GWK
nNksM8WmAqhfjLx0feiUdhLLhWztKkgmRZRaRo1StizAOLCnDs635NSVaoxQ
2mVxa97n62F95Qm/5OJnilUMuQ1rrodj7EKNRSF9lID7B42WcihAetBqIh33
geJdq3I5N5kKKqG8Ujx5LZSGoziNsVYqDOyTyvfta6RsLa6J6G9QIfZbRp9b
SzUlUWDGr1+/AZie1mpftvKGNpsIg+C+BkBlpFmPO2kQFVzrlbPZANTbtBvQ
WgBB75zjLwvTwMGSC1roNVCblqjXYEyDpJry+0GyDdAwvtDs60QDDr9c1s0z
jbDy7sLhtSAazIXTmKNuvIej2VnsZ97QwCpL0sb3Zju8iXTYwLfQQBbiy3Lw
nVDAz1yza4Rht/XN4fr7E6i4b5Z54zDIlDEYsIzqgfKgSs0DwhiU2b4o1P7e
C8aLz9WH5DCITfs4/2/9APhfTItwO4VBwM5AOI/2Zwidi2UOMMeg+4Uc0i4a
gq6IOKewSxh8Pkob/y01AnWme48nuGFQnMd/+370F2h4qFlU5IuBB5X79OT3
USCdUSwaDsFg3EMmLKNwDP4pz6TLxmLQdmIq1NF+HMhbBzpjnmFw/t2+h/o8
EyAyq/hYNh2DFbmEZouaCfhqRpCl52IQGuo+m3J1Eh6NbujPFmOw29Dy2xG+
KXhIkLkv8xaDzWTOi0KVU3DN9Zp0ei0G7ccNJS7aTYOMjbqBawMGX/X18vfg
ZuBYxe2p0HcYdJ26woF/NQNcPnrF31swMOD8VDdyZhbGAsJ0Gtsw+PXs5pLA
3CwsNgXOrbQz+N65WI6EzsG86JmlkA4MJv8OMdWXnQf05OjFkE4MTIK/j1pS
52Gb5sq/wcD/kATyRK3pIN6w1jXIwNU+EZyP1+mQNKiB1/rP/0YEri3yK4ic
VcgXYsRL0vW3bN+/AEl3gh7dZvCl4tNJL6sWwE5l5rcVI5+0Wffks8aLsG74
W7CVka8id21px/giOApGVTcz6llWrvLQ8VyC9tV7VCsaBvOtzWZP2L5BVtV0
3716DAzJkvGf47/BfDf9MarGAB/3SiZKYBmm25qcUssx8FNqT8m7sAz/3kuv
SWb0V/I4OcYwbRnaCF7vT+RhoLl0rsx9ZhlU+MYoD7MwoBGdRE1urQCv/Z9H
4oz5VSpmXeKtWAFhc5Njzk8wCCxm27LdXgH8M3qkawQGLuWJ54oCV0EvYKgz
zg+DWrsm34rGVTA02rVW58nYr+b7Yxbsa+De5i6Y5cro/+nRAPuINZCrNu0v
tWbMv2pHbiJ6HXquq58Q0MSgsF0ifvDjOqylRxRcOYwBD9uwkjfPBrBpj7oE
78cg6GyDRV7kBpyLqzivwYvBBL6qTSZkEza89vE+naIB3Syq6eG1LajGpT5O
DaNBRMqP8ZzULfhWWKR5zZ8GGhjhfnTvFkgLSWSLedBgV1VI2+uTPyBl+WIu
WNPgRFGQFohvw/Picyj3EA22CmiZIZSfwPLVRTX7A+Pe37f+ws/+Aft9Zjsz
bA3gbEWhV1xhQUNd6oGyC/UQ5Gb3XCSOHRWt1nbfIVaBf1DBzr857Igip2Tc
Z1wFzT48SbF17GisPWDIkPHfyuVV82Zn2RFZYEXSi6cKlFk+Gysf40AtziEd
TVWVsC3neld9kgNVtIheMReqhMI6pjU/pd3oMgtza/9ABbz5ETT+M5sL+cgW
dz5NLgPzeRVLlWouNFImq8AcVQYGhnnb9h+40HZ41w8//zJgHS1aLl7mQgeV
PbvS7crg35yvNuLa3KjkvmRllnQZ8HHiHfhbuRHHiw/hd1+XwkpY2Kn6aR5U
JitpxdT8Blpbzvflh/MhW2MR3lMKJbA28nT89xM+lHE5KnPvXyUwoXdrxSiZ
D2XPNeJ/cpdAwODug9OFfOiCPAcLfa0Y9NXkDP984kOhBhfvulKLgcu3M6V3
Hz8aNv/ts2ldDCkbf34oFvMjAqufoq12EcC5CKmZDgFkzETHtQflQ9ok/gF5
QABREmaSRtzyoXtINdR6XAB12H3+zWydD5nKyS5tqwJo60hXf4h6Pjyc65x7
LiyIcAMl6t7TeeBJqeTYviiIhpMeHFwwyoM91o0EbEoQvR/QYg9SfA1XyzG3
D+tC6MQ9V3ynUA6QfhhF5f4SQoE8Zl2EXTlwMqe3IYRVGHX4yuNff8+GRheH
mzpCwkis11fw7edsyHX1/PlCXRhhZytKr5GzofbK9VA1D2E01lEXvlc1G1gs
I8RqloRRrYORm82FVzD4jyoPcVoE3fvOE0p5nwmdweXqbxZFEI923dZ6XSaY
pFD8dzZEUOWN9DGNkkx4xhsTlLhLFF26UjA0mJgJ1+WZHesOiKJF+UHBXMdM
WH00qzXuJIrOh7neuIDLBFsa++noRVHUZxuhlq+fAbY/U6UyV/cy+OBQGp0M
R3J8OTS39yIpzqUC1nEyeKW/smxlFkOhf17V3uwnwzfV9wcW+MTQy9OJl+0b
ydBbJvH6oLIYkmVi/xWfSgaRecmnES5iSBeyRy9ZkCG9NZZrbFIMHfufFNfJ
d2nw4aS4H71bHKkFjOpY3XkJi95Xc5fIEqiuU3rkwdQLMPPq3r0aK4ks7JNv
y+YmgYYabtb7kBSyioxkwv2dAFUCjUP9UtKoRPKp3bOWOMjZQbamPDIog94p
rdzzGLh7X5pOzMsgDvCj43RjgUXrkrhK337kc1jSeyo8CkDTehhfIovK/Uwa
pSQjgLRgjnalyCHhFW4ft84wKDCyOnc4WB6Z4veetv4UCiK5OitNVgeQXIq2
vNfhELA/1LxfDxTQfA/H0YD4YPj18XdekLAios7zl2ehIFDPK5epnVFEC2pe
GTyCgZCmTQn80nIQOWjoq5r33wNJU97fii+UkHxj2Vv9KX/Id8DpWgUcQgEq
VDuLH3fBHudcX2hzGA02zh/o1PMFmYSPdXeVjqBnTHGm3R9JoFYuNaiwRxlN
jqdvnLPxBhPdUf+bQ8rI7sTlQyOSXtBP2v/0qbkKwnP1nIvZ8YS3a1rXvzSo
oCNOXiHdo7dBa4DTJ1pBFbmvJfq/nvUAj2+3FHISVVGBvUdPwtItOHHiLw/8
jiparU4gr4rcAoUBv7FIohoq5dHO+mZ6E0a5WLsNu9VQ9q9D9DZhdzDXkzoQ
o6WOtm0t1GxqboCZYdQNjWx19CRgr9egjSsQe8+WFwjikVVGlnvdXy7gdoXf
pYqER00cZ/mZcc5ws3VqUnYGj9i0Xu12mr4O++7sU1Iy0kD8G4IaHF+vwUnt
YQOBYg10OvvnZgruGjz+witqKUFA806BwXyiVyF1Qa4DAgmI73hezLK+I6yP
sCuxBBPQsWFnkpOeI0idHnzQ+ICA/Iwe6E6CI7guG6oZhBEQZ++L24NajqAh
fNfTLIaAXuTqm3QedIRTouYJxBQCYjqrlTnL4whjXSSzh1UElEWUaKnuJ4Kc
046rQQ0BPa6JPmLSQ4RX0oEhe+oIaGzoH9epTiLoOXoXx1AJyC0qyZX/PRHE
j2ovJTYTUG9sMelOLRH+TF7izOkloGufOgIdyUTwsXmHc+5nYF90jD2VCPOv
FH8pDRLQWeWM1tznRAgX35wpGiagKytKNitxRGj5X07m20kC+q3VbvUolAjR
mhIxPtMERFowyVALJkJGdZy3ziwBWY6S64fuESFnd8xJCp2A9A9mXlXxIYL5
I0G5wAUCKhNvXx26Q4RGvhQ2vSUCErtbYRzmQQSJ70pTrMsEpDUs4avhToSr
CVRq0woBydJrPSddiPB/6TYVpg==
            "]]}, Annotation[#, "Charting`Private`Tag#3"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
               Line[CompressedData["
1:eJwVVHc81f0XV0ZGZIQe2VsU1XUjcT4o60pGj8xQqLiEZBWhkEehrDKvQvaM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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Line[CompressedData["
1:eJwVVXk0FP4XtSbZt8QXyZKmUbJNJtX7WMvSYsiXLKloZClpsYTskjV7RRIx
iEH4hjSDGbuUshVZxr6TZIuf3x/3vPPOuee9c95999wD124THFiYmJhadvD/
6u2qVbwrVoL6YybfP4uqBuZ1mqgymp/qY0Y/Rw31Ars4sZTlEC6qv1PT5Uix
cHiNH158pbmbahxkOyIUFAfPNSTCQobZqZca+l9b6qeAFYZ1OImHjSp8UNrm
TE8a6HvrvdeOZKHKXtRKP52WAW5/MtRf6TJTi68/UNA/ngXhQoNyGgpMVNyG
+eONymzIevsy4IDZFmUCk8wlhskF/KkLhaWRm5T8FaIRITAfuoQSOY+6r1He
Zu5NrF8lw5TL8x/3BFcpoY/cB7O4imFam+/dnpYVikgf490HgRKoJxsja89l
So/dLvsU1lJwseS5qej4i9IaKXV/ar4UWJ1mDirdWKI4W7VdUfpWBhZKtiwj
oQuU+8LujPiQ/4D60/iBltcU5d9iwVGbuEpI9Yx4Zx41QEkNTBaxD6TAxUZS
9Tv1fkp1+Mo5DjYqLC/GCUjNfqcYPn5yx1WXCic5hGnkkC6Ki5v3peMfqeAZ
3HThQHwrpYZNlliQXAPHQvmkefMbKVqFBOH1xhrokZR+691Fo1gYd/bbrtZA
7Hxm163GSgrGL/5FnkktMCV8wF+z8ICQtUtN9fO1gEo9x93vv4KT3861mArV
AfVurSs0FYBSq1jAVfU6sDPnhsapKhB8gP2FvV8HKVVl/oFyNXDFmWywFVcH
u31y2VbO0MDy0bVoH3IdTITXMke5NoPEX8PYrJE6sHgjZe3t1ga5bKIOV//W
gRwklpLUPoPmWWPrBWEaWNh4k7j3f4WtjdDWHESDLBmDHvOobxCFv4MdMqNB
qc2LQvyfThBzmfThdaRB7KtPk/9+7IGWljl++wga+G33hPPiv0N4i23YbCoN
Ol7IIzz5B4iZ1vVdKaDB9xO1Q3+l+6H1/uZw3QcaFOUL3PWP/gl/6CflZFpo
4E7l0WP8GQCWXQGjgT00GHKXeZxZOAh2S/OH5kZocJEuGabPOwxnly23WDZo
sCif1GBWNQxFxOTLVWx0CA29PZ52gwFHW/K/vOChwx4j8/mj/CMgwonVyBeh
w0oq52Xh9yPw8epFxQUJOrSdMpK4bDsKlYTPondk6TCtr/OWi3UMyq8/U1bD
0OGL7vXdatljgAsPfgRH6WDA+bW6/8w4tNB/d6eo0GHzmduc4MQ4hOS5MvRw
O/vozub9oRNw1YRbyhhPB8b+EBN9uUlIt9/VW6RJhwtBfwbMqZMgQOU+6XWK
Duc8BfNFrabgpWqOft5pOlR6RXA+XZ6CqfHAL2dhh+8awdoSOQ30wdIYy50+
RcvXvE12BsaEFvmGdvgv1V57plfMgExIeTVjZ96r8dupZ8/PQtM3t2GHk3TA
8Hx41z40C7M5MdnOJ+iwoFThrnlvDrLOJwiuHafDZFMDIY59Hng49vILqtPB
KEMq8XviPJzHVztVKtNBLT5bJkpwAUJYcV9+H6GDD7YtLd9yAYydxLsadu4j
dSojxujVAjD7fVtQlafD8TnD0ttjC3Cm1tPvlDQdTuj4FosrLkL3gWe14+J0
qLW/KXrhziJ0lPFPqO/o8R7z5ipf+SK4ZDUyY/noEFDEvmqzvghMlg+4mnfT
wbks2ZAcsARX2j65Cuzo/cG23ructgRNN/EXKb92/qvBf9CM4xfMHnU+LjND
g029Ab8rEb/gWsLYWYE+GoRWbMsPRy/DCt77W/d7GhS2SST2floGncV3DXfI
NOBl78N68P4Gkkmo2dc3NAg8W2OWH/kbDpjUGvx+SoNhtYoWmZAV2Dox3T1J
pMEUIao+jLgKXMJnngpx0yAibW2I9HIVSsv1i5qZaKBeh/OP7lwFQ4cSX+Lv
OthVEdKSp70G3z2mtc1/1sFpcqAGiK/D0eCxFtkdf64W1GaFUDagityepHtu
x+/NTZtq41uwqwbvXOhfC04WlKny6yxo65OVbfoAFQJv2T7fG8+BYiTlNHUZ
VeAbWLD9L4kDWbU7Liq2VkGDF29KbDUHMm3mnD5cVgVlB5Xzx8c50LJvacGN
sCpQYvl+XunkbmQ3grnTr1gF6/IuD1UZu9G8puBf+sNKKKxm+uWD3YN+yAgh
S0wFlKwFDm3kcCPWLs124ZpyMJ08Zn6skhvZtjxv1ykqBwOj/PUrrdwoubbo
T2B6ObANkBeKFrjRvJxGmLJfOfxLmrYWx/Ogl9md4udPlgM/p5qdQBMP8rr2
rMizqgwWHz/W/TjKi6jMQdeU6KXQ1Hix6204P7rMdcyFmfUd/OpPGPobx49+
juzPIS+XwLDOnUXjVH7Un3Ok1GWsBPx69xweLeRH2yanmYSaS0BfRd5o6ys/
+qt6O5g3rgS4vT+ndUoKoIwy+agSuRJI+721hikSQEGLEYdPmhUDGEZIj7UL
IqYsp9GpYjK8YqgFZ/QIIp4NET/JVDJ0/FAOtRoSRAf2PSc4hJIhSynVuWVJ
ED3UczVSsyJD2MTnieciQmjoqUdjKzsZ7lHe716/LIRii+eKO2wLgcuKhqsb
EUIJ1pr46P0FcKOs7lbrsjByuOL4fqsrDzzXjKNyN4XRkf0P15fr80Cb1FkT
wiaCqNvfONbK84DmbOemKSyCelP2GRxOzoNcl3sbL1RFENOL7mYlizz4cN0x
VMVdBG11I8XKvlxgMY8Qq5oTQW/j9k07zZOg95wyr/3oXjSxsYRz0MiBz0Fl
qiWze9Hi3Y4Co8M5cCGN4rv9ey+SF6MnnpbIgWd8MYHJu0SR6yhXgAFTDjge
ZHaoVhBFZStHtZcas2HpybjG0E1RpLNe/zTIOhtsajn0omdFkVB/EYdh5Buw
2XgpnbW0D2EJ9gQqVxYcJXnvPr6+D4nxxkxKM2fBg9fZ5k3MYkgtnL4TsZkw
r9ysMMMvhki3b2/eHcqEzlKJvMNKYkh9JGIu979M2DsplRDhLIaODa9mJjhk
wuumWO5BhhhKxWKwSg2voVVb3GeqQxzhB0o2GOkZMOtxI3cuQwKVG4rbcRql
A+FBx56lWCkUyhBm0nv3AtRVWMc9FKVR7d3ETr2BFKgQpP3olj6AXnZOP+rW
SQLSNrIx4ZVBQiPByjPCCcDTmW4yPCmDplyt1YUIccCicVX8WJcsEjws1Z5C
igU4btWnViyHqu/te1r8PBo8Z0zRrjR5RHJudjNkj4QCYwvDI0EHkYTA2szX
pnDYm6u5WG+hgOROaxgOzofBFcUGWR04hGwXv6pqyYfC5qe/+YEiGFSsckin
500wqOaXyXwYw6CePwvxNwhB8ApPCfjZeBi98Z/rp7AHgpQJ31/MCyy6Fdl5
NXXGH97asWpZ+CkiEfY81E5+BFdYnT4WWh9BMxPFijdqfUEm6VP1Q+xRRFNm
mCRK+oBKmXTvIS4l5PhI7Mi1h95wQWvA1+2HEoryOUjaEPaCbk/ZhATTY+iC
ktFnn88e8N8vDcefNcfQvHAs1SHiAWj0cHpFH1JGeq1Dzxfc74P7/J1DpGRl
tDDlvmJleQ9On/7HXW1bGX1ueI8LdLgLh3p8BiPtVdClNPWtvFB3GOBm6zDq
UEH9mK6X3m/ugKmOtEKMhiqKNrO9e2/IDQhGUa7qOapIvtzcWfgfN7DvPFtW
IKSGvoutEV4034Jb1wWcKzzVUDsPW1VJpCu4NY0w5MbUkNR0rAnewAUk70ti
scbqiDAuOZZwxBm08X0GgkXqyKiCBWen4ARPf/KJmkvgUP8Q2Jz75ya8nJFv
hwAcShgTjCcqOcJyPweWJQiHugn5DCLWEaT1eoNpwTgk6NCnfFPBEVwWjFQM
HuPQ6+UK+q39jqAu8vAeIQaHSEm6tSF8jqArappkn4ZDGNre+uF5Igx+8SSE
VeCQC098lXkxEeRvbrsYVOFQZfH7/Q8KiJB9ICCEqxqHxFR0PJJyiaDj4FEU
Q8UhvdWz270ZRBA/gZ9LbsAhBvstJ5c4ImwxrnKSOnGoYeuE48e7RPCyprM6
deOQcntJ/8xtIkxmYzaxvTgk15atJeFChHDxlTFyHw499Wv76mtPhMZLpKz/
GDi071PmPuNLRIg+LhHjNYpD9bpP1gJMiJBZGe+hOY5D6W7B9e/PEYG0J0ab
MoVDhhsBshh9Ipg+EZIPmMEhjeKZkmvaRKDxp7HrzOGQczP+SNppIkj8wY6w
LeCQP0jG9Zwgwo0kKrV+EYf6FIyGhI8T4X+5+g6L
                "]]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Line[CompressedData["
1:eJwVVHk41HsXxxDKvsaVixCpbGOQ6nyllLhkeV1lrUZliZIYQiEia8lSIWMJ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                "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
             "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.560181, 0.691569, 0.194885]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.880722, 0.611041, 0.142051]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.368417, 0.506779, 0.709798]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>], 
        ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]], 
           Line[CompressedData["
1:eJwVVHc81f0XV0ZGZIQe2VsU1XUjcT4o60pGj8xQqLiEZBWhkEehrDKvQvaM
MuqOL6FSIp5s2STzEuXhd39/nNd5ndcZ7/N6n/frSF26bum2m4mJqZZh//ch
XrpVbImiFAMUI13sdgysMS3UEM9LIctnaP4hBYDz47+e0KO4KKRY4gMlFA3P
NMeWSVrsFEnuazMq1xIhXUM0JmqMlcLW/DVJKioF7JWYx1K5WSidEtq6oTfT
wSDkzGu9B7spZimC+EatHPD5latOOr2Lkkg4KZw3nwuxAqOyGgpMlK4W2ztU
hTzIK82OkDq/TX6flpY6fK4ANLXPlb98sEV+m2NCy3IrhF6BFI4jfptkFt28
Wi+HUpgjpg/482+Qk/xmvubrlMMPvX01nB/WyVvpj55eYa+EdxWmyCGITk5S
bVCKwqqAaMt9TeXqKvlJvpwSd2o1MHvMy6u6r5Cf3ig+8cClBmxUL+6eiF4i
L396ofP3xEugDJsG6AbPkTPDY8/+yH4FmUFxNdYPR8j5wiYH5PmawLyt8E2N
+hDZtvy4peE/TUBffswn/rOfLMU553hkpwlO7dnfXBHVS8acv5V1Dr6BoHvt
56SSPpIFS8o13nqQQS16nyRPSRt5o/qGvncLGb6JSZaG9DaTZboFcq/wUCBx
8Xmvd1sD2XZ8QJTFhQJMyU2al2wCwTDGNfAGnQLoZdC0300SbGQytfQLUoFy
g+YF7WVQZ1g3TFengrP1XmibawSnVXOJq35UeNJYGx4pS4WMC3793fFUYL9d
xLJu2Ay/Pt1KEC6mwkwsbddDr/dw1SDit9EQFWzyxR1CfDrgc7KigOEaFWQh
5WUhrhN2jmQtau+lgY1jSOFeiW6Yc1rnxJ2gQSLp0+yFt9/gTN+LtT2RNAjb
+RbLo9kP7N4zLQtJNOjKkEOaFQOwWML8ZzSPBpUlfDfC44eBLTTuDmszDfwo
3GfGf40Au1OhikEXDb77Sd9/Xj4KsvNG2+UjNDBvEYsx4BmDxwLydgIbNFiW
S2093zgGSik7UQeZMYiOvj6d5T4Og9HaYm7cGHASrBeP8E6Aylw/fU0Ig/VM
Drv9ryegtNy6plsCgw5tgqjdxUnwxBG6mBUx+GGgX8rFPAX3z67nxKli8OX0
ZXZcwRQIulcjHzwGxhzdb4YMp8He16Wy7hQGW099FvhnpqEU9x67rMfAa/G0
HoqegeLwGaXbhhiMS0RZGMjOgtm4mheLKQbn7v4asabMAuuFNjqTOQZng/hL
hO3noJpYyRpghUFDcBzHI/ocBFybwa5YM+q94pg/PPgBg+/vHu+3weCJbqh1
h8w8FOXUaX6xwyAb9ywop34eZMW/ZZk7YECavp5pZPYTnAftOR0cMVDibqr5
/P0neHDSuH8x4iXVej8t/wXg5bxzUO4iBrPtrZaPWRdBsKn/wSwjT8gVT+lP
WYSK3tZcQ0aMSyqQfsi/BE9SaiL0GPNvK3dkldguQSiv2akhBr64dm4CgbQE
dhGE9yK2GJxYMHl5fWoJdlHFebYZ+5/UD60SUVkGK+2yr7HnMaC5XhM+57sM
QUVbPRQLDF4r5bvsq1sGen5/bb4ZBhGVrBuOv5ehKSOMRYuAwSHMW1VbZwU2
d8vDXQafnrVpJhURK0AhlHSG62PQdPFdSF3zClRnCvPjAYOu1vDR83tW4flT
VUL+ScZ9zoyEOcWtQtSqsU+DGgZ7WZ8Uf/64CilSaumuyhi0XlJbHeamA8vp
uxpf5Bj6qd+RG4ung+AsoXDzLwzKO0RT+j7Rwd7MQLdeAAMe1kHlQJ41EHJ5
NKzH0FekEfV8yYM1ePnKSbpxhwZjuPoP0lHr8C6bldl7jAYF83dYAmnrENgZ
aF7aT4Pw+hP2oTvrIBqKc6My9P3qyK4X+UG/QGxK/eZNGg3mLB++i7myAby5
kyyHSDSIy9r8Xpi9ASKK/qSBNBqoY/jw+J4N6Nu6LOKXQAO2+qgPxXqbsKZT
a2IRRgOdikgNEPkNQy0Fb5bsaLBRRsuLIv+BdvX76DIvDSjv27dw09tgO4rt
I/lQwe33Rs3ZAzsweahPxsKdCpNCBz6A8Q5kH7p1/I89FTpU3q9UFe9AxsJO
v5YhFSyKrlj9VGdCIyzPuoPFqJBymYXUscqEJmXSfuHaKeBhQ56ru7wbeSkU
Sz2ToECk98V0oaQ9qMFpgfDxbCNUb0Z+//NiLwqz+ON4q70O2tvMe0tjeZF9
75mksEs1sDqU/P2/x7zoppD7F+O/a2BM33fZNJMXdQR8PyNlVANhfZyHJst5
0dX8xGf0wzVgcEyOsN3Ni7LtpEeVf1fD3pDOrB4xPmRLFJbtSq6GrLXtTaVK
PqTCX5pb2lUFYBInOfWZH21K3MiW964E0jjuXu43fhSU/qij93IldA0cjbb/
zo9KargPJNpWQp5qpueHFX5UKGfWJ3amEmJmOmfSBQWQjrQCW75oJfiTX7P/
thNA2SJ1IzXpFcBl34zHJgTQ6FlTPh2PcnCvxbw/0vej8dPi1QEapdB39iiP
66QQ4opKftNfVQiOf7Il81YOoO7s2hLWh/nwUU/k9lyXCDpES3vLJv4cfga6
Fy3kiqKLJ72ON4nkgmVAF+dKojjSPbwl3BaZDerHmKcDVSSRlPUAffBRBtTz
Nw/8KymF3slLdRr3PIHCHeRowSONfBzmte9EpQJ3T47F2Kw0qtOIn4vMS4bd
Gi4iar0y6Eqa5T7fgccAJ+wHcVWyiKRmy8/s+giC5q0QW5YculLwkf31RgKU
mdqYHL4rj1J0HKMbYh6CUJHW8jsbBTTWlKP/MSwOnFRaZfRBEUlNGLc634uF
rU//lUQKKqHPjGegNBADx0tqpZumlBDXVu8LHZdoIGmSI4bbDqGV/J/a4T/v
gbjFvv+UMpQZ/HJkq1ffhVJnZl2bMBWk7hbh0R8SCU7MHm/LHQ6je3WdG3au
ESCd+unNLeUjyEKg/aJMQDgcq5XsU+RSRTIbvkfC+O7AOd2RUJ8BVVRYzBkS
HRwK/wbJJCdbqaEES+P3p/fchlerGleHqWpId2LKKDApBDS+cQTHKx5FeBmh
oP8sgsFv0VexMO0oYjU56BPLEwQ6Ogf9cDtHkfWBlyF9awGg+O326APXY6jO
hA0bot+Ekb0sXYSuY2juZotv9ZI/WOlLKiRoHEd9VCnbLm5/sCQ89FJ/cRzR
BVzqehRugGuPUW2ZAA5Zff2y0HTeD7wv83nWB+HQyQ4tncEMX/BpnxiXncKh
FOawlMARHxC7KaasbKqOyo6u7ec46QN6moPG/JXqqHLXbo/Putfh0fA+YWtR
PGI9AQHG7N6QPS/3GSLw6L6zZjEXnQj0oT3Ku+/ikbN2kYrDIhEkz/Tda76H
R9nH1r+UzRGBuEQ4Znwfj0gfK+6e/04EdcFb/pYJePS20zW44hMRTgtbpbpm
4VHl+jWHjCIijH4JsoypxyP+PLFQI2ciyF3bIRo3MuZRmQub7IlQIBURxfUG
j7p3WcwdvUAEfbfAygQKHk3WNNZImBFB5KTmQlorHgmoCJqznyLC9rgLR2EP
HsXQ3V24DxAh2KGF2eNfPHLUVul7LECE2QKlLeU+PHrT3X3pr31EiBVZn6oY
xKO6217FSmxEaPu7MO/VOB6ZXiDsukD3hPgTognBk3gkWvVse2LRE543JAVq
TeMRG5MCl/8PTyjkTNAjz+FRtcNF85QxT7D6R0AuYh6Prle43VcY9oRm3ixW
/QVGf4Tep4Y+TxD9pTzBsoRHEsY5Uud6PME9lUJ5t4xHGEk+cqLTE/4Hxl1i
zg==
            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Line[CompressedData["
1:eJwVVXk0FP4XtSbZt8QXyZKmUbJNJtX7WMvSYsiXLKloZClpsYTskjV7RRIx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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Line[CompressedData["
1:eJwVVHk41HsXxxDKvsaVixCpbGOQ6nyllLhkeV1lrUZliZIYQiEia8lSIWMJ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            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> Identity, 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> 1, Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, 
    Method -> {
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None}, PlotRange -> {All, All}, PlotRangeClipping -> 
    True, PlotRangePadding -> {{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"L=2\"", "\"L=3\"", "\"L=5\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.963035269206131*^9, {3.9630353907741737`*^9, 3.9630354088221703`*^9}},
 CellLabel->
  "Out[622]=",ExpressionUUID->"0f6bf3fa-8cb4-7448-af77-113f9ce25af9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"VZZZ", "[", 
    RowBox[{"r", ",", "5"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rs", "->", "1"}], ",", 
     RowBox[{"r", "->", "2"}]}], "}"}]}], "//", "N"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VZZZ", "[", 
    RowBox[{"r", ",", "2"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rs", "->", "1"}], ",", 
     RowBox[{"r", "->", "2"}]}], "}"}]}], "//", "N"}]}], "Input",
 CellChangeTimes->{{3.9630352757905903`*^9, 3.9630353119922104`*^9}},
 CellLabel->
  "In[617]:=",ExpressionUUID->"c5539291-4d9c-8642-b326-9883040e80e8"],

Cell[BoxData["3.556467250790003`"], "Output",
 CellChangeTimes->{{3.963035299451105*^9, 3.963035312331091*^9}},
 CellLabel->
  "Out[617]=",ExpressionUUID->"a9fbcc3d-75a6-4f48-a4bf-02d674ecc73d"],

Cell[BoxData["0.5377066115702479`"], "Output",
 CellChangeTimes->{{3.963035299451105*^9, 3.963035312340412*^9}},
 CellLabel->
  "Out[618]=",ExpressionUUID->"3f735b27-6a30-cd48-97f8-7b5ef40e3886"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Asymptotic", "[", 
  RowBox[{
   RowBox[{"VZZZ", "[", 
    RowBox[{"r", ",", "L"}], "]"}], ",", 
   RowBox[{"L", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.96303533970072*^9, 3.9630353542763977`*^9}},
 CellLabel->
  "In[620]:=",ExpressionUUID->"ef1913ca-4be7-3f47-bb9c-f8731901db99"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{
     FractionBox[
      SuperscriptBox["L", "2"], 
      SuperscriptBox["r", "2"]], "-", 
     FractionBox[
      RowBox[{
        SuperscriptBox["L", "2"], " ", "rs"}], 
      SuperscriptBox["r", "3"]]}], 
   RowBox[{
     RowBox[{"(", 
       RowBox[{
         FractionBox["1", 
          SuperscriptBox["r", "4"]], "|", "r", "|", "rs"}], ")"}], 
     "\[Element]", 
     TemplateBox[{}, "Reals"]}]},
  "ConditionalExpression"]], "Output",
 CellChangeTimes->{{3.963035345070732*^9, 3.963035354727333*^9}},
 CellLabel->
  "Out[620]=",ExpressionUUID->"d1ad7a1e-938f-6a4f-a986-e8faa1436968"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regge - Wheeler", "Section",
 CellChangeTimes->{{3.963035949029051*^9, 
  3.963035963845545*^9}},ExpressionUUID->"82081c17-8e14-7c47-ab20-\
6d5c6fef6964"],

Cell[CellGroupData[{

Cell["Odd  equations", "Subsection",
 CellChangeTimes->{{3.963037924560978*^9, 
  3.9630379287226486`*^9}},ExpressionUUID->"a656b9f2-6bb2-9348-a4b2-\
ddcf8350233d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddOdd", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "4"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqtAodd", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"%", 
     RowBox[{"Exp", "[", 
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}]], "\[Epsilon]", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
        RowBox[{
         SuperscriptBox["YLM", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}], 
      RowBox[{"-", "1"}]]}], "//", "FullSimplify"}], "//", 
   "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.963037965420599*^9, 3.963038055588928*^9}, {
  3.963038113061369*^9, 3.963038116937933*^9}},
 CellLabel->
  "In[653]:=",ExpressionUUID->"ba481502-dce1-9b4e-867d-f80cce9b72f3"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "3"]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
        RowBox[{"2", " ", "rs"}]}], ")"}], " ", 
      RowBox[{"h0", "[", "r", "]"}]}], "+", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Omega]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            RowBox[{"h1", "[", "r", "]"}]}], "+", 
           RowBox[{"r", " ", 
            RowBox[{
             SuperscriptBox["h1", "\[Prime]",
              MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"r", " ", 
         RowBox[{
          SuperscriptBox["h0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}]}], ")"}], 
   " ", 
   RowBox[{
    SuperscriptBox["YLM", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.9630379757325077`*^9, 3.9630380029391365`*^9}, {
   3.9630380397241592`*^9, 3.96303805670875*^9}, 3.9630381181136208`*^9},
 CellLabel->
  "Out[653]=",ExpressionUUID->"f6bd4bc9-8444-1944-9be6-8de073b3907b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
     RowBox[{"2", " ", "rs"}]}], ")"}], " ", 
   RowBox[{"h0", "[", "r", "]"}]}], "-", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
   RowBox[{"(", 
    RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]", " ", 
   RowBox[{"h1", "[", "r", "]"}]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SuperscriptBox["r", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]", " ", 
   RowBox[{
    SuperscriptBox["h1", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["r", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["h0", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.9630379757325077`*^9, 3.9630380029391365`*^9}, {
   3.9630380397241592`*^9, 3.96303805670875*^9}, 3.9630381181180935`*^9},
 CellLabel->
  "Out[654]=",ExpressionUUID->"f4786e5d-5063-9047-9efa-d556c09bea22"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddOdd", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "4"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqrAodd", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"%", 
     RowBox[{"Exp", "[", 
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"]}]], "\[Epsilon]", " ", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
        RowBox[{
         SuperscriptBox["YLM", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], ")"}], 
      RowBox[{"-", "1"}]]}], "//", "FullSimplify"}], "//", 
   "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.963038127214985*^9, 3.963038129908308*^9}},
 CellLabel->
  "In[655]:=",ExpressionUUID->"7ce66d0b-c115-994c-8b4b-d525ac99737c"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
    "\[Epsilon]", " ", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
       RowBox[{"h0", "[", "r", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "2"}], "+", "L", "+", 
              SuperscriptBox["L", "2"]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
       RowBox[{"h1", "[", "r", "]"}]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
       RowBox[{
        SuperscriptBox["h0", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}]}], ")"}], " ", 
    RowBox[{
     SuperscriptBox["YLM", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"1", ",", "0"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.9630381347277527`*^9},
 CellLabel->
  "Out[655]=",ExpressionUUID->"7042984a-355d-a148-86e7-e149c8570688"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
     RowBox[{"h0", "[", "r", "]"}]}], 
    RowBox[{"r", "-", "rs"}]]}], "+", 
  RowBox[{"r", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "L", "+", 
     SuperscriptBox["L", "2"], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}], 
      RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
   RowBox[{"h1", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    SuperscriptBox["r", "4"], " ", "\[Omega]", " ", 
    RowBox[{
     SuperscriptBox["h0", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   RowBox[{"r", "-", "rs"}]]}]], "Output",
 CellChangeTimes->{3.9630381349313583`*^9},
 CellLabel->
  "Out[656]=",ExpressionUUID->"b649b238-767b-8a45-af96-3782d3186a8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RddOdd", "[", 
     RowBox[{"[", 
      RowBox[{"4", ",", "4"}], "]"}], "]"}], "//.", "YLMeq\[Theta]"}], "//", 
   "Normal"}], "//", "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"eqABodd", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"%", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[Epsilon]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"0", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
           RowBox[{
            SuperscriptBox["YLM", 
             TagBox[
              RowBox[{"(", 
               RowBox[{"1", ",", "1"}], ")"}],
              Derivative],
             MultilineFunction->None], "[", 
            RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}], ")"}], 
      RowBox[{"-", "1"}]], 
     RowBox[{"Exp", "[", 
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}], "]"}]}], "//", 
    "FullSimplify"}], "//", "simplin"}]}]}], "Input",
 CellChangeTimes->{{3.9630381806377735`*^9, 3.9630382386692696`*^9}, 
   3.963038401542534*^9},
 CellLabel->
  "In[686]:=",ExpressionUUID->"685b80b8-8e04-0f4b-b89c-befd690c12c2"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}]}]], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "t", " ", "\[Omega]"}]], " ", 
   "\[Epsilon]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", 
      SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
      RowBox[{"h0", "[", "r", "]"}]}], "+", 
     RowBox[{"rs", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
      RowBox[{"h1", "[", "r", "]"}]}], "-", 
     RowBox[{"r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
      RowBox[{
       SuperscriptBox["h1", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SuperscriptBox["YLM", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{
       SuperscriptBox["YLM", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.9630381965530014`*^9, 3.9630382408571205`*^9}, 
   3.963038402511324*^9},
 CellLabel->
  "Out[686]=",ExpressionUUID->"fb89ea0c-7da9-3648-a465-2e86a4180b8b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
     RowBox[{"h0", "[", "r", "]"}]}], 
    RowBox[{"r", "-", "rs"}]]}], "-", 
  FractionBox[
   RowBox[{"rs", " ", 
    RowBox[{"h1", "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["rs", "r"]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["h1", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}]}]], "Output",
 CellChangeTimes->{{3.9630381965530014`*^9, 3.9630382408571205`*^9}, 
   3.9630384026429234`*^9},
 CellLabel->
  "Out[687]=",ExpressionUUID->"058e370c-7385-1e46-bcd5-d79aec32030e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"eqsOdd", "=", 
   RowBox[{"{", 
    RowBox[{"eqABodd", ",", "eqrAodd", ",", "eqtAodd"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}]}], "Input",
 CellChangeTimes->{{3.963038384818945*^9, 3.963038416924572*^9}, {
  3.9630384522963867`*^9, 3.963038457624466*^9}},
 CellLabel->
  "In[689]:=",ExpressionUUID->"20fdcc8c-80bf-7742-9d44-a2348e0b27db"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
           RowBox[{"h0", "[", "r", "]"}]}], 
          RowBox[{"r", "-", "rs"}]]}], "-", 
        FractionBox[
         RowBox[{"rs", " ", 
          RowBox[{"h1", "[", "r", "]"}]}], 
         SuperscriptBox["r", "2"]], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           FractionBox["rs", "r"]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["h1", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", "\[ImaginaryI]", " ", 
           SuperscriptBox["r", "3"], " ", "\[Omega]", " ", 
           RowBox[{"h0", "[", "r", "]"}]}], 
          RowBox[{"r", "-", "rs"}]]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"], "-", 
           FractionBox[
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
         RowBox[{"h1", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["r", "4"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["h0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"L", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
           RowBox[{"2", " ", "rs"}]}], ")"}], " ", 
         RowBox[{"h0", "[", "r", "]"}]}], "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]", " ", 
         RowBox[{"h1", "[", "r", "]"}]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]", " ", 
         RowBox[{
          SuperscriptBox["h1", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{
         SuperscriptBox["r", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["h0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9630384585459385`*^9},
 CellLabel->
  "Out[690]//MatrixForm=",ExpressionUUID->"cded9316-6e55-8c4a-8102-\
d94e42d347a4"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating  equations  and  deriving  RW  equation", "Subsection",
 CellChangeTimes->{{3.963038420898464*^9, 3.9630384475805855`*^9}, 
   3.963038508664177*^9, 
   3.9630764597311726`*^9},ExpressionUUID->"0e20ad41-7ddd-d04c-8b54-\
f53a278b1d7f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"eqsOdd", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "==", "0"}], ",", 
    RowBox[{"h0", "[", "r", "]"}]}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"eqsOdd", "/.", 
        RowBox[{"D", "[", 
         RowBox[{"%", ",", 
          RowBox[{"{", 
           RowBox[{"r", ",", "2"}], "}"}]}], "]"}]}], "/.", 
       RowBox[{"D", "[", 
        RowBox[{"%", ",", "r"}], "]"}]}], "/.", "%"}], "/.", 
     RowBox[{"{", 
      RowBox[{"h1", "->", 
       RowBox[{"Function", "[", 
        RowBox[{"r", ",", 
         RowBox[{
          FractionBox["r", 
           RowBox[{"f", "[", "r", "]"}]], 
          RowBox[{"Q", "[", "r", "]"}]}]}], "]"}]}], "}"}]}], "//", 
    "FullSimplify"}], "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eqQ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"f", "[", "r", "]"}], "2"]}], 
      RowBox[{"%%", "[", 
       RowBox[{"[", "2", "]"}], "]"}], 
      FractionBox["1", 
       SuperscriptBox["r", "4"]]}], "//", "FullSimplify"}], "//", 
    "simplin"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.963038697370367*^9, 3.9630389994095745`*^9}},
 CellLabel->
  "In[736]:=",ExpressionUUID->"d6f18db1-a141-6c47-901b-42da362e7d4a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"h0", "[", "r", "]"}], "\[Rule]", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"rs", " ", 
        RowBox[{"h1", "[", "r", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{
         SuperscriptBox["h1", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}], "-", 
       RowBox[{"r", " ", "rs", " ", 
        RowBox[{
         SuperscriptBox["h1", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}]}]}], ")"}]}], 
    RowBox[{
     SuperscriptBox["r", "3"], " ", "\[Omega]"}]]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9630387207870846`*^9, {3.9630388048759956`*^9, 3.963038821355379*^9}, {
   3.9630388529627056`*^9, 3.9630389998612022`*^9}},
 CellLabel->
  "Out[736]=",ExpressionUUID->"da05af59-8f49-0247-8eef-dcb23345fc0f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"0"},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
               RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"Q", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["r", "3"], " ", "rs", " ", 
          RowBox[{
           SuperscriptBox["Q", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"r", "-", "rs"}]], "-", 
        RowBox[{
         SuperscriptBox["r", "4"], " ", 
         RowBox[{
          SuperscriptBox["Q", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            FractionBox[
             RowBox[{
              SuperscriptBox["r", "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "3"}], " ", "r"}], "+", 
                RowBox[{"4", " ", "rs"}]}], ")"}], " ", 
              SuperscriptBox["\[Omega]", "2"]}], 
             RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
          RowBox[{"Q", "[", "r", "]"}]}], "\[Omega]"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
               RowBox[{"4", " ", "rs"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "\[Omega]"], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["r", "4"], " ", "\[Omega]"}]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["Q", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "r", " ", "rs"}], "+", 
            SuperscriptBox["rs", "2"]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["Q", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], "\[Omega]"], "-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["Q", 
            TagBox[
             RowBox[{"(", "3", ")"}],
             Derivative],
            MultilineFunction->None], "[", "r", "]"}]}], "\[Omega]"]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9630387207870846`*^9, {3.9630388048759956`*^9, 3.963038821355379*^9}, {
   3.9630388529627056`*^9, 3.963038999872854*^9}},
 CellLabel->
  "Out[738]//MatrixForm=",ExpressionUUID->"b1d1acce-2eb3-b743-9bf1-\
9d98445cd0dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"eqQ", "\[IndentingNewLine]", 
 RowBox[{"VReggeWheeler", "=", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"%", ",", 
      RowBox[{"Q", "[", "r", "]"}]}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", "->", "0"}], "}"}]}]}]}], "Input",
 CellChangeTimes->{{3.963038910790142*^9, 3.9630389112187004`*^9}, {
  3.9630391397658596`*^9, 3.9630391404457226`*^9}, {3.963039199625519*^9, 
  3.9630392309262505`*^9}},
 CellLabel->
  "In[741]:=",ExpressionUUID->"70580529-5e6f-fa4c-a668-f75b2c4bfb55"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"L", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
          RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}]}], 
       SuperscriptBox["r", "4"]]}], "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], " ", 
   RowBox[{"Q", "[", "r", "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"r", "-", "rs"}], ")"}], " ", "rs", " ", 
    RowBox[{
     SuperscriptBox["Q", "\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "3"]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
    RowBox[{
     SuperscriptBox["Q", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "r", "]"}]}], 
   SuperscriptBox["r", "2"]]}]], "Output",
 CellChangeTimes->{{3.963038911689966*^9, 3.9630389654573364`*^9}, 
   3.963039001052706*^9, 3.963039232292341*^9},
 CellLabel->
  "Out[741]=",ExpressionUUID->"1a855a46-a8fa-0f4c-9bc2-854e7838567c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
     RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"r", "-", "rs"}], ")"}]}], 
  SuperscriptBox["r", "4"]]], "Output",
 CellChangeTimes->{{3.963038911689966*^9, 3.9630389654573364`*^9}, 
   3.963039001052706*^9, 3.963039232296097*^9},
 CellLabel->
  "Out[742]=",ExpressionUUID->"44ccb642-72a2-1546-a410-d55f2502f6b2"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"VRW", "[", 
    RowBox[{"r_", ",", "L_"}], "]"}], ":=", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", "r"}], "-", 
       RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}]}], 
    SuperscriptBox["r", "4"]]}], ";"}]], "Input",
 CellChangeTimes->{{3.963039239685505*^9, 3.963039251698498*^9}},
 Background->RGBColor[1, 1, 0.85],
 CellLabel->"In[8]:=",ExpressionUUID->"6f076793-e703-844a-bd99-5576a71b834a"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot  of  RW", "Subsection",
 CellChangeTimes->{{3.963035545149473*^9, 3.963035555735045*^9}, 
   3.963038352234751*^9, {3.9637200703310966`*^9, 
   3.9637200707496605`*^9}},ExpressionUUID->"2b7e281b-2ad6-a14b-a329-\
2b360ae71830"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"VReggeWheeler", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rs", "->", "1"}], ",", 
     RowBox[{"L", "->", "2"}]}], "}"}]}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"VRW", "[", 
      RowBox[{"r", ",", "2"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{"rs", "->", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0.5", ",", "5"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9630316614313564`*^9, 3.96303171614472*^9}, {
  3.96303499900082*^9, 3.9630349992020054`*^9}, {3.9630393252679024`*^9, 
  3.9630393316624737`*^9}},
 CellLabel->
  "In[745]:=",ExpressionUUID->"62b440b8-75c3-804a-8047-1baa75c6de8f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     RowBox[{"6", " ", "r"}]}], ")"}]}], 
  SuperscriptBox["r", "4"]]], "Output",
 CellChangeTimes->{{3.963031699013956*^9, 3.963031716761448*^9}, 
   3.963032031117502*^9, 3.9630348780023804`*^9, {3.9630349995783043`*^9, 
   3.963035012138628*^9}, 3.963039333042948*^9},
 CellLabel->
  "Out[745]=",ExpressionUUID->"035c85bd-b181-4e4b-bc0f-8c64174ea7b1"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], 
         LineBox[{{0.5000000918367347, -4.408159215436037*^-6}, {
          0.5013802306425184, -0.06534367946290844}, {
          0.5027603694483019, -0.12889618119031265`}, {
          0.5055206470598692, -0.25080362127651484`}, {
          0.5077367036119041, -0.3407663639668789}}], LineBox[CompressedData["
1:eJwV1nk4Fe0bB3BRZCs5lmRrkSVFCyHqO/lFKFtRhKi3EoXyUkJkSSVSpKRN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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]], 
             
             Line[{{0.5000000918367347, -4.408159215436037*^-6}, {
              0.5013802306425184, -0.06534367946290844}, {
              0.5027603694483019, -0.12889618119031265`}, {
              0.5055206470598692, -0.25080362127651484`}, {
              0.5077367036119041, -0.3407663639668789}}], 
             Line[CompressedData["
1:eJwV1nk4Fe0bB3BRZCs5lmRrkSVFCyHqO/lFKFtRhKi3EoXyUkJkSSVSpKRN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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0.5, 5}, {-0.3407663639668789, 
             0.6051467737291498}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0.5000000000000011, 0}, 
           "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
           "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.368417, 0.506779, 0.709798], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               Identity[
                Part[#, 1]], 
               Identity[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0.5, 5}, {-0.3407663639668789, 
            0.6051467737291498}}, "Frame" -> {{False, False}, {False, False}},
           "AxesOrigin" -> {0.5000000000000011, 0}, 
          "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.368417, 0.506779, 0.709798], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              Identity[
               Part[#, 1]], 
              Identity[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]], 
         Line[{{0.5000000918367347, -4.408159215436037*^-6}, {
          0.5013802306425184, -0.06534367946290844}, {
          0.5027603694483019, -0.12889618119031265`}, {
          0.5055206470598692, -0.25080362127651484`}, {
          0.5077367036119041, -0.3407663639668789}}], 
         Line[CompressedData["
1:eJwV1nk4Fe0bB3BRZCs5lmRrkSVFCyHqO/lFKFtRhKi3EoXyUkJkSSVSpKRN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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{0.5, 5}, {-0.3407663639668789, 0.6051467737291498}}, 
       "Frame" -> {{False, False}, {False, False}}, 
       "AxesOrigin" -> {0.5000000000000011, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           Identity[
            Part[#, 1]], 
           Identity[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.5000000000000011, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0.5, 5}, {-0.3407663639668789, 0.6051467737291498}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.963031699013956*^9, 3.963031716761448*^9}, 
   3.963032031117502*^9, 3.9630348780023813`*^9, {3.9630349995783043`*^9, 
   3.963035012138628*^9}, 3.9630393331544476`*^9},
 CellLabel->
  "Out[746]=",ExpressionUUID->"c7aebd37-44f5-144f-9159-db841a2b5efd"]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQt8ztUfx59Yotas0MWaKKUwwohFJaIbYa6vTCgWNZe5NMumaLmliEYX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    "], {{0, 22.5}, {159.5, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{144., 144.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{159.5, 22.5},
  PlotRange->{{0, 159.5}, {0, 22.5}}]], "Input",ExpressionUUID->"19d0e505-\
0386-f741-b1d3-73a8b7ba2a43"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VRW", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VRW", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "3"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VRW", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "5"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<L=2\>\"", ",", "\"\<L=3\>\"", ",", "\"\<L=5\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9630354307100735`*^9, 3.963035446356287*^9}, {
  3.963039347555029*^9, 3.9630393541430264`*^9}},
 CellLabel->
  "In[752]:=",ExpressionUUID->"7c792f20-d148-2349-8cd6-2c51106d053a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{{}, {}, 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.368417, 0.506779, 0.709798]], 
            LineBox[CompressedData["
1:eJwVVXk01H8XtpZ9GKVeIdkHhTBIdT+ICMmSFNp+FUlokq30akEylmTpl6UR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             "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.880722, 0.611041, 0.142051]], 
            LineBox[CompressedData["
1:eJwVU3c41f8XlxHK3mRHZraLhvPGV0tSlJTVN6NSSchsUCFfKyTFvb52pLLJ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             "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
          TagBox[{
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.560181, 0.691569, 0.194885]], 
            LineBox[CompressedData["
1:eJwVUnc41Y0XN7Pdr/3yClkNXtuNVOegJUrolSJJyIiMstKgtKzKTEjllZJ1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             "]]}, Annotation[#, "Charting`Private`Tag#3"]& ]}}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
               Line[CompressedData["
1:eJwVVXk01H8XtpZ9GKVeIdkHhTBIdT+ICMmSFNp+FUlokq30akEylmTpl6UR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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Line[CompressedData["
1:eJwVU3c41f8XlxHK3mRHZraLhvPGV0tSlJTVN6NSSchsUCFfKyTFvb52pLLJ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                "]]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Line[CompressedData["
1:eJwVUnc41Y0XN7Pdr/3yClkNXtuNVOegJUrolSJJyIiMstKgtKzKTEjllZJ1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                "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
             "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.560181, 0.691569, 0.194885]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.880722, 0.611041, 0.142051]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.368417, 0.506779, 0.709798]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>]], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]], 
           Line[CompressedData["
1:eJwVVXk01H8XtpZ9GKVeIdkHhTBIdT+ICMmSFNp+FUlokq30akEylmTpl6UR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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Line[CompressedData["
1:eJwVU3c41f8XlxHK3mRHZraLhvPGV0tSlJTVN6NSSchsUCFfKyTFvb52pLLJ
6l57hSg769rX5rof65uf3x/nOc/rec7zep3ndc5L6uYDcyd6Ojq6lr36f/e7
b5C//7UoibuktZ/B2wksa4+j8kguUvNfKcZ2bh/hRozwO2rQQZIOq7dyNUs5
pOqRV5KPs5Dqnbp57xyrhQRd0ZAgMhNJum1CpACawVqBgfyWnZFkNHfiZB5/
B5zyM/5qGE5PSpeL3Z206wI3LEU7+a99JOMJFel80W4I5R2V0ZWjIx0q9rIh
1/VC+qekQKnLf4j7BJkOiVkNgN5Jsy9F4TvE2idR0bs9v6GHN45VxX2TaHcl
q5S9bRQo9xIGPXk2iHJHHtlVLo3BnCFn4YFWGjH1B8fqTdZxaMg9j2x8qERd
oXuyadKTcO8a+x3l22vE+1xXNKqkp4DBZf6IqvMq8c67GsUfItNgpWpHPxG8
TKQvmzH9vjYDpOHzXga+FKKHP2FUwWwe8D5hhZYRI8SljOyki3PLcLEpq6pQ
e4hY9WDoykmdFaCuxHCLLwwQaeNdZ1IDVuAEM19dblAP0T/mULco2yr4vGw2
k4r9TiRPMIjkMq+BWjCnJEdOEzEht/nECYM16BOT/OTXU0cMXDJ7WuezBq+X
0npcm8qJ2aE/BXbH1oDuTaXeTStvkIvdrx+bRAVU5DPt/igZ1lcKmT2aqUDy
qLkPzZ/h4fTdK8WrVLhhyQZNlArwnmh5EInWYSa0Zl/E/RZ4UGPRW9GyDlYZ
4jZ+bm1g0uVnNTi7DjIQV5Sl9QP8jwR45DLTwMrWL4tN4ifk2sah90CD18nt
s1e/9QELW7bojRQaPN3tC+XQGwC5uHfaA19p0JUoi/RyB0GF6ZivaAcN8nK4
PQIih6FI1aNTbIMG7iR243FsBObZqhwWD2Aw5i79Ku3LKLiPPJT8KIrBxXqx
kFMcZLB0OWrBcBKDFdm3jZcryHB6QuJingkGwcEPpgnO42BtJxR66xoGB0ws
l1S4JoBeqlVTzRkDGp71Ot/XCajTcrjI7Y5B20kT0et2k9Cwo5zD/QSDuVNG
nw4yTEGAncawTggGZ1l/Vg2dnoZWfl4jzvcY7Lx3W+SZmYaK6x4V35P3+Ovv
Wg4Fz8AxP2pi0wcMxiWCLp2SmYWK1+nvWb5gYPYCG7EkzcIg3yTEFGJg6sOT
I2hNgVJC7orLVwzKfcNYo6kUyJ/roMRX7s3fD2NoDZ+DuLe8BuIkDN4ZPLFs
OzwPFcQHk/S1GCRppfr8WzYPjYfFMs7VY5A8/QB/5sICGI1/VNxqwECBvbKw
Y2wBVixZdvmbMFhWLXM/7rkIj1HwP6l7eLa50TyGaQkoGR386XvYJEU8biBu
CRJSB1rE97BWbKZ0BM8ysHt1Fgs0YvBYqY2Qc20ZBASo9VF7euInU6JMkpdB
OsS9PWJvH53Fc0UPppah9RgK4avG4JjRk3wR5RXYKBiNkPuGQY3jHUGzhytQ
mH7UuaUcg68KGX9zlqyA1y8Bf7pSDALzmDZst1agiWwt0VaAgWKtq+pJ/VVI
1keRmnv+3S2OP5cbuArRbnrzuGwMKu0a/ErqVkFvOf70QBoGXY0Bo5f3cmJa
qPheMmnvPsYjT+3D1mBS0SIhJRoDNqZ3Hzu+r4EA5tM99g8GjTfV1obZqfBF
WUjix4u9fynblSVHUuFwp7tMtScGX9pE4/rbqTAlNdzTdA8DDqbfSt4c69Cv
Jhv8yhGD52eqL+eEr8NQ0iSHngUGZK2yVukgGkQf9KpPPIpB5vwzRu8aGqxz
kzqTD2MQUKZj/WSXBk2Pa0tdhTEoVdn3IcNnzwdfVc97jBhQzCMaQm5tgHpi
VLZkHw3CCJtjWUkbYCTk436zjQbatbiAyO4NsGY5N/Jsj3d/WVDrR8NNmL2i
+9T8Ew30c5/rgsgWCJ04KOT9lAYbn2vSg4jbYJI92JElRgNSS/OO1vQfGFTU
t2w2XQenrY1CU6FdUNc5JGW7l/dJAaFWOLsLi/n+ydMa69Cm3LKa/3EXrqlk
ksmC63Ap+5bFgjYd+u/zRlXAGBXiHBiT29bokOtqdFG1BxVcrIiUEgd6ZEZi
Z2CJX4PnrnYJArHMyH94RtTGYRkKNp+PbX9gQ6kmorS1PxSwmFWzVCtnQ+6S
wqFtcxQ4a5KzZf+dDQ1/5tT52kcBxpHc5bxlNhRStltMKqDA1aw5GxE9dtQU
OLmBv0UBLlatG9zN7MghPILT59csrLx69de3SQ6Eq84oulE+A81NF3s+hXIh
pld8RYeKpmBt6M3YfzFc6P1x1ofRaVNANnq4ch7PhVz4lDwEY6fgaf8Bxckv
XKipxIXhsvsUnNKQNfnzkwvNPI9+HKE+BWx+PwjdYtzIc5Vffa1gEgjrfzYV
8rjRI5xjqED1BMC5MMmpDh4kxHss8yzzOCSPa71M6eNBXg3htyK3yNA1qB5s
PcaD7opwCY4skCFdFX+3dZUHhbPxsaX/IkPIzI+ZBH5eVFhJGS1PJYMn8SvL
1nVetC/AZoPLgAwHretwtRO8KOzigc/MwWPgXFzr+p3Kh0Yx3ozXKqPgs3k+
InuHD0l6T0dJyI6CYVZ3dRAjP2LHZ10rOTQKdXdvuB3n40eWkxl3tllGIfue
53aiJj86bf4VV984ApUOt4M13PmR8RxXzQncCNBbhglXLPIjaSf3I8riw9Bv
qs7hOCmAogmLU3MCv+HHi2LNggUBtJu2E6i7/zeYEYhPdtcFELN4qVfs+iC8
54x6Hr9fEDmb8ql6/hqE20f2OVXJCSIFyQ7lkZhBWP1nWnfsjiBKZ/ktc4Fn
EGxrmI0jFwSRqFMNi+KhAbDdTpJMXxVC1fKU7bFLfaCS5ceisyWEgqYV6E4Y
94FXaqZl8z5hdNi1LuFf3T5YUm+Rm+cSRr1mI/dfSPRBd5HoR0VVYVQr1Bla
udALArPib8LuCqOOqwM582G9kNr8mm10XBjZtZ83Yu7oge+GIo8pXSKIISvS
8LprNyx4O2cvpoiia73NWtucP8Hcq+vA6mtx9OTWM4ln0z9AW4Nh2ltZEm16
TFTUObdDGU/dYK+kFDom7cpWgVohaxfZXuKQRowLfXiEbwL27n8vkWelUcUV
amCUbwPQ6/4totZzGJVEaD5q8KwD0LH+rZUvgzjbb+vYt9eAz7wF2k+QRZLi
eb0Rx6vh83mrc0dfHEHyCvoyst+IIJB9fKXBSg6JZBYn+vhXgb1y42EjkEeh
O2pH1s5VwE77fznP+RXQ+kR1/eyjMtDMKZaunFJAPJVY76WeUkjWIwYONyki
xtriM2X6JSB+ifM/hUQlxG29deHPZBF8usFgYPVUGbV441y8YwrBnsHl2xeb
o+inUERIhEMBSL9tr/JXUkGFRvnMHH/ng0axZL/8QVUUEKCRy3QjD8wMRp64
Daoi87dHiAbMudDrc/jNGws11HQuXnHb+zOUruneHq5WQ8u+wTkt0zmg28fq
Gymvjl4mapk6RX4E96WH8lnx6mjmFddtX81s0Nc/5K61q47k3yoR5vZngXzf
49FwRw2kwTPArUjNhBE2xi6TLg1kd/9akstwBlgYScpF6Woiqr62TdR8Opib
RNzX/qCJbkq+f1eGpYFj95niz7xaKFlf1/qCYBq4OnDfLfPRQn1m2p37LFLB
rXliXGZKC8UGSLzUCUsBsUdiSkrntZHv1aJH24PJYKj3+yxPnja6eOZh1Zpe
MkQPcwpaiuKQt73U5Rfy/0LSvGwHBOLQZd2+xF+MSUAdYlaif4FDPwXoisi7
BJA07n9Z93IPn4pkXN0iwL1lE42zr3CoQtbIlG+FANr8/p7mUTjk2D/88NYQ
Af4StHjrSMAh082pL6dLCDDa6WMeUoZD8Xobugu3CSB7Z/fe2Qoc0g1XSJBy
JECmVGDQwSoc+nDyhNxVewIYOXnnRZFwqLr4WW39FQKIHNNbjG/EoQHXoc08
QwL8Gf+bNasbh1hjbrMSRQnga1PP4NK7p+dxfptJiACzmQo7Sv049NT+IO8F
XgKEitCmcn/jEJ43qWCMlQBNV7LSS8dxSMal7IMAhodIHdEo30kciuMT/Oa8
ioe08ljv49M4lCxtjZUu4CHrQJQhkYJD+rPinbYTeLD4h1c2cB6H9NC4W8EI
Huq4CExGizjkoyOowTKIB1FMaYJxGYdcH9vy2ffgwfktidSwgkMiZCvB0k48
/A+Kiii2
            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Line[CompressedData["
1:eJwVUnc41Y0XN7Pdr/3yClkNXtuNVOegJUrolSJJyIiMstKgtKzKTEjllZJ1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            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> Identity, 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ParametricPlot, "GroupHighlight" -> False|>|>, 
      "DynamicHighlight"]], {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.05], 
        Scaled[0.05]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 1, Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "ScalingFunctions" -> None}, PlotRange -> {All, All}, 
     PlotRangeClipping -> True, PlotRangePadding -> {Automatic, Automatic}, 
     Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"L=2\"", "\"L=3\"", "\"L=5\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.963035440244597*^9, 3.963035446980572*^9}, {
   3.963039355898659*^9, 3.963039359520439*^9}, 3.9630393903380375`*^9},
 CellLabel->
  "Out[752]=",ExpressionUUID->"dc0e5737-cb4f-a745-8cf7-b473b8c36086"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"VRW", "[", 
           RowBox[{"r", ",", "L"}], "]"}], 
          SuperscriptBox["L", "2"]], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"VRW", "[", 
           RowBox[{"r", ",", "L"}], "]"}], 
          SuperscriptBox["L", "2"]], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "5"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"VRW", "[", 
           RowBox[{"r", ",", "L"}], "]"}], 
          SuperscriptBox["L", "2"]], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "20"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<L=2\>\"", ",", "\"\<L=5\>\"", ",", "\"\<L=20\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9630319469991207`*^9, 3.963031978522726*^9}, {
  3.9630320343997803`*^9, 3.9630321076922474`*^9}, {3.9630345939578247`*^9, 
  3.963034621545227*^9}, {3.9630348529066334`*^9, 3.9630348539564667`*^9}, {
  3.9630348867223816`*^9, 3.9630349123728848`*^9}, {3.9630350587513294`*^9, 
  3.963035124123087*^9}, {3.96303516608922*^9, 3.9630352681396713`*^9}, {
  3.9630353643634796`*^9, 3.9630354081647663`*^9}, {3.963039397071209*^9, 
  3.963039426337944*^9}},
 CellLabel->
  "In[754]:=",ExpressionUUID->"966a5b58-0c08-f840-9ad0-8182c1d01d3a"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVlHk01H8Xx62VnVHqsSUig7IPUu4HUZJk+UnRviiGmMRQPMiSCCn0SzSy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            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVU3c01///NbN3iJAZ4pv9jpTHEyUrkZLKCnmbJSkj+mRXZnZKUeJtZJPZ
+43XWySziCR775EdP78/7nmce+7jnsc59zyuiO3dy7epKCgoWg7w/9PXTbPo
UIwASWeA/fFgijKYNaijqih2ksF0fpPudR+wieVLXgthIsntCy71zj+Fd2oj
y2nq9KST/X30cXaxkKIqEBYyQku6eFuvZEswGW5KU48kstCQDtNPh2FZqaDj
e75CK4KKpJH8/ey5gHRw30hXSTtHSRqOjKac4M2AZ1xD4qqSFCQqdt/vQcmZ
kJH3JkDkyh5RdfKr7nfqbFA7eym/NGKX2NNiHR50Ixd6uBIYTnpsEXusO55m
fCuAGdeUfk/OTaIzVX1/zlohzGqxlTC2rBM5fJ6GrW0VQWOBIbLwXiOGuwwM
+c+UgOt1FidZx1WiibrCJ92eUqB2njsu57BC7FA4In60qgzM5ayoxkKXiNa8
lkXfnT8B6Y/hQ02fGaL/jxwnBq8qeO0dXmIWOUgstrmpKuZIBOMmQm2JygDx
7k4VH+8CEdaWYzmE5n8R212acl6eIsEZusNYQUgP8ZvuR7uaIhJ4BzdfEon7
RtTZpgTKiDqQD2UTZs1tIm6L5gSE1tZBr6Bwnm8PRvRmO+sjMV8HMYvve+40
VREtOy5VTevUA0V8jZqtuRfs775MoZ6oB1TqPenxIA2yp46vdjI0AOl+vRs0
fwQeJrNwEdkGsDFjhqaZahC6Wkt1z7UBkqvLngSK18H8lwSj0OcNQO+XTbN+
AYP927SVF7IaYOpZPWWk21fwOONmsP67Acw/CFn4urfCiO0ifv1vA4hDQilB
uQMeZdO9aGLBwNzSl8B87DtoTDyapj2NQYaoXq9Z5A+wShIdCzDCoNTyVb7a
Rjcw9yqHLt/CICatbfra5144qu2W/zUEg8f7vc9Y1X4Bt+aJlpQkDLpeSSC1
gn54obqqYUrA4Nfp+uF/wgOw0WDeufsJg8JcjvtPov5AN/EodVojBh4klvOj
G4Pw400S+/kfGAx7iD59nz8EVi+511aHMDAmC4bpsI6AltHp6cgNDJYlEr9c
qR6BpKrvFWGUZAgNvTuZ6jAKohn4PwRGMjAamC2eZB8DLoFf0pucZFh/zXDj
cMUYpLudUfHjJ0PrWQOBG1bjsJKV6KAuQoZZHe08JuoJ0AtLW1aXJEPnOTt6
5cwJmHJw7guSJYMew/fagQuT8HJgffmIAhl2X7ovcE5Nwvxb8jCFysE9sovZ
QOgUBJ0xFtNUJcPosRATHfFpuIB8Dg2eJsOloI1BM9I01OsvFA2eIcNFb85c
3pszYB/vL66rQYYqn3CGF2sz4GVnjROEg323cOqWiFnQm7yfYnfAkzX9zVrF
5sB39sHgsQP+Rvmd99vKOXDrFL1nduBPm7z7WtdoHixVzV8ynSWDNEtNSfvw
PIhVSgZoq5NhSa7SQ91zAQjcwwpUamSYbv5yOZZ2EZpUuRINcGQwSBdK+JWw
CCzWwb5iSmRQjssUjeRcArtakehIOTL4ybSm5l5fAu2NCXykDBmEzqZHG6Qt
gVdxrf/xg7xOLeiX3p1YAr+4q3IWomQ4re1fxC+7DNkza3UKgmSot3fivXRv
GVbNtGxzeMlQIf3hFlv5MjSn0Uk0c5AhoJB203J7GdKZF+heMJHBpSxJvyBg
BejHrMok9zCosWr0LcdWgOQ6zLK7fvBfX54MXaFbBZP5hvfBixjsnh98bB2+
CtSituSaQQxCK/clRqLWwJ5z0Y+5FoP8VoGEvrY1QFdtZhtLMGCl/S3jxfoX
pmLLNHRzMAjUrbuSG/EXKk5F52UlYjCiXNkiGrIOn4ReC7G5YTBzObIxDL8J
HEp/n1NwYhCeujVMeLMJPyQHQ78dwkClAfckqnsTdNqPlvnvNMChypCWHK0t
oJyWaY8bawCNgkBV4N+GKNNrgTllDbD5sT4jhLgD7tbcSnpXDvr+tXlXeXIP
qIg8qY5P68HZnDhTbkeF5oJv825OkiDwjlUKTxwdEo+49+/kajX4B37cv0ag
Q2It78vZflfDFx/W5JhaOqT272wqLbkayo4r5E5O0qFXAd7b8knVIEf1y0ju
DD2SKFc8FHqmGrYlXB8pjdIj0fSbs5LhVZBfS7HqJ8OIeqbbrcRVK6F4K3B4
J4sZ7W5V26W1lYPptLyZfBUzoiyv3CLXloOeQe629TdmxDJPX7GTVw40gwVL
hUvM6JiSxcOk8HK4Rpi14FdjQVOuCZ5ReuXAzqBsw9HMgvj27U7eaSqD5adP
z30eZ0W1OFv+F52l0Nxk3JP3jB3V6F9/fIG1BFYH4of/xbKjfXcHz7n9YhjR
vrds+JodqTws1UpbLobHfYwnxvPZkXpJp5hydzHoKEoY7H1nR/GUCoJMqcXA
7NuR2i3Igcxftmvh5Yoh9e/elnQhB2J69x+9g1URgH648EQ7JzKz8chVxwog
bVQ5OL2XE/1X+NrEOr8AuvoVQm8Oc6JmGl+UnFwAGXKvXVpWDvQ4v3g9twII
m+qYSuHmQvkUV29l8RaAJ7GCfvsGF9pNjDM47Z4PTDcxXMMYF6LUTjjJJ/8R
HMoa7nxbO4wuZtEqr43ngPeWYWT27mF0TDLXdLA7B7QI3XUhNNxoW1VRt5ec
A5iLjbv6YW708Eeg5+qHHMh29dx5pcSNrn2x0Gh1yIEaO8dQRQ9ulL+Xs0w5
mw1UZuF81Qvc6JDQESnWfwTou6jAaj/Og5x99Y72ncuCjqAypeJ5HvREE/e7
DJcFl1KJ/vt/edCn2Vu8b6Wy4CVbdGDSIV607uSLJTJngeNxytu1krzIC5oe
8HVnwsrzSdVhJ15Er3/C2MYxEyzr6c5HzfMiP6UreslJH8By541wxsoRdNG3
P4iBJwNOEnzpT20fQYMrR5ZsmTLg4btMs2ZKPsRIlfIWo8iARYWvknPsfIj0
2TErbfY9dJcK5JyQ40MKrfgHVXXvgWdaKD7chQ+VSA5R37n7Ht41xzAPjfIh
aiPrlDcd7+CbFr/fTBc/Ko2cbY8mpMO8l0P2QroAmrT4S2q//hYuP+xiXIkR
QubMSZFNxFegokg96SUrjFrzfDzYZ5KhkhPr/yksghLtctn4LiYCYR9ZmrCK
okKu3oVFgXhg6X5rMjItigQMA2iOXY8FKtVb/PI9YqgsM+FCfX4MwKmbv5WL
xNGS6S+Otx+iwHvOFB1KlUBm4ffvLrBGwEdDc/3/BR1HTskUHvZdz4AnW325
0VwSMVt16sdthIG17BcxbZBC/KaNIC4bCrtt/3IDuaXRdK9LHGdeMCjllonW
TEijyta1VDbzIEhTIwb8aTqBSALqj/4wBoKQCds/6VcyiPE3WUlv+Qnk2VBr
mj+WRW28P0eMKv4Da2rnz/kW/0MysRv5Ul/9QTSxrfaRzEk06tn2qkrcDxTL
hPukmOQQ21FGvsUAX7ikOejv3i+HEltTFBiO+sBPb7H4eFN5hAvfzeLr8YJP
q6qOf+rkEU3xV8P4mIeg2svgEyWlgPJ+GsnUez0Aj8V7UoQkBYQ7Na3VZekJ
GhpHPZT3FdAHC021XKf7INXrNxRhr4jGfaV6op57wCAzTZdBlyLiKuai58++
B6bawpLRqkroybx2aN+YO1w2iHRTyVJCV648IYCQO9h365Z95FJGkzWxe886
7sAdOw6XSm9l1KmVYasb6wbuzWOj4hPKaDzikMhDI1cQfCAoI2Oogv6obOmE
KLqAltpvPc5CFXR4hE2eSdYZXvxh4zUTwCGbdc/s4mNO8GZOoh0CcGjea+dD
jJIjrA3QyVAF4dDP9NDVaDlHED7fF4wF45CI4Z5GjIwjuC4ZKOo9xSECl31b
nJgjqHA/8rwcjUNL8ZPkTC5HOMdrmmifikNdK3LtO6t4GOr0vhxWiUPDxg3M
NmV4kHDad9WrxiG5VB7vx0V4yBQJCGGqxSGvIKGfqR/xoH3bqzCahEP57Sx3
Bz/ggf+02kLSFxy6dr32n1siHvZGbzEQunFI0vOWSYUXHnwsyNTOP3EItle7
xu/jYTpTelemD4eqPY21D7vj4Rn/+kTBbxwS2pRfvO+Ih6arhIxPozikt8Tv
onEdD1GnBKJ9xnHIdi30xv2reHhfFeelPolDzx+b4rJN8EBgjNYizuBQ5ef+
Il59PJg+55IImMMhlug9Y2MdPGDsqbTaCzi0ymfc/0wLDwIbMmM0SzjUphZs
jGngwSGRRGpcxqHGSaPC/dN4+D8NYQbB
            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ], 
         TagBox[{
           RGBColor[0.560181, 0.691569, 0.194885], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVVHk41HsXL5R9yHq5dBFFlH0it84XpcRblpJs6TYkWxKRKEZkJ/u+x1iy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            "]]}, Annotation[#, "Charting`Private`Tag#3"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
               Line[CompressedData["
1:eJwVlHk01H8Xx62VnVHqsSUig7IPUu4HUZJk+UnRviiGmMRQPMiSCCn0SzSy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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Line[CompressedData["
1:eJwVU3c01///NbN3iJAZ4pv9jpTHEyUrkZLKCnmbJSkj+mRXZnZKUeJtZJPZ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                "]]}, "Charting`Private`Tag#2"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Line[CompressedData["
1:eJwVVHk41HsXL5R9yHq5dBFFlH0it84XpcRblpJs6TYkWxKRKEZkJ/u+x1iy
ZBdmzE/WlEvWkt1IlH2J8s794zznOc/nPOd8zir+zz0jG4Z9+/Z10eU/7eWk
WX4wSoRy/6L9hagpZTDBNFB9BDel73Kiu6KbJ1hHCyWuBbBThn8yT02xBEG2
+uRypgYLZd807yxT7QtIVhN5HjB5gJKxYYs9V08AcxnGyXhOJorj1eCTxSGp
oON1vlYrjIHCynXmQ/BAJrhsZqlmnttP8eLwYJI2zIFg3nFJtWP7KMoXA7VX
ql5CbnG6n/jV32TtuQvb2QdIoH7mSkll2C555epA4yIqhAHeONaTrttksZjh
a3veJTDvmPzJjWeLHJFG6g2EMvimxVXB1rVB/vuBf2P2qXJoLdVHFp5r5DrZ
8Q2EqwDHG5x35exWyd/C2DGDxQpgtF84Km+7QiZMNhCjWirBVN6KYTpwiZyq
EX0806IaKF/0H2o+mid3aczsPlevg1TP0AqT8DHy2UvvfG5/bASDdlJjheoo
+fSte75mBk2wthx96PDiCPnemlVTXlsT/M3M11IaMECuUXUX7SWRwfNZxxXx
mHfkqtha3dRUCigEconhitrJ7jNpt/o6KDAkKlbsNdBC9tA2C1Ffp0DUj5wB
5/Z68i8JQ2KXTjPsi21Q/8fUA4aFJH09B5oBVXrSXN0zYYrh+U7aRjNQHlCd
oOMVUPZ9tTPlp4K1CQe0z7+B+ePRVTWXqZD4psqXKNkM1luPg+/fpQKLdwHT
xoUW0JNIODtPpMJcMHV/uFMnRLvha8++poLpy8MWXi7d8GTbeV2unQqSEFdJ
UumBqfjrbHuf6bilF4njrz64krST5cKIQa6E7pBJ+EfQSjz4QIwfg0rLlBL1
zX4wZWpu+CiFQVTm+6/Xm4ZgoXC1xO4cBk/2hoJx6iPgGxLo4WmMQW+KFFIv
/QQb6a6K/rcwGDlNnfglNgoeH0RMXjhjUFZ06IFvxBfI0o75o8gLA1cK5/mp
zTEoHmOyGwrAYMJVIiinZBxOuImtiEVh0HV2OtDm5gR8y7eQCkvCwOCt6HMd
3CSIxcsoi2djsCwV33b1zSQIcHPy0AowCAy8R0uznQJm28Kn02UYsOmZ/DjJ
PQ2LUdUMYjUYbKSymvHVTsNO2PBCRgMG3Wf0RMysZgBX5GNh34zBNx3tYnbG
WaiIDz8b8BaDf8/dZlHJm4WYt+IGG+0Y6LL2NY5eoIHuL1ExrAuD3SSX7zxz
NBiJJXMvd9PzvXUwGQ2cg3Iu0RsBHzCY+ivAUEfyK0gWJBwM6MHgiv/mmAnl
K4xZw+81uv0/T54iQfN5kOI5/nuYbtc/CmV9sTYPP4Wa0tX+83cKZewK+wZF
bMvG/PR4iZo+Jt1HFuDEjJezGz1fukq2Z0bdAljr/xYxo/PJpN1LvXh5ESLF
jjp10vnKcDZUfJhYhDuLtfod9HqW5OtcNdy+Q2hkdogZFYOvHW1G0Qd+gOqD
tUG/Jgz0sg7HjcT9gLr2z+1a9RioxORJhPMsAS9LXH9mFQbest1pRTeWYPeP
i+YZ9P4ePpMVqZe5BCr3l1I1izA49f1S5b3ZJXjocbIl5CUGVMJdwSv3l4Hh
zq8fovT51cq8vMVVvQytQ/I9TtEY+JUd2LL8uQzH1Kovu4Ri4FCVcKnUbwWU
9r/8luCNQYNVq1d1ywpUnJhTo7rR96vNd/wq8yqwdj3xL3Ck9//82JOboatw
bZgpqdacPv+6PanJiDWYeViQKHgKg5Jukbjh92sQNsEjd/cEBrgDn2U9cOtw
ySCXM/gIBsSLzVeLwtahLyAYr8GFwaRKXZdEwAZYMhU+SJ6mwrxReOvzO1sQ
2VDd8zKICqFp2xOk9C0gMnuEO/tQQRXD+0b0b0EZByOvuCsVDtYFdBVqbUOt
1ihcMKfC2VKiGgj/hHcxr6XK5aiw9YqaG0DegZN9p9NK39HvvbNjV4X2G6TT
haWXDjSDvSl5vvo2A5IJsN45tdAERGerZIEYZpRfqckTRKgDH+KrveskZqTa
9tR/7nIdtD3CJUY1MqPzZuEHrej/reqoYhGNxoxwhiqqQbg6kGcYuSz/Nwv6
0nvhzVBdLfyUcnysPMWCWNJqNgh8tVDSuG/VW5YNKV70zZkbqobX28SJnXwO
NLAlJ5ubWgnGXxVMFOo50I7tPQ/u8ErQ1Sv6efMdB8KjhTNhPpXANFa6VLbE
gZ7+UN0rt6qE66RvFsLqnMhf6HJdpXglcLOqWB/q4ESC7q5KIYUVsBwUdK5p
BofUrD8a4dpeQ0e7wUBxMDdSUI5sMpAuh9XR2Ilf0dwIZ4x0pf4sh0nt+8v6
qdxIp6PuPTOuHJ4Msx2fKeFGm68TAzdWy0BHSUrvdx83ihMm9ntSyoDDqyet
X/QQumw05MtgUQZp67+3ZcoOoU9s1zceqJcCXAoVm/3AgworSn0niMWQOaXy
LGuIB/15M4RpxbkYej8pBppP8CCZSgdTAfNiyJVPdeha4UFqcw7cycrF8Hyu
Zy6ZnxetvRSUCZ0pAjdyLctPM17U98wsdU+/CNjNW/DYNC+KNRD0iZUpBNsq
zPndGh8a8cU+j/ORwHNbP7xglw/FPGR0unCQBFqk/uYAJn5EDj+D1W/mQ4uD
tYsGHz86PfskuG0kHwoc3XZSlOn4htCWR1Y+NNy2C1Ry5UcBJ344SivmA4NJ
qNCb7/zIpZ4nweFGHgz/TxFHmBFA1y2+Xe/uzIUe/yrl14sCqDMvh8zQlAtX
0sg+e+sCaN43LVW7PBeSuCKJCQcFEYvjsh8tIRfsju63aTwmiFoT5SKrbXJh
JYSmNnFXENU/6Yq1ZcwFSyrz+YhFQZQQ61BXq5MDljvpYrkrf6DzgdnhRfNZ
cJLkxXLq5x+o6J9zzNwTWfAwO8+kY78QEtba4vQezIIfip3HFriFUH/6ao59
Sxb0V4oUHpcXQjOt3aJZ6Vkg8PVwbKiDEPr1JRxzvJoF2R1RHONTQsg8SfuR
/ttMeKcl7D3fK4zIlurWDu4ZsOhhW/A9SwSxJ6cciZtOAaOHvWwrUYcR99+9
qkoFiaCqxEjzkBNDDta6w7i/4qGOp+XToJg4iuNlfJbTHgOkPWRpiJNAmq2/
aac+vgDO/gzDya8SSCdTIoNdMwoY1G4JKwwcQZ3i7YvLweEAp8w/q5RLovrC
7nK5w6HguWCMDqZJoVeGkbuePUHwSt/00gn/o0hy8GoyoS8QBAo0lltNjyH3
srygJycC4KZc2xFtkEbrSm9qA+L8Yff9ryIivwyymzn6uBgRQbmoSqJhVgal
7tZ08vH6QaY62e9L+3HESjUxtBp8CocNuX7JpMiiHcErYwbTPlBszahp+kQO
uRD9Ei23H8NNRvumEosTSIDoHjOk7QUS8e8bH8ueREPDnYdG3nuCUpXYsDS7
PHrRM8tlZOEBVzTHfFw+ySN4tv1m6vBDGPQ8EhtrrIAupHbejNtzg5pVNbsv
zQqIYcVdYmjsAagNsT6KkFZEjPpPq0ppruD64740KUERlWXIFKR8vw9nz/7p
qrKniE4QTSQ2Be6D9JD3eBhBCTkMj4ysGrrAGAdTr16vEqJpDFP6+O+BsbbY
sUg1ZRQhejPk9hsnMNILd1LNV0aFGdkG4xaOQOi/WPWKVwUlJsUPY386gPPt
Qw51nirIeLNcmJnRHlw6pqckZ1WQFTu5wnnGDkTdRWVl9VVRzL/XQjm/3QEt
9c+6PGWqaD+JlSGH8Q68+MIlaCKCR983ebT5BW0hfUHqA/jh0dpFBty6jg2s
jTLLMvjj0T/mBetO2jYgdn74WcszOp5U2EgDG3Bc0lPSDcKjlg/Ri6NqNqDK
/9jNKBKPjM9MtXw8bgPnBI3jCWl49JqmcGgBZwPj/3oaPa/Do4ggLknyIAGk
7u456r7Boxpnt2DjjwTIE/cLYG/Eo1G3o61zPQTQtvEoi6TgkeH69Rb+TgII
n1b/ntCGR0kZmu8eNRDg99QtVlI/Hl3D83XfzSLAI4u3jPaDeDTx1juQPZ0A
X/NkdmWH8ai2ZpCnJJkAwcIbs6Wf8ShlyTBnPYYA7ddIuTVTeHSDfyQlIpAA
EadEIh/N4NElw+szeH8C5NTHeGjQ8Gjvr9y9sacEILFFapHn8chAJO2lyiMC
GIfwSvkt4NHByWaFcXcCtHCnHdD+jkcJ9vmhYa4EENmUnWZawqNsHbZq9XsE
sI2nUFqX8UhIIr+U5kCA/wORuB2w
                "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
             "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.560181, 0.691569, 0.194885]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.560181, 0.691569, 0.194885]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.880722, 0.611041, 0.142051]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.368417, 0.506779, 0.709798]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>], 
        ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]], 
           Line[CompressedData["
1:eJwVlHk01H8Xx62VnVHqsSUig7IPUu4HUZJk+UnRviiGmMRQPMiSCCn0SzSy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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Line[CompressedData["
1:eJwVU3c01///NbN3iJAZ4pv9jpTHEyUrkZLKCnmbJSkj+mRXZnZKUeJtZJPZ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            "]]}, "Charting`Private`Tag#2"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Line[CompressedData["
1:eJwVVHk41HsXL5R9yHq5dBFFlH0it84XpcRblpJs6TYkWxKRKEZkJ/u+x1iy
ZBdmzE/WlEvWkt1IlH2J8s794zznOc/nPOd8zir+zz0jG4Z9+/Z10eU/7eWk
WX4wSoRy/6L9hagpZTDBNFB9BDel73Kiu6KbJ1hHCyWuBbBThn8yT02xBEG2
+uRypgYLZd807yxT7QtIVhN5HjB5gJKxYYs9V08AcxnGyXhOJorj1eCTxSGp
oON1vlYrjIHCynXmQ/BAJrhsZqlmnttP8eLwYJI2zIFg3nFJtWP7KMoXA7VX
ql5CbnG6n/jV32TtuQvb2QdIoH7mSkll2C555epA4yIqhAHeONaTrttksZjh
a3veJTDvmPzJjWeLHJFG6g2EMvimxVXB1rVB/vuBf2P2qXJoLdVHFp5r5DrZ
8Q2EqwDHG5x35exWyd/C2DGDxQpgtF84Km+7QiZMNhCjWirBVN6KYTpwiZyq
EX0806IaKF/0H2o+mid3aczsPlevg1TP0AqT8DHy2UvvfG5/bASDdlJjheoo
+fSte75mBk2wthx96PDiCPnemlVTXlsT/M3M11IaMECuUXUX7SWRwfNZxxXx
mHfkqtha3dRUCigEconhitrJ7jNpt/o6KDAkKlbsNdBC9tA2C1Ffp0DUj5wB
5/Z68i8JQ2KXTjPsi21Q/8fUA4aFJH09B5oBVXrSXN0zYYrh+U7aRjNQHlCd
oOMVUPZ9tTPlp4K1CQe0z7+B+ePRVTWXqZD4psqXKNkM1luPg+/fpQKLdwHT
xoUW0JNIODtPpMJcMHV/uFMnRLvha8++poLpy8MWXi7d8GTbeV2unQqSEFdJ
UumBqfjrbHuf6bilF4njrz64krST5cKIQa6E7pBJ+EfQSjz4QIwfg0rLlBL1
zX4wZWpu+CiFQVTm+6/Xm4ZgoXC1xO4cBk/2hoJx6iPgGxLo4WmMQW+KFFIv
/QQb6a6K/rcwGDlNnfglNgoeH0RMXjhjUFZ06IFvxBfI0o75o8gLA1cK5/mp
zTEoHmOyGwrAYMJVIiinZBxOuImtiEVh0HV2OtDm5gR8y7eQCkvCwOCt6HMd
3CSIxcsoi2djsCwV33b1zSQIcHPy0AowCAy8R0uznQJm28Kn02UYsOmZ/DjJ
PQ2LUdUMYjUYbKSymvHVTsNO2PBCRgMG3Wf0RMysZgBX5GNh34zBNx3tYnbG
WaiIDz8b8BaDf8/dZlHJm4WYt+IGG+0Y6LL2NY5eoIHuL1ExrAuD3SSX7zxz
NBiJJXMvd9PzvXUwGQ2cg3Iu0RsBHzCY+ivAUEfyK0gWJBwM6MHgiv/mmAnl
K4xZw+81uv0/T54iQfN5kOI5/nuYbtc/CmV9sTYPP4Wa0tX+83cKZewK+wZF
bMvG/PR4iZo+Jt1HFuDEjJezGz1fukq2Z0bdAljr/xYxo/PJpN1LvXh5ESLF
jjp10vnKcDZUfJhYhDuLtfod9HqW5OtcNdy+Q2hkdogZFYOvHW1G0Qd+gOqD
tUG/Jgz0sg7HjcT9gLr2z+1a9RioxORJhPMsAS9LXH9mFQbest1pRTeWYPeP
i+YZ9P4ePpMVqZe5BCr3l1I1izA49f1S5b3ZJXjocbIl5CUGVMJdwSv3l4Hh
zq8fovT51cq8vMVVvQytQ/I9TtEY+JUd2LL8uQzH1Kovu4Ri4FCVcKnUbwWU
9r/8luCNQYNVq1d1ywpUnJhTo7rR96vNd/wq8yqwdj3xL3Ck9//82JOboatw
bZgpqdacPv+6PanJiDWYeViQKHgKg5Jukbjh92sQNsEjd/cEBrgDn2U9cOtw
ySCXM/gIBsSLzVeLwtahLyAYr8GFwaRKXZdEwAZYMhU+SJ6mwrxReOvzO1sQ
2VDd8zKICqFp2xOk9C0gMnuEO/tQQRXD+0b0b0EZByOvuCsVDtYFdBVqbUOt
1ihcMKfC2VKiGgj/hHcxr6XK5aiw9YqaG0DegZN9p9NK39HvvbNjV4X2G6TT
haWXDjSDvSl5vvo2A5IJsN45tdAERGerZIEYZpRfqckTRKgDH+KrveskZqTa
9tR/7nIdtD3CJUY1MqPzZuEHrej/reqoYhGNxoxwhiqqQbg6kGcYuSz/Nwv6
0nvhzVBdLfyUcnysPMWCWNJqNgh8tVDSuG/VW5YNKV70zZkbqobX28SJnXwO
NLAlJ5ubWgnGXxVMFOo50I7tPQ/u8ErQ1Sv6efMdB8KjhTNhPpXANFa6VLbE
gZ7+UN0rt6qE66RvFsLqnMhf6HJdpXglcLOqWB/q4ESC7q5KIYUVsBwUdK5p
BofUrD8a4dpeQ0e7wUBxMDdSUI5sMpAuh9XR2Ilf0dwIZ4x0pf4sh0nt+8v6
qdxIp6PuPTOuHJ4Msx2fKeFGm68TAzdWy0BHSUrvdx83ihMm9ntSyoDDqyet
X/QQumw05MtgUQZp67+3ZcoOoU9s1zceqJcCXAoVm/3AgworSn0niMWQOaXy
LGuIB/15M4RpxbkYej8pBppP8CCZSgdTAfNiyJVPdeha4UFqcw7cycrF8Hyu
Zy6ZnxetvRSUCZ0pAjdyLctPM17U98wsdU+/CNjNW/DYNC+KNRD0iZUpBNsq
zPndGh8a8cU+j/ORwHNbP7xglw/FPGR0unCQBFqk/uYAJn5EDj+D1W/mQ4uD
tYsGHz86PfskuG0kHwoc3XZSlOn4htCWR1Y+NNy2C1Ry5UcBJ344SivmA4NJ
qNCb7/zIpZ4nweFGHgz/TxFHmBFA1y2+Xe/uzIUe/yrl14sCqDMvh8zQlAtX
0sg+e+sCaN43LVW7PBeSuCKJCQcFEYvjsh8tIRfsju63aTwmiFoT5SKrbXJh
JYSmNnFXENU/6Yq1ZcwFSyrz+YhFQZQQ61BXq5MDljvpYrkrf6DzgdnhRfNZ
cJLkxXLq5x+o6J9zzNwTWfAwO8+kY78QEtba4vQezIIfip3HFriFUH/6ao59
Sxb0V4oUHpcXQjOt3aJZ6Vkg8PVwbKiDEPr1JRxzvJoF2R1RHONTQsg8SfuR
/ttMeKcl7D3fK4zIlurWDu4ZsOhhW/A9SwSxJ6cciZtOAaOHvWwrUYcR99+9
qkoFiaCqxEjzkBNDDta6w7i/4qGOp+XToJg4iuNlfJbTHgOkPWRpiJNAmq2/
aac+vgDO/gzDya8SSCdTIoNdMwoY1G4JKwwcQZ3i7YvLweEAp8w/q5RLovrC
7nK5w6HguWCMDqZJoVeGkbuePUHwSt/00gn/o0hy8GoyoS8QBAo0lltNjyH3
srygJycC4KZc2xFtkEbrSm9qA+L8Yff9ryIivwyymzn6uBgRQbmoSqJhVgal
7tZ08vH6QaY62e9L+3HESjUxtBp8CocNuX7JpMiiHcErYwbTPlBszahp+kQO
uRD9Ei23H8NNRvumEosTSIDoHjOk7QUS8e8bH8ueREPDnYdG3nuCUpXYsDS7
PHrRM8tlZOEBVzTHfFw+ySN4tv1m6vBDGPQ8EhtrrIAupHbejNtzg5pVNbsv
zQqIYcVdYmjsAagNsT6KkFZEjPpPq0ppruD64740KUERlWXIFKR8vw9nz/7p
qrKniE4QTSQ2Be6D9JD3eBhBCTkMj4ysGrrAGAdTr16vEqJpDFP6+O+BsbbY
sUg1ZRQhejPk9hsnMNILd1LNV0aFGdkG4xaOQOi/WPWKVwUlJsUPY386gPPt
Qw51nirIeLNcmJnRHlw6pqckZ1WQFTu5wnnGDkTdRWVl9VVRzL/XQjm/3QEt
9c+6PGWqaD+JlSGH8Q68+MIlaCKCR983ebT5BW0hfUHqA/jh0dpFBty6jg2s
jTLLMvjj0T/mBetO2jYgdn74WcszOp5U2EgDG3Bc0lPSDcKjlg/Ri6NqNqDK
/9jNKBKPjM9MtXw8bgPnBI3jCWl49JqmcGgBZwPj/3oaPa/Do4ggLknyIAGk
7u456r7Boxpnt2DjjwTIE/cLYG/Eo1G3o61zPQTQtvEoi6TgkeH69Rb+TgII
n1b/ntCGR0kZmu8eNRDg99QtVlI/Hl3D83XfzSLAI4u3jPaDeDTx1juQPZ0A
X/NkdmWH8ai2ZpCnJJkAwcIbs6Wf8ShlyTBnPYYA7ddIuTVTeHSDfyQlIpAA
EadEIh/N4NElw+szeH8C5NTHeGjQ8Gjvr9y9sacEILFFapHn8chAJO2lyiMC
GIfwSvkt4NHByWaFcXcCtHCnHdD+jkcJ9vmhYa4EENmUnWZawqNsHbZq9XsE
sI2nUFqX8UhIIr+U5kCA/wORuB2w
            "]]}, "Charting`Private`Tag#3"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.560181, 0.691569, 0.194885]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> Identity, 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> 1, Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, 
    Method -> {
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None}, PlotRange -> {All, All}, PlotRangeClipping -> 
    True, PlotRangePadding -> {{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"L=2\"", "\"L=5\"", "\"L=20\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.560181, 0.691569, 0.194885]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.560181, 0.691569, 0.194885]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.963035269206131*^9, {3.963035390774174*^9, 3.9630354088221707`*^9}, {
   3.963039408413965*^9, 3.963039427072885*^9}},
 CellLabel->
  "Out[754]=",ExpressionUUID->"d3f7abf1-a4c5-724e-864a-7475db8e1489"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Asymptotic", "[", 
  RowBox[{
   RowBox[{"VRW", "[", 
    RowBox[{"r", ",", "L"}], "]"}], ",", 
   RowBox[{"L", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.96303533970072*^9, 3.9630353542763977`*^9}, {
  3.9630394382924213`*^9, 3.963039438837944*^9}},
 CellLabel->
  "In[755]:=",ExpressionUUID->"013de922-22d2-f54d-9b1e-864e945de037"],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["L", "2"], 
   SuperscriptBox["r", "2"]], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["L", "2"], " ", "rs"}], 
   SuperscriptBox["r", "3"]]}]], "Output",
 CellChangeTimes->{{3.963035345070732*^9, 3.963035354727333*^9}, 
   3.9630394394567013`*^9},
 CellLabel->
  "Out[755]=",ExpressionUUID->"c45d7bee-6e40-1646-b8ce-93d64662abf3"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Comparing  RW  and  Zerilli", "Section",
 CellChangeTimes->{{3.9630394577442074`*^9, 
  3.9630394631587944`*^9}},ExpressionUUID->"9deb4cb1-57f8-b141-814b-\
06f78324fe8f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VRW", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "2"}]}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "+", 
        RowBox[{"Log", "[", 
         RowBox[{"r", "-", "1"}], "]"}]}], ",", 
       RowBox[{"Evaluate", "[", 
        RowBox[{
         RowBox[{"VZZZ", "[", 
          RowBox[{"r", ",", "L"}], "]"}], "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"rs", "->", "1"}], ",", 
           RowBox[{"L", "->", "2"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}], ",", 
   RowBox[{"PlotLegends", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<L=2 RW\>\"", ",", "\"\<L=2 Zerilli\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.963039470067072*^9, 3.9630395479870815`*^9}, {
  3.9630396046510544`*^9, 3.9630396076748295`*^9}, {3.9630396518251896`*^9, 
  3.963039652917837*^9}},
 CellLabel->
  "In[762]:=",ExpressionUUID->"cdcb542b-7267-ae41-8662-4e2dbc158bdf"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[
    InterpretationBox[{
      TagBox[{{{}, {}, 
         TagBox[{
           RGBColor[0.368417, 0.506779, 0.709798], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwV1Hk4VO0bB3CUShRKlCxjn1CS8kpyP5Il/MhaWVokW1lelaLsZE/qNUW2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            "]]}, Annotation[#, "Charting`Private`Tag#1"]& ], 
         TagBox[{
           RGBColor[0.880722, 0.611041, 0.142051], 
           AbsoluteThickness[2], 
           Opacity[1.], 
           FaceForm[
            Opacity[0.3]], 
           LineBox[CompressedData["
1:eJwVlXk8lG0Xx21pZBsRJevYhixJSaJzKyS8hHjKLktI9JYWSqUePeoJIVMJ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            "]]}, Annotation[#, "Charting`Private`Tag#2"]& ]}, {}}, {
       "WolframDynamicHighlight", <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
      StyleBox[
       DynamicBox[
        (Charting`HighlightActionBox["DynamicHighlight", {}, 
         Slot["HighlightElements"], 
         Slot["LayoutOptions"], 
         Slot["Meta"], 
         Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]], 
               Line[CompressedData["
1:eJwV1Hk4VO0bB3CUShRKlCxjn1CS8kpyP5Il/MhaWVokW1lelaLsZE/qNUW2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                "]]}, "Charting`Private`Tag#1"], 
             Annotation[{
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Line[CompressedData["
1:eJwVlXk8lG0Xx21pZBsRJevYhixJSaJzKyS8hHjKLktI9JYWSqUePeoJIVMJ
kSxDiKSs99ilrEmyz9wylpGxh4b3fv+4Ptfn+znXcq7zO+dcimdD7H15uLi4
+vHx/zn96x/qqRh5mu4uksanEBMo4Zfn5YsTp+X31kgczogCv+tqQv5NRFpH
eEfUamgSBIbcD2qwEKFtjK4e7Zh5Cd5mOn/YS4K0lPjXx6dls8BVOMrOUm0b
rd9PcIyukwcPD+iTjrwh0HzZxctKWkXQ94A7GQvcSnPL2KrFJ1gCyhGF9+od
+Gm8/Bsql66UguxTIekx1y00ryy9yi29ZRBX9jXvym0+2r+C0+tMzXKYMPtx
J6WMl0Zf/H7AJLwSjp889Z+6DR5a1FnNVYOaapj/2vhWy5GHJgAxMsu/UdCQ
nKXQPnDTil5e87TdUQvz4eftV5O5aHm77NsyD9XDVLahl/ouLtqkT5iDhVkD
fBPad+Wn0SYa6J0fmm/dCKPaHoYVVznoXuX69nmbZnAipzWVua+hmgTDjDNK
n2HK8v5lvTerqP2nI/yfRL5A13YFXeBaRRf+Y98StvwFzMPFMiQrVtDH9108
ByraQWCbhcd0wBKaABE7k4W6wEmogJIwuoh2sYkjpNAu2GkWpcBxXkSf9u3l
3tLfBZrM0asmzgtoBc8N79n0bnDtsLoXFjGHLhKUPgrJ9IBBnpBR2EUW6q/r
U53wpRda02xy/nTR0YDE75n6hweAxYg1G9aho/FQZvI5YgDsCYV9Wx6PokHh
wRRtdAAUOqIOfiwYRtPPPS8JPTIInY/+EUlc/YGSi2b2ReoMgcyR0Cg9wy40
Pzup/MLIMAzyNnAd29uJ/jHum+UXGwGaerH0Sft29JOYAumdyQh4thX42Zm3
olXsbhmH9BF4JvzronlQHfrNatzgofoo0BxN1H8WpKA9dWnudS2jcKemd1Vo
4BHqaYXMz/ePAlfn2c9N/Hrom8b2jSYWvl5XfPfdlBfQbVK320OUDid91tlR
UaUQfjfb7spJOrx1rYgUG/wApjsG6pkedHhsd+A8UbMSKCuONoQQOnhyzpZd
GaQB8Qk16fQjOlz0FBWsMm2GQPXMQ3/V43Y9Ruu97y2wTzpt2KWTDgoKTc03
z7WCZbI4W2qIDoSXDSn6t9tAdUkjr2KJDj4+kh/jm7tAa+ZBY7MSA1QzRVGn
1O9gWlv6YOgyA24Fet7gmPeBnkDmt8M3GTCcuni0bLYP+DxGzfz/ZgClMEQ4
6Eg/bD3mf1L7CQOi1+jr5l2DMNmzvzCymAFGR4jiQ5eHoC/Oq8P7IwMUXrFv
vtwxDKnPKba7UAZYr4gpvHcagZt314e4vjCg/cLs43LmKMg/2t/ejTEgx1iI
PnSADotDeomek7j9X4vgzHt0OIuKejX9wu+ngJmUHANeMyXNZFYZ8LzsbX69
DQauExY8XEIYmPU694snYzBWdJDtSsRga8dcichPDD47y4lRJDDY3bP2hhA+
Bg03TgynyWBwLWbtvUb6T4iNrGZK7cFArjLXambiJ/SpxlV6a2MQVaefcVZ3
HOhu1BtxuhhI/2sIAbXjoGjw6Vb0QQziC+ud/hCYcEybkOpkiMHp5PtfzE4y
wUdCxJ3fGANL4t+mm0NMaAtLDhY6ioHWv4Tli8oTMJSYHuNtikGbYrRPSuAE
JLVc+5VqjkHas/xCpeUJkEw021JjiUHr1lyZyMOTwB9SfPu1NQa1GmFBL+5M
whddrCEEf7df0JVigW1TMNcsrlFmh0GR8mM5D5spkH+hyLfPAQPbybtuoQlT
cIYlI/vkFAbHs5+SLHunQHNzoX3QEQMWqixP3zUNumTPS0J/YZAVlspt6DYN
qw5T7kqnMdCbzrjimD4N2jdmpxTPYHAmWkR5PzYN+nxZ5wnOGAQcEXzXq8KC
vO2yB77jvHOPdJOxPwuGGiyTY11wf2ZVNgLyWMDx4J/RdsV1yYxbdWGxoDdQ
7NZHnP3PG52S0J6B4Q/SqXvcMBAqfpWTGDIDvu51z6JxVt/2/WH/2xnIzUyt
6cBZo/FZwuTcDHz+aujC7Y5Bt4q7Xe2+X0AUVKmQxZk3aeWk3KVfoDRWraeC
s5nosPHx4l8wWDfQsRPnmsHZF0bsXyDVy+r+jZ9X9nXnzIb2LERrRtxpxNlB
xrU49sIs3B85tPs2zqEfhvxY+bPgq7s4poJzWOv0g51Ts+Dz8rVcBe5/Td+9
VgEJNvgzLxCMcJ4KusY1u48NDO50ej7+/gPv7EhVdmygi1ZOCOBcbVsR+N+L
bEg2vuTihMfr4dN74qJxbCh7Xng1Ho+vEKXQMamADc70+KuVePyd14ID+L6w
wcAkjNKD66PfkcBIJczBtC+PwjdcP3vsZmmL6hycG3/5pwrXN3CUqDtkOgfD
2kdGnuD6n0hWXK+/MwcWEpFPduD5cUHKuoiSNgcxU749NbYYSDy9O+BQNQcF
Y52Lp/F8WtEb9YpdmQMtF708Tyu8HjrNZIV2zEM+eSO7/QQGOy4bil/ZNw++
LmsO2hYYqAaaBQpcmIeJceF/6vF8Xr7HrEPo85CT65hnied/S6WFo+zGPCRY
saKsDmNAdUl6MC69AISK+gQ4hIEbpekOnFoAg/3XlrgPYEBMzlQnNi1AtYlz
6SJej/5iZ22dGAvAfHplIVEdA99tmi4PNxaghHcdVVPDIP38zeoq/UVIaDyU
pUXCIEj2KGqTvQjnrxO4Pkjhelz4rUGoWwRvi3ThTbz+rSfFX70dWgSr7mzM
aDsGz1MGjTokluCqXEBEMt4/+OMf9ZrfXYI8ZxM3OhcG4iwEO+y8DOb3pIWr
mAyw+WvrC4NryyA3c8dKfYwBmg/mPio9WYbaoRH+mFG8PwX8U97YtgwWsZVx
Bj8YkKkV/t4IWQEP0UlB5VYGXIwbvSZB+g0Re4mqQXkMOLYQc8i8fxW+z3fp
ZvkyIPjuLTHbpVUw5P0WouyF9+elRDVL4hpQWArqaa4MOCTsf1nKfA0mup0u
RzowQIBmAGLFa7DMNJLZZsKA9FSnG5S/18FPxNvfYDcDlHqSKyNJHPg6zM9J
+0KHrKeTKVaGHPD3ukiababDN+gaErTnAHuwotYI/0/adGjlIZEccNsT/bqz
nA4RDryXmkY4UBG2FDKYTQeO/h6DquQNYB7MN4m7Q4cQY27a9i1cyLYxiWPv
9tFB56FFTrU/N8IyMJCXfDIKRTnX524BH+JhGCR/I3wYlqPtqpIG+JGv8qdO
/V4bAOOxibvsPQJI55/g/fZff8DG+vD450RB5OW5/F+OJd9hzc9UP6lGGNEx
4y6/PP4NalN/Z3xrF0W25w8OBNj0QMnNLMlXG0RkWEVUwB3tBhaVFmjKEUN2
ndbZxgzpAmShj0YTFEeUxEQuCZM7Ia0NZV0gSiC5gYKiKULtkBwtkV+xKYEM
V7Jk2aQvQM8Zmnm2uQPhyJkETiCtcEG0rsNxWhLR528Wnc1pAWlNh656phQy
xXQvPi3RDPOS9gP9gzuRGTEf/aL8RhgXKP98HN2FhOSsUO5fa4DmRPmi+BJp
5EVcqv+6aT1wB92f6k7cjSxz/47iGNdBho45uiVEBtGqfEypsK2FwfTTCMlF
FpEUyZLe9KTBpN6rbG59OSTs5o3oaRUUjnFhYTWK8oiRuKmfWXQ1xLzXqRnj
VUCeHs9UdSFWAYNBk3oerICo2YRf1WqtAGkTqRvldAXkqCqPdcmdcjCQ0Kl5
Y62IkOTVY5leH6Hk+O6fou8Vkc/7C7wfO38Aku+rlR8qJKR4oefdDtsyKHRb
+pEbS0KkLYOtTH3fwzFPG2bvJgnBiC31D6+VQs+PW7dJAUqIuovbTs2cd1Cp
YgVbOpUQgqZ1XPZ4CXRaGS4goIzwxVTMrCuWgHFEbkN1tjKSS+Ua3AgtBvvl
OL9HkipI/IMwP82Gt5BbBJOceyrIue2cEw8V3sKn6+5p7ZMqCO3++oq1QhEE
UwKbp/5SRTLcuJvHVgrA7DgFC61RRfZFJ2h+mnuD+7/6CCWpId8V3HKTOfkw
NSkbaRunhvy0mMkh8OQDwcI1w3tRDXH6qEHkVsqD4/HREarLaoil9/WqA/J5
oN+U6Di5ooZY8F46fH53HqxMnlgNXldDdKlX3/aJ58Fg2wnRcB4yYrpKvljN
lwev+I2vxhHJiG5doljhOBWUfooc+KBJRhjm84c18qlgGv53bJg2GSn5MPrp
eg4VftixscN7yciZTVGllkwqGGUX3KXpkZHMPSf0A1KoYDzVHffJkIx4kb7+
KI2hQt6lc5P9FmTk0Ngc478XqaDfSuFJtSQjAZwpgbYgKlAbm6U8rMmIQ1zs
b3IAFcTCdfUxWzIyeGJ+D+ZFBcbDg8emncgIlPwZ83SgAs/7f4wKTpORnpRd
x+psqVCnOKIb4kxGQjxlzylbU2E5Npu44EZGsmRWN6dM8f2LUmulHmQkabdX
qK0JFZz8E0euepERba7OglJjKiS/2FVr4I3ftyH8RtqQCvVIftqaDxkp88CC
I/Wp8D+GOLSm
                "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
          "HighlightElements" -> <|
            "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
           "LayoutOptions" -> <|
            "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
             "Frame" -> {{False, False}, {False, False}}, 
             "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
             "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
             "DefaultStyle" -> {
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.880722, 0.611041, 0.142051]], 
               Directive[
                Opacity[1.], 
                AbsoluteThickness[2], 
                FaceForm[
                 Opacity[0.3]], 
                RGBColor[0.368417, 0.506779, 0.709798]]}, 
             "HighlightLabelingFunctions" -> <|
              "CoordinatesToolOptions" -> Identity, 
               "ScalingFunctions" -> {{Identity, Identity}, {
                 Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
             False|>, 
           "Meta" -> <|
            "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, 
             "Function" -> ParametricPlot, "GroupHighlight" -> 
             False|>|>]]& )[<|
         "HighlightElements" -> <|
           "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
          "LayoutOptions" -> <|
           "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
            "Frame" -> {{False, False}, {False, False}}, 
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
            "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
            "DefaultStyle" -> {
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.880722, 0.611041, 0.142051]], 
              Directive[
               Opacity[1.], 
               AbsoluteThickness[2], 
               FaceForm[
                Opacity[0.3]], 
               RGBColor[0.368417, 0.506779, 0.709798]]}, 
            "HighlightLabelingFunctions" -> <|
             "CoordinatesToolOptions" -> Identity, 
              "ScalingFunctions" -> {{Identity, Identity}, {
                Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
            False|>, 
          "Meta" -> <|
           "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
            ParametricPlot, "GroupHighlight" -> False|>|>], 
        ImageSizeCache -> {{4.503599627370496*^15, -4.503599627370496*^15}, {
         4.503599627370496*^15, -4.503599627370496*^15}}], Selectable -> 
       False]}, 
     Annotation[{{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]], 
           Line[CompressedData["
1:eJwV1Hk4VO0bB3CUShRKlCxjn1CS8kpyP5Il/MhaWVokW1lelaLsZE/qNUW2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            "]]}, "Charting`Private`Tag#1"], 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Line[CompressedData["
1:eJwVlXk8lG0Xx21pZBsRJevYhixJSaJzKyS8hHjKLktI9JYWSqUePeoJIVMJ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            "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
      "HighlightElements" -> <|
        "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
       "LayoutOptions" -> <|
        "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
         "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
         "ImageSize" -> {360, 360}, "Axes" -> {True, True}, 
         "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.880722, 0.611041, 0.142051]], 
           Directive[
            Opacity[1.], 
            AbsoluteThickness[2], 
            FaceForm[
             Opacity[0.3]], 
            RGBColor[0.368417, 0.506779, 0.709798]]}, 
         "HighlightLabelingFunctions" -> <|
          "CoordinatesToolOptions" -> Identity, 
           "ScalingFunctions" -> {{Identity, Identity}, {
             Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>, 
       "Meta" -> <|
        "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
         ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]], 
    AspectRatio -> 1, Axes -> {True, True}, AxesLabel -> {None, None}, 
    AxesOrigin -> {0, 0}, DisplayFunction -> Identity, 
    FrameLabel -> {{None, None}, {None, None}}, 
    FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
    GridLinesStyle -> Directive[
      GrayLevel[0.5, 0.4]], ImagePadding -> All, 
    Method -> {
     "DefaultGraphicsInteraction" -> {
       "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
        "Effects" -> {
         "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
          "Droplines" -> {
           "freeformCursorMode" -> True, 
            "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
      "ScalingFunctions" -> None}, PlotRange -> {All, All}, PlotRangeClipping -> 
    True, PlotRangePadding -> {{
       Scaled[0.05], 
       Scaled[0.05]}, {
       Scaled[0.05], 
       Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"L=2 RW\"", "\"L=2 Zerilli\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.368417, 0.506779, 0.709798]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {
                    LineBox[{{0, 12.5}, {20, 12.5}}]}}, {
                    Directive[
                    PointSize[0.5], 
                    EdgeForm[None], 
                    Opacity[1.], 
                    AbsoluteThickness[2], 
                    FaceForm[
                    Opacity[0.3]], 
                    RGBColor[0.880722, 0.611041, 0.142051]], {}}}, 
                    AspectRatio -> Full, ImageSize -> {20, 12.5}, 
                    PlotRangePadding -> None, ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.18000000000000002`] -> 
                    Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   
                   TemplateBox[<|
                    "color" -> RGBColor[0.368417, 0.506779, 0.709798]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"EdgeForm", "[", "None", "]"}], ",", 
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
                   RowBox[{"FaceForm", "[", 
                    RowBox[{"Opacity", "[", "0.3`", "]"}], "]"}], ",", 
                   TemplateBox[<|
                    "color" -> RGBColor[0.880722, 0.611041, 0.142051]|>, 
                    "RGBColorSwatchTemplate"]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.963039513770312*^9, 3.963039548954874*^9}, 
   3.96303960836694*^9, 3.963039653807387*^9},
 CellLabel->
  "Out[762]=",ExpressionUUID->"5ccdf733-b6b1-904d-8c55-d5254b5c0314"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"VRW", "[", 
     RowBox[{"r", ",", "L"}], "]"}], "-", 
    RowBox[{"VZZZ", "[", 
     RowBox[{"r", ",", "L"}], "]"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"rs", "->", "1"}], ",", 
     RowBox[{"L", "->", "2"}]}], "}"}]}], "//", 
  "FullSimplify"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", "+", 
      RowBox[{"Log", "[", 
       RowBox[{"r", "-", "1"}], "]"}]}], ",", "%"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "1", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.963039682097357*^9, 3.9630397544797173`*^9}},
 CellLabel->
  "In[765]:=",ExpressionUUID->"c8a28563-6f51-0a49-807b-ad9e9d0552c5"],

Cell[BoxData[
 FractionBox[
  RowBox[{"6", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "r"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "6"}], "+", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "9"}], "+", 
        RowBox[{"8", " ", "r"}]}], ")"}]}]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["r", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "r"}]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.963039689201145*^9, 3.9630396930107193`*^9}, 
   3.96303975664694*^9},
 CellLabel->
  "Out[765]=",ExpressionUUID->"1ba53010-157b-5c4f-a8c7-c9cfd67c1ef0"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[2], 
         Opacity[1.], FaceForm[Opacity[0.3]], LineBox[CompressedData["
1:eJwVlXk41G8Xxgczg8ieJLIzkoQI0XlIaBORnxZCskVESrJEhELKznwHlTCl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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.368417, 0.506779, 0.709798]], 
             Line[CompressedData["
1:eJwVlXk41G8Xxgczg8ieJLIzkoQI0XlIaBORnxZCskVESrJEhELKznwHlTCl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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 1, 
           "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              FaceForm[
               Opacity[0.3]], 
              RGBColor[0.368417, 0.506779, 0.709798]]}, 
           "HighlightLabelingFunctions" -> <|
            "CoordinatesToolOptions" -> Identity, 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           ParametricPlot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {360, 360}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> 1, "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             FaceForm[
              Opacity[0.3]], 
             RGBColor[0.368417, 0.506779, 0.709798]]}, 
          "HighlightLabelingFunctions" -> <|
           "CoordinatesToolOptions" -> Identity, 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          ParametricPlot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          RGBColor[0.368417, 0.506779, 0.709798]], 
         Line[CompressedData["
1:eJwVlXk41G8Xxgczg8ieJLIzkoQI0XlIaBORnxZCskVESrJEhELKznwHlTCl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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360}, "Axes" -> {True, True}, "LabelStyle" -> {}, 
       "AspectRatio" -> 1, "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          FaceForm[
           Opacity[0.3]], 
          RGBColor[0.368417, 0.506779, 0.709798]]}, 
       "HighlightLabelingFunctions" -> <|
        "CoordinatesToolOptions" -> Identity, 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       ParametricPlot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "ScalingFunctions" -> 
    None},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.05], 
     Scaled[0.05]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.963039689201145*^9, 3.9630396930107193`*^9}, 
   3.963039756704687*^9},
 CellLabel->
  "Out[766]=",ExpressionUUID->"bfa58bfc-922c-ac49-80d3-118698bf99dd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Equation  for  H0[r]  at  finite  frequency - a mess...", "Section",
 CellChangeTimes->{{3.962965675149938*^9, 3.962965686054434*^9}, 
   3.962965719984701*^9, {3.963292952675619*^9, 
   3.963292957432085*^9}},ExpressionUUID->"dcaeb59b-58c8-374a-9763-\
b772e6179935"],

Cell["Solving the system:", "Text",
 CellChangeTimes->{{3.962952921374483*^9, 3.9629529459639244`*^9}, {
  3.9629530474312935`*^9, 
  3.962953052980921*^9}},ExpressionUUID->"f4496d5c-547d-ad43-9226-\
209c55d67f5c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"solving", "  ", "for", "  ", "H1", "  ", "from", "  ", 
    RowBox[{"eqtr", ":"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"solveH1", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"eqtr", "==", "0"}], ",", 
         RowBox[{"H1", "[", "r", "]"}]}], "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
     "simplin"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"eqs", "//.", "solveH1"}], "//.", 
       RowBox[{"D", "[", 
        RowBox[{"solveH1", ",", "r"}], "]"}]}], "//", "FullSimplify"}], "//", 
     "simplin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"solving", "  ", "for", "  ", 
     RowBox[{"k", "'"}], "  ", "from", "  ", "last", " ", 
     RowBox[{"eq", ":"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"%%", "[", 
          RowBox[{"[", 
           RowBox[{"-", "1"}], "]"}], "]"}], "==", "0"}], ",", 
        RowBox[{
         RowBox[{"k", "'"}], "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
    "simplin"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"%%%", "/.", 
        RowBox[{"D", "[", 
         RowBox[{"%", ",", "r"}], "]"}]}], "/.", "%"}], "//", 
      "FullSimplify"}], "//", "simplin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"solving", " ", "for", " ", 
     RowBox[{"k", ":"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"%%", "[", 
          RowBox[{"[", "3", "]"}], "]"}], "==", "0"}], ",", 
        RowBox[{"k", "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
    "simplin"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"%%%", "/.", "%"}], "//", "FullSimplify"}], "//", "simplin"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"%", "//", "MatrixForm"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "final", " ", "eq", " ", "for", " ", "H0", " ", "and", " ", "consistency",
      " ", 
     RowBox[{"check", ":"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"%%", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "==", "0"}], ",", 
        RowBox[{
         RowBox[{"H0", "''"}], "[", "r", "]"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
    "simplin"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"%%%", "/.", "%"}], "//", "FullSimplify"}], "//", "simplin"}], 
   "\[IndentingNewLine]", 
   RowBox[{"eqH0", " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"%%%%", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "//", "FullSimplify"}], "//", 
     "simplin"}]}]}]}]], "Input",
 CellChangeTimes->{{3.962952951084612*^9, 3.9629530157199707`*^9}, {
  3.9629530574259224`*^9, 3.9629531439165497`*^9}, {3.9629629141589622`*^9, 
  3.9629629186737156`*^9}, {3.962963295931183*^9, 3.962963378489794*^9}, {
  3.9629641960399876`*^9, 3.9629642814157124`*^9}, {3.96296435006728*^9, 
  3.962964354615309*^9}, {3.962964448670822*^9, 3.962964467868393*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"f7b2aba0-ec09-6a4b-ba72-2fbb26f151ed"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"H1", "[", "r", "]"}], "\[Rule]", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "r", " ", "\[Omega]", " ", 
      RowBox[{"H0", "[", "r", "]"}]}], 
     RowBox[{"L", "+", 
      SuperscriptBox["L", "2"]}]], "-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "-", 
        RowBox[{"3", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
      RowBox[{"k", "[", "r", "]"}]}], 
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}]}]], "-", 
    FractionBox[
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SuperscriptBox["r", "2"], " ", "\[Omega]", " ", 
      RowBox[{
       SuperscriptBox["k", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], 
     RowBox[{"L", "+", 
      SuperscriptBox["L", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.9629644686436405`*^9},
 CellLabel->
  "Out[164]=",ExpressionUUID->"bd580adf-8a1b-6f4a-b22f-2aa564dca196"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}]}], 
            RowBox[{"r", "-", "rs"}]], "+", 
           FractionBox[
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"12", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "-", 
               RowBox[{"10", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"]}]]}], ")"}], " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "6"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "13"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "-", 
            RowBox[{"15", " ", 
             SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "3"]}]], "-", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"L", "+", 
            SuperscriptBox["L", "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
            RowBox[{"20", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["k", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}]}]], "-", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["H0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "-", 
        FractionBox[
         RowBox[{"8", " ", 
          SuperscriptBox["r", "4"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{
           SuperscriptBox["k", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}]}]]}]},
      {"0"},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox[
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}]}], 
            RowBox[{"r", "-", "rs"}]], "-", 
           FractionBox[
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "-", 
               RowBox[{"2", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"]}]]}], ")"}], " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"6", " ", "r", " ", "rs"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "3"]}]], "+", 
        FractionBox[
         RowBox[{"4", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"L", "+", 
            SuperscriptBox["L", "2"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "r"}], "-", 
               RowBox[{"3", " ", "rs"}]}], ")"}]}], "+", 
            RowBox[{"24", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["k", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}]}]], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["H0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "r"}], "+", 
           FractionBox[
            RowBox[{"8", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}]]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["k", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", "-", 
           FractionBox[
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"L", "+", 
             SuperscriptBox["L", "2"]}]]}], ")"}], " ", 
         RowBox[{"H0", "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "2"}], "+", "L", "+", 
           SuperscriptBox["L", "2"], "-", 
           FractionBox[
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "4"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r"}], "+", 
               RowBox[{"6", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}]]}], ")"}], " ", 
         RowBox[{"k", "[", "r", "]"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["H0", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "4"}], " ", "r"}], "+", 
           RowBox[{"3", " ", "rs"}], "+", 
           FractionBox[
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"L", "+", 
             SuperscriptBox["L", "2"]}]]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["k", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["k", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{"2", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{"2", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "6"}], " ", "r"}], "+", 
            RowBox[{"5", " ", "rs"}]}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["k", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"2", " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["k", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}]}]]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", 
            RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"]}]], "+", 
        RowBox[{
         SuperscriptBox["H0", "\[Prime]",
          MultilineFunction->None], "[", "r", "]"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           FractionBox[
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}], 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}]]}], ")"}], " ", 
         RowBox[{
          SuperscriptBox["k", "\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.9629644688498936`*^9},
 CellLabel->
  "Out[166]//MatrixForm=",ExpressionUUID->"dcb2607c-d0b5-dc4a-8b22-\
eccf171b45be"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["k", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}], "\[Rule]", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", "rs"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
      RowBox[{"H0", "[", "r", "]"}]}], 
     RowBox[{
      RowBox[{"L", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "4"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "r"}], "+", 
        RowBox[{"3", " ", "rs"}]}], ")"}], " ", 
      SuperscriptBox["\[Omega]", "2"], " ", 
      RowBox[{"k", "[", "r", "]"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "L"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]], "+", 
    FractionBox[
     RowBox[{"L", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "L"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], 
     RowBox[{
      RowBox[{"L", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.9629644688498936`*^9},
 CellLabel->
  "Out[167]=",ExpressionUUID->"ab268df2-b4ae-ef45-a0a9-231288dc9c32"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["L", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "+", 
               SuperscriptBox["rs", "2"]}], ")"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "4"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "3"}], "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"4", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "-", 
               RowBox[{"26", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "6"], " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "3"}], " ", "r"}], "+", 
               RowBox[{"4", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "4"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "10"], " ", 
             SuperscriptBox["\[Omega]", "6"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{"r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "6"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "14"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "7"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["L", "2"]}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r"}], "-", "rs"}], ")"}]}], "-", 
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "r"}], "-", 
               RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"12", " ", 
             SuperscriptBox["r", "6"], " ", "rs", " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "L"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "L"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "3"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}]]}]},
      {"0"},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", 
                 SuperscriptBox["r", "2"]}], "-", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "+", 
                SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["r", "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"8", "-", 
                   RowBox[{"3", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                 SuperscriptBox["r", "2"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "28"}], "+", 
                   RowBox[{"3", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                 "rs"}], "+", 
                RowBox[{"22", " ", 
                 SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
              SuperscriptBox["\[Omega]", "2"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "7"], " ", 
              SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
           RowBox[{"H0", "[", "r", "]"}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "L"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "4"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]]}], "+", 
        FractionBox[
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "r"}], "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
          SuperscriptBox["\[Omega]", "2"], " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"3", " ", "r", " ", "rs"}], "+", 
               SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r"}], "-", 
               RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]], "-", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{
          SuperscriptBox["H0", "\[Prime]\[Prime]",
           MultilineFunction->None], "[", "r", "]"}]}]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["L", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", "r", " ", "rs"}], "-", 
               RowBox[{"7", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "r"}], "-", 
               RowBox[{"7", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{"r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "-", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["L", "2"]}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", 
                  RowBox[{"5", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"6", "+", 
                  RowBox[{"5", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                "rs"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["r", "5"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "8"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"8", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "4"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "9"], " ", 
             SuperscriptBox["\[Omega]", "6"]}]}], ")"}], " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"r", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["L", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{"7", " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "2"], " ", "rs", " ", 
             SuperscriptBox["\[Omega]", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "5"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]], "-", 
        FractionBox[
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{"L", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "L"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "3"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}]]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "17"}], "+", 
                  RowBox[{"2", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                "rs"}], "+", 
               RowBox[{"15", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "7"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{"2", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "-", 
               RowBox[{"27", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "6"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{"k", "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "r"}], "+", "rs"}], ")"}], " ", "\[Omega]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"5", " ", "r", " ", "rs"}], "+", 
               SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", 
               RowBox[{"4", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", "\[Omega]", " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          RowBox[{
           RowBox[{"-", "L"}], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "L"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "3"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}]]}]},
      {"0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.962964469658497*^9},
 CellLabel->
  "Out[169]//MatrixForm=",ExpressionUUID->"6e3199ee-c4ba-5a4d-817a-\
7f142401d664"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"k", "[", "r", "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "-", 
          RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"L", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "L"}], ")"}], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"L", " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "+", 
           SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"8", "-", 
              RowBox[{"3", " ", "L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "28"}], "+", 
              RowBox[{"3", " ", "L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
            "rs"}], "+", 
           RowBox[{"22", " ", 
            SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
         SuperscriptBox["\[Omega]", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "7"], " ", 
         SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
      RowBox[{"H0", "[", "r", "]"}]}]}], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"L", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"3", " ", "r", " ", "rs"}], "+", 
           SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "r"}], "-", 
           RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], 
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "-", 
         RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
      SuperscriptBox["\[Omega]", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "L"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "L"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["r", "3"], " ", 
         SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["H0", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "r", "]"}]}], 
     RowBox[{"2", " ", "r", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "r"}], "-", 
         RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
      SuperscriptBox["\[Omega]", "2"]}]]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.9629644699422417`*^9},
 CellLabel->
  "Out[170]=",ExpressionUUID->"0ac5ae97-8e32-a94a-9394-37d213a164be"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", 
             SuperscriptBox["L", "5"], " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "-", 
            RowBox[{
             SuperscriptBox["L", "6"], " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8", " ", 
                SuperscriptBox["r", "3"]}], "-", 
               RowBox[{"44", " ", 
                SuperscriptBox["r", "2"], " ", "rs"}], "+", 
               RowBox[{"64", " ", "r", " ", 
                SuperscriptBox["rs", "2"]}], "-", 
               RowBox[{"27", " ", 
                SuperscriptBox["rs", "3"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["r", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"24", " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"72", " ", "r", " ", "rs"}], "+", 
               RowBox[{"53", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "4"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "10"], " ", 
             SuperscriptBox["\[Omega]", "6"]}], "+", 
            RowBox[{
             SuperscriptBox["L", "4"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"r", " ", "rs"}], "-", 
               SuperscriptBox["rs", "2"], "+", 
               RowBox[{"5", " ", 
                SuperscriptBox["r", "4"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["L", "3"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"3", " ", "r", " ", "rs"}], "-", 
               RowBox[{"2", " ", 
                SuperscriptBox["rs", "2"]}], "+", 
               RowBox[{"10", " ", 
                SuperscriptBox["r", "4"], " ", 
                SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "-", 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["rs", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "r"}], "+", "rs"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["r", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"10", " ", 
                   SuperscriptBox["r", "2"]}], "-", 
                  RowBox[{"22", " ", "r", " ", "rs"}], "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                SuperscriptBox["\[Omega]", "2"]}], "+", 
               RowBox[{"8", " ", 
                SuperscriptBox["r", "7"], " ", 
                SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["L", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["r", "3"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "2"], " ", "rs"}], "-", 
               RowBox[{"3", " ", "r", " ", 
                SuperscriptBox["rs", "2"]}], "+", 
               SuperscriptBox["rs", "3"], "+", 
               RowBox[{
                SuperscriptBox["r", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}], "-", 
                  RowBox[{"17", " ", "r", " ", "rs"}], "+", 
                  RowBox[{"11", " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                SuperscriptBox["\[Omega]", "2"]}], "+", 
               RowBox[{"8", " ", 
                SuperscriptBox["r", "7"], " ", 
                SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "r"}], "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r"}], "-", "rs"}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"8", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "7"}], "+", 
                  RowBox[{"4", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                "rs"}], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["r", "7"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r"}], "+", 
               RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "r"}], "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "4"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "4"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["r", "8"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "r"}], "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}]]}]},
      {"0"},
      {"0"},
      {
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"2", " ", 
              SuperscriptBox["L", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "r"], "-", 
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", "r", " ", "rs"}], "-", 
               RowBox[{"7", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "5"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "r"}], "-", 
               RowBox[{"7", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "4"]}], "-", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"r", "-", "rs"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                   RowBox[{"L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", "rs"}], 
                   "+", 
                   SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
                RowBox[{
                 SuperscriptBox["r", "3"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"8", "-", 
                    RowBox[{"3", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "28"}], "+", 
                    RowBox[{"3", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                    "rs"}], "+", 
                   RowBox[{"22", " ", 
                    SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "2"]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["r", "7"], " ", 
                 SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["L", "2"]}], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"r", "-", "rs"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"5", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"6", "+", 
                    RowBox[{"5", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                    "rs"}], "+", 
                   RowBox[{"9", " ", 
                    SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["r", "5"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "8"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                   RowBox[{"8", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                   "+", 
                   RowBox[{"9", " ", 
                    SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "4"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "9"], " ", 
                 SuperscriptBox["\[Omega]", "6"]}]}], ")"}]}], 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "r"}], "-", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], " ", 
              SuperscriptBox["\[Omega]", "2"]}]]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["L", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
               RowBox[{"7", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                SuperscriptBox["r", "2"], " ", "rs", " ", 
                SuperscriptBox["\[Omega]", "2"]}], "-", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "5"], " ", 
                SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], "+", 
            FractionBox[
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                   RowBox[{"3", " ", "r", " ", "rs"}], "+", 
                   SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["r", "3"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "r"}], "-", 
                   RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "2"]}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["L", "2"]}], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"1", "+", "L"}], ")"}], "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "2"}], "+", "L", "+", 
                   SuperscriptBox["L", "2"]}], ")"}], " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
                RowBox[{"L", " ", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", "L"}], ")"}], " ", 
                 SuperscriptBox["r", "2"], " ", 
                 RowBox[{"(", 
                  RowBox[{"r", "-", "rs"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", 
                    RowBox[{"5", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"6", "+", 
                    RowBox[{"5", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                    "rs"}], "+", 
                   RowBox[{"9", " ", 
                    SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "2"]}], "+", 
                RowBox[{
                 SuperscriptBox["r", "5"], " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "8"}], " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                   RowBox[{"8", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                   "+", 
                   RowBox[{"9", " ", 
                    SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                 SuperscriptBox["\[Omega]", "4"]}], "+", 
                RowBox[{"4", " ", 
                 SuperscriptBox["r", "9"], " ", 
                 SuperscriptBox["\[Omega]", "6"]}]}], ")"}]}], 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "2"], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "r"}], "-", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]], "+", 
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "8"}], "+", 
                   RowBox[{"6", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                 SuperscriptBox["r", "2"]}], "-", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "8"}], "+", 
                   RowBox[{"3", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                 "rs"}], "-", 
                RowBox[{"9", " ", 
                 SuperscriptBox["rs", "2"]}]}], ")"}]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "r"}], "-", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"]], "-", 
            FractionBox[
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", "L"}], ")"}], " ", 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"r", "-", "rs"}], ")"}], "2"]}], 
             RowBox[{
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "r"}], "-", 
                 RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]], "-", 
            FractionBox[
             RowBox[{"4", " ", 
              SuperscriptBox["r", "6"], " ", 
              SuperscriptBox["\[Omega]", "2"]}], 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "r"}], "-", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"]], "-", 
            FractionBox[
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], 
             RowBox[{
              RowBox[{"L", " ", 
               RowBox[{"(", 
                RowBox[{"1", "+", "L"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "3"], " ", 
               SuperscriptBox["\[Omega]", "2"]}]}]]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"4", " ", "r"}]]}]},
      {
       RowBox[{
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"2", "+", "L"}], ")"}], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["r", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "4"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"2", "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                   SuperscriptBox["r", "2"]}], "+", 
                  RowBox[{"4", " ", 
                   RowBox[{"(", 
                    RowBox[{"8", "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                  "-", 
                  RowBox[{"27", " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                SuperscriptBox["\[Omega]", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "6"], " ", 
                SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}], " ", 
                   SuperscriptBox["r", "2"]}], "-", 
                  RowBox[{"L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", "rs"}], 
                  "+", 
                  SuperscriptBox["rs", "2"]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["r", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"8", "-", 
                    RowBox[{"3", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", 
                   SuperscriptBox["r", "2"]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "28"}], "+", 
                    RowBox[{"3", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                   "rs"}], "+", 
                  RowBox[{"22", " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                SuperscriptBox["\[Omega]", "2"]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "7"], " ", 
                SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "r"}], "-", 
                RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
             SuperscriptBox["\[Omega]", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"r", "-", "rs"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"2", "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                   SuperscriptBox["r", "2"]}], "-", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"4", "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
                  "+", 
                  RowBox[{"3", " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}]}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "2"}], " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "2"}], "+", "L", "+", 
                    SuperscriptBox["L", "2"]}], ")"}], " ", 
                   SuperscriptBox["r", "2"]}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "17"}], "+", 
                    RowBox[{"2", " ", "L", " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                   "rs"}], "+", 
                  RowBox[{"15", " ", 
                   SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
                SuperscriptBox["\[Omega]", "2"]}], "+", 
               RowBox[{"4", " ", 
                SuperscriptBox["r", "7"], " ", 
                SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"H0", "[", "r", "]"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "r"}], "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", "\[Omega]", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["r", "3"], " ", 
              SuperscriptBox["\[Omega]", "2"]}]}], ")"}], "2"]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r"}], "-", "rs"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", "rs", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "8"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "7"}], "+", 
                  RowBox[{"4", " ", "L", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
                "rs"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "6"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", "r"}], "+", 
               RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "r"}], "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"], " ", 
             SuperscriptBox["\[Omega]", "3"]}]}], ")"}]}]], "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"2", "+", "L"}], ")"}], " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
            RowBox[{
             SuperscriptBox["r", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "4"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "2"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}], "+", 
               RowBox[{"4", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "4"}], "+", "L", "+", 
                  SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], 
               "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "6"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
          RowBox[{
           SuperscriptBox["H0", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "r", "]"}]}], 
         RowBox[{"4", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "r"}], "-", 
             RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "L"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"r", "-", "rs"}], ")"}], " ", "\[Omega]"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "3"]}]}], ")"}]}]]}]},
      {"0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.962964472254181*^9},
 CellLabel->
  "Out[172]//MatrixForm=",ExpressionUUID->"6207e5bb-3ae8-5c4a-81c7-\
e9f315e4aa58"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["H0", "\[Prime]\[Prime]",
     MultilineFunction->None], "[", "r", "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["L", "5"], " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
         RowBox[{
          SuperscriptBox["L", "6"], " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", "rs", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "8"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"44", " ", 
             SuperscriptBox["r", "2"], " ", "rs"}], "-", 
            RowBox[{"64", " ", "r", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"27", " ", 
             SuperscriptBox["rs", "3"]}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["r", "6"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "24"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"72", " ", "r", " ", "rs"}], "-", 
            RowBox[{"53", " ", 
             SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "10"], " ", 
          SuperscriptBox["\[Omega]", "6"]}], "-", 
         RowBox[{
          SuperscriptBox["L", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"r", " ", "rs"}], "-", 
            SuperscriptBox["rs", "2"], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["L", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "r", " ", "rs"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["r", "4"], " ", 
             SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
         RowBox[{"L", " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["rs", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "r"}], "+", "rs"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"10", " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"22", " ", "r", " ", "rs"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["r", "7"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["L", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"r", "-", "rs"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"], " ", "rs"}], "-", 
            RowBox[{"3", " ", "r", " ", 
             SuperscriptBox["rs", "2"]}], "+", 
            SuperscriptBox["rs", "3"], "+", 
            RowBox[{
             SuperscriptBox["r", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", 
                SuperscriptBox["r", "2"]}], "-", 
               RowBox[{"17", " ", "r", " ", "rs"}], "+", 
               RowBox[{"11", " ", 
                SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
             SuperscriptBox["\[Omega]", "2"]}], "+", 
            RowBox[{"8", " ", 
             SuperscriptBox["r", "7"], " ", 
             SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"H0", "[", "r", "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "L"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["r", "6"], " ", 
          SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "L"}], ")"}], " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "r"}], "-", "rs"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "3"], " ", "rs", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "7"}], "+", 
               RowBox[{"4", " ", "L", " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
             "rs"}], "-", 
            RowBox[{"9", " ", 
             SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["r", "7"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "r"}], "+", 
            RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["H0", "\[Prime]",
         MultilineFunction->None], "[", "r", "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "L"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "L"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "2"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "4"}], "+", "L", "+", 
               SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
          SuperscriptBox["\[Omega]", "2"]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["r", "8"], " ", 
          SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.962964472491335*^9},
 CellLabel->
  "Out[173]=",ExpressionUUID->"e5da84b8-f105-3449-8ec0-8d733f72e34e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.9629644725218735`*^9},
 CellLabel->
  "Out[174]=",ExpressionUUID->"bec1ff90-0777-2349-b007-c2c84542c120"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["L", "5"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "-", 
       RowBox[{
        SuperscriptBox["L", "6"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", "rs", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"44", " ", 
           SuperscriptBox["r", "2"], " ", "rs"}], "+", 
          RowBox[{"64", " ", "r", " ", 
           SuperscriptBox["rs", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["rs", "3"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["r", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"24", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"72", " ", "r", " ", "rs"}], "+", 
          RowBox[{"53", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "4"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "10"], " ", 
        SuperscriptBox["\[Omega]", "6"]}], "+", 
       RowBox[{
        SuperscriptBox["L", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"r", " ", "rs"}], "-", 
          SuperscriptBox["rs", "2"], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["L", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"3", " ", "r", " ", "rs"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["rs", "2"]}], "+", 
          RowBox[{"10", " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "-", 
       RowBox[{"L", " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["rs", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "r"}], "+", "rs"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["r", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"10", " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"22", " ", "r", " ", "rs"}], "+", 
             RowBox[{"11", " ", 
              SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
           SuperscriptBox["\[Omega]", "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["r", "7"], " ", 
           SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["L", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["r", "2"], " ", "rs"}], "-", 
          RowBox[{"3", " ", "r", " ", 
           SuperscriptBox["rs", "2"]}], "+", 
          SuperscriptBox["rs", "3"], "+", 
          RowBox[{
           SuperscriptBox["r", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"17", " ", "r", " ", "rs"}], "+", 
             RowBox[{"11", " ", 
              SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
           SuperscriptBox["\[Omega]", "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["r", "7"], " ", 
           SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"H0", "[", "r", "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "-", 
        RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "L"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"], " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "L"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "-", "rs"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", "rs", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "7"}], "+", 
             RowBox[{"4", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
           "rs"}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "r"}], "+", 
          RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H0", "\[Prime]",
       MultilineFunction->None], "[", "r", "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "-", 
        RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "L"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"], " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", " ", 
     SuperscriptBox["r", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "L"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "6"], " ", 
        SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H0", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "r", "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "r"}], "-", 
        RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "L"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["r", "3"], " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.962952971028681*^9, 3.9629530162838974`*^9, 3.962953097087538*^9, {
   3.9629531309962006`*^9, 3.962953144560911*^9}, {3.9629633640383015`*^9, 
   3.962963379206049*^9}, 3.962964285914013*^9, 3.9629644738517475`*^9},
 CellLabel->
  "Out[175]=",ExpressionUUID->"45c24bc7-4a6f-2941-b602-16aeddabc5be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   FractionBox["eqH0", 
    RowBox[{"Coefficient", "[", 
     RowBox[{"eqH0", ",", 
      RowBox[{
       RowBox[{"H0", "''"}], "[", "r", "]"}]}], "]"}]], "//", 
   "FullSimplify"}], "//", "simplin"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", "->", "0"}], "}"}]}], "//", "FullSimplify"}], "//", 
  "simplin"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"%", "==", "0"}], ",", 
    RowBox[{"H0", "[", "r", "]"}], ",", "r"}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9629644972635784`*^9, 3.9629646479249516`*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"9a1ca0c8-eb51-9e49-ace9-b4f503be9b29"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["L", "5"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "-", 
       RowBox[{
        SuperscriptBox["L", "6"], " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "3"]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", "rs", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"8", " ", 
           SuperscriptBox["r", "3"]}], "-", 
          RowBox[{"44", " ", 
           SuperscriptBox["r", "2"], " ", "rs"}], "+", 
          RowBox[{"64", " ", "r", " ", 
           SuperscriptBox["rs", "2"]}], "-", 
          RowBox[{"27", " ", 
           SuperscriptBox["rs", "3"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{
        SuperscriptBox["r", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"24", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"72", " ", "r", " ", "rs"}], "+", 
          RowBox[{"53", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "4"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "10"], " ", 
        SuperscriptBox["\[Omega]", "6"]}], "+", 
       RowBox[{
        SuperscriptBox["L", "4"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"r", " ", "rs"}], "-", 
          SuperscriptBox["rs", "2"], "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["L", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["r", "2"]}], "-", 
          RowBox[{"3", " ", "r", " ", "rs"}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["rs", "2"]}], "+", 
          RowBox[{"10", " ", 
           SuperscriptBox["r", "4"], " ", 
           SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], "-", 
       RowBox[{"L", " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["rs", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "r"}], "+", "rs"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["r", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"10", " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"22", " ", "r", " ", "rs"}], "+", 
             RowBox[{"11", " ", 
              SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
           SuperscriptBox["\[Omega]", "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["r", "7"], " ", 
           SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], "-", 
       RowBox[{
        SuperscriptBox["L", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["r", "3"]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["r", "2"], " ", "rs"}], "-", 
          RowBox[{"3", " ", "r", " ", 
           SuperscriptBox["rs", "2"]}], "+", 
          SuperscriptBox["rs", "3"], "+", 
          RowBox[{
           SuperscriptBox["r", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"5", " ", 
              SuperscriptBox["r", "2"]}], "-", 
             RowBox[{"17", " ", "r", " ", "rs"}], "+", 
             RowBox[{"11", " ", 
              SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
           SuperscriptBox["\[Omega]", "2"]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["r", "7"], " ", 
           SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}]}], ")"}], " ", 
     RowBox[{"H0", "[", "r", "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["r", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "L"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "6"], " ", 
        SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "L"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "r"}], "-", "rs"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", "rs", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "8"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "7"}], "+", 
             RowBox[{"4", " ", "L", " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "L"}], ")"}]}]}], ")"}], " ", "r", " ", 
           "rs"}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "6"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", "r"}], "+", 
          RowBox[{"5", " ", "rs"}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "4"]}]}], ")"}], " ", 
     RowBox[{
      SuperscriptBox["H0", "\[Prime]",
       MultilineFunction->None], "[", "r", "]"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"r", " ", 
     RowBox[{"(", 
      RowBox[{"r", "-", "rs"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "L"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", 
           SuperscriptBox["r", "2"]}], "+", 
          RowBox[{"4", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "4"}], "+", "L", "+", 
             SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
          RowBox[{"9", " ", 
           SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Omega]", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["r", "6"], " ", 
        SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["H0", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{{3.9629644989044228`*^9, 3.962964544491581*^9}, 
   3.9629645763932304`*^9, {3.962964621069832*^9, 3.9629646483428288`*^9}},
 CellLabel->
  "Out[188]=",ExpressionUUID->"f1ab039e-731c-9e4c-8e4d-450c337c8829"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", 
        SuperscriptBox["r", "2"]}], "-", 
       RowBox[{"L", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "L"}], ")"}], " ", "r", " ", "rs"}], "+", 
       SuperscriptBox["rs", "2"]}], ")"}], " ", 
     RowBox[{"H0", "[", "r", "]"}]}], 
    RowBox[{
     SuperscriptBox["r", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"r", "-", "rs"}], ")"}], "2"]}]]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", "r"], "+", 
     FractionBox["1", 
      RowBox[{"r", "-", "rs"}]]}], ")"}], " ", 
   RowBox[{
    SuperscriptBox["H0", "\[Prime]",
     MultilineFunction->None], "[", "r", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["H0", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "r", "]"}]}]], "Output",
 CellChangeTimes->{{3.9629644989044228`*^9, 3.962964544491581*^9}, 
   3.9629645763932304`*^9, {3.962964621069832*^9, 3.962964648361206*^9}},
 CellLabel->
  "Out[189]=",ExpressionUUID->"dbb0cb79-64ba-0d48-9365-19b051450e27"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"H0", "[", "r", "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{
     TemplateBox[{"1"},
      "C"], " ", 
     RowBox[{"LegendreP", "[", 
      RowBox[{"L", ",", "2", ",", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox[
         RowBox[{"2", " ", "r"}], "rs"]}]}], "]"}]}], "+", 
    RowBox[{
     TemplateBox[{"2"},
      "C"], " ", 
     RowBox[{"LegendreQ", "[", 
      RowBox[{"L", ",", "2", ",", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        FractionBox[
         RowBox[{"2", " ", "r"}], "rs"]}]}], "]"}]}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9629644989044228`*^9, 3.962964544491581*^9}, 
   3.9629645763932304`*^9, {3.962964621069832*^9, 3.9629646484335384`*^9}},
 CellLabel->
  "Out[190]=",ExpressionUUID->"e9b33b7f-b94f-bb41-8eda-8dd7c683f3c3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Coefficient", "[", 
  RowBox[{"eqH0", ",", 
   RowBox[{
    RowBox[{"H0", "''"}], "[", "r", "]"}]}], "]"}]], "Input",
 CellLabel->
  "In[191]:=",ExpressionUUID->"09b345fe-1fed-7d41-beee-a3ac4e99b261"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "L"}], ")"}], " ", "L", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "L"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"r", "-", "rs"}], ")"}], "2"]}], "+", 
      RowBox[{
       SuperscriptBox["r", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "L", "+", 
            SuperscriptBox["L", "2"]}], ")"}], " ", "r", " ", "rs"}], "+", 
         RowBox[{"9", " ", 
          SuperscriptBox["rs", "2"]}]}], ")"}], " ", 
       SuperscriptBox["\[Omega]", "2"]}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["r", "6"], " ", 
       SuperscriptBox["\[Omega]", "4"]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "r"}], "-", 
       RowBox[{"3", " ", "rs"}]}], ")"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "L"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "L"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"r", "-", "rs"}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["r", "3"], " ", 
       SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{3.9629648536231995`*^9},
 CellLabel->
  "Out[191]=",ExpressionUUID->"ee2cb1ca-e79d-1e48-af6d-5f6eb82a0c2b"]
}, Open  ]],

Cell["Other", "Subsection",
 CellChangeTimes->{{3.962965729510298*^9, 
  3.9629657359713116`*^9}},ExpressionUUID->"7852731f-e851-864c-b7da-\
9c7504ae2687"]
}, Closed]]
}, Open  ]]
},
WindowSize->{949, 526.5},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1. Inherited,
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"49ae2043-ebc3-5d4c-9481-66cbfa24aca6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 174, 3, 98, "Title",ExpressionUUID->"126057e4-1e58-e644-8cf7-813f47a30703"],
Cell[757, 27, 640, 14, 150, "Text",ExpressionUUID->"07d34d65-b7f3-d843-b666-483d22d4d880"],
Cell[CellGroupData[{
Cell[1422, 45, 135, 2, 28, "Input",ExpressionUUID->"a59f75b5-4b5b-2749-95b9-2f86d14d629d"],
Cell[1560, 49, 480, 11, 28, "Message",ExpressionUUID->"d5f175e6-2c54-8b4a-b83f-b3754dea8e0e"]
}, Open  ]],
Cell[2055, 63, 9388, 262, 486, "Input",ExpressionUUID->"b2852a14-b6fe-d84a-ba3e-5c5cb70cf409"],
Cell[11446, 327, 77212, 1271, 188, "Input",ExpressionUUID->"abb2cc15-7602-1444-8e96-4ab696e2f0cf"],
Cell[88661, 1600, 5951, 164, 210, "Input",ExpressionUUID->"2d02405f-cc43-ed48-9460-6d2c0f858c99"],
Cell[94615, 1766, 555, 18, 35, "Text",ExpressionUUID->"c1b744dd-f370-e740-8e51-9017cb56ceeb"],
Cell[CellGroupData[{
Cell[95195, 1788, 639, 17, 48, "Input",ExpressionUUID->"ca727eb4-280a-7a46-bd1e-116de95ea538"],
Cell[95837, 1807, 1364, 43, 60, "Output",ExpressionUUID->"78d17398-d593-d341-8741-b03ad3434950"],
Cell[97204, 1852, 416, 10, 32, "Output",ExpressionUUID->"99c4b367-e55f-ae43-a729-f1f9e4505aeb"]
}, Open  ]],
Cell[97635, 1865, 2379, 60, 86, "Input",ExpressionUUID->"8aa4269d-c129-5044-9a44-383b5657d2a5"],
Cell[CellGroupData[{
Cell[100039, 1929, 987, 24, 48, "Input",ExpressionUUID->"09c949f0-bb25-ae4e-82a8-5dc592aa9505"],
Cell[CellGroupData[{
Cell[101051, 1957, 22105, 541, 202, "Print",ExpressionUUID->"bfbc0420-8985-ba4f-9893-7ed533396884"],
Cell[123159, 2500, 13262, 297, 184, "Print",ExpressionUUID->"0b89eb6e-fe74-3a41-996a-b2f82d10189b"],
Cell[136424, 2799, 24305, 577, 281, "Print",ExpressionUUID->"b30be0a6-fe33-7145-b2ab-fca9d2590ab7"],
Cell[160732, 3378, 550, 11, 22, "Print",ExpressionUUID->"3c1601ee-692a-564d-9ca8-23a0b59deff5"],
Cell[161285, 3391, 549, 11, 22, "Print",ExpressionUUID->"fee0139f-c37c-b349-95aa-465c86a73480"],
Cell[161837, 3404, 570, 11, 22, "Print",ExpressionUUID->"882d7c58-be5e-5e47-a237-cbee2f9bb349"],
Cell[162410, 3417, 570, 11, 22, "Print",ExpressionUUID->"fd6cc806-bb61-364f-a504-490199e6218a"],
Cell[162983, 3430, 554, 11, 22, "Print",ExpressionUUID->"bff40a1f-d8ae-ad47-8d75-119c92720d77"]
}, Open  ]],
Cell[163552, 3444, 182, 2, 32, "Output",ExpressionUUID->"75a554eb-739a-5644-bcf3-a21f9cd8452b"]
}, Open  ]],
Cell[163749, 3449, 598, 17, 48, "Input",ExpressionUUID->"77c0511b-4178-394c-b5ba-6288a275ae58"],
Cell[CellGroupData[{
Cell[164372, 3470, 203, 4, 67, "Section",ExpressionUUID->"597002aa-d8c5-7f4a-ab2e-5ea3c3b98fa0"],
Cell[CellGroupData[{
Cell[164600, 3478, 164, 3, 54, "Subsection",ExpressionUUID->"30c7e1e4-9dfa-5049-b477-575cc1827bc8"],
Cell[CellGroupData[{
Cell[164789, 3485, 644, 17, 48, "Input",ExpressionUUID->"0c6fbdfb-f280-df49-affe-537596afd1be"],
Cell[165436, 3504, 1156, 35, 47, "Output",ExpressionUUID->"3e900b2d-5356-f044-bb6e-ec8c57bddc87"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166629, 3544, 1153, 29, 71, "Input",ExpressionUUID->"bdb92867-513b-964b-9124-24e9f6f9117c"],
Cell[167785, 3575, 3417, 88, 93, "Output",ExpressionUUID->"72104e2c-7bd0-1944-9a0b-c077962aac73"],
Cell[171205, 3665, 2271, 65, 99, "Output",ExpressionUUID->"c0e663cd-6556-4641-9f63-9b0e89bea46c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173513, 3735, 969, 26, 67, "Input",ExpressionUUID->"a619a783-c5a9-d344-bda1-bda64dafb128"],
Cell[174485, 3763, 1644, 46, 51, "Output",ExpressionUUID->"a77ae5e0-d3ea-f745-a82a-a9f46c6850af"],
Cell[176132, 3811, 1026, 25, 48, "Output",ExpressionUUID->"a61c2196-67bf-2a42-8a86-5be3e8608386"]
}, Open  ]],
Cell[CellGroupData[{
Cell[177195, 3841, 997, 27, 67, "Input",ExpressionUUID->"a479a80e-60ce-d745-908e-0628f287b65e"],
Cell[178195, 3870, 3231, 85, 74, "Output",ExpressionUUID->"da61b4fd-f33a-1b47-8abb-a3c39f64202e"],
Cell[181429, 3957, 2047, 60, 55, "Output",ExpressionUUID->"0042915e-34fb-7c4d-bd80-12c879360d8c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183513, 4022, 1216, 36, 69, "Input",ExpressionUUID->"db5393c8-728a-0341-b89b-f991b154fa6b"],
Cell[184732, 4060, 4246, 109, 114, "Output",ExpressionUUID->"9b49b95c-b145-6646-a680-7a63483b9fc0"],
Cell[188981, 4171, 1442, 41, 54, "Output",ExpressionUUID->"430fc601-6090-2943-a47d-5070d84f4f52"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190460, 4217, 992, 27, 67, "Input",ExpressionUUID->"249b553c-7d70-d24f-966c-995162612d12"],
Cell[191455, 4246, 1291, 38, 51, "Output",ExpressionUUID->"e5db8684-8dc8-b84e-8e8a-0bce1eaea57c"],
Cell[192749, 4286, 855, 23, 49, "Output",ExpressionUUID->"f7efe659-4f2e-c94b-8309-a74daa0291af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193641, 4314, 995, 27, 67, "Input",ExpressionUUID->"9ed95719-4cac-d446-9a73-7b94c784d4d4"],
Cell[194639, 4343, 1874, 53, 73, "Output",ExpressionUUID->"7aceef0e-6ce9-0d42-92f3-1cff9002cad2"],
Cell[196516, 4398, 778, 20, 49, "Output",ExpressionUUID->"29c10ffc-00e4-224d-a7fb-72c8b7db1d04"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197331, 4423, 816, 18, 83, "Input",ExpressionUUID->"8f80057c-616f-334a-876f-5ac7eb50e20f"],
Cell[198150, 4443, 8824, 239, 198, "Output",ExpressionUUID->"c36b0f81-ca30-8d47-8aad-4cea4bc2868b"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[207023, 4688, 194, 3, 38, "Subsection",ExpressionUUID->"5eaaff71-01c3-0249-a696-1a46ada72e4f"],
Cell[CellGroupData[{
Cell[207242, 4695, 3855, 108, 276, "Input",ExpressionUUID->"ae1a4069-8312-c247-8722-583a4ed34201"],
Cell[211100, 4805, 7349, 195, 173, "Output",ExpressionUUID->"db8ba8f6-c255-c44c-8299-541c5770d23c"],
Cell[218452, 5002, 9413, 249, 169, "Output",ExpressionUUID->"2e82485d-0937-ff4a-ab75-9df7e28ec2a7"],
Cell[227868, 5253, 1250, 30, 48, "Output",ExpressionUUID->"b593a21d-351c-444d-afa9-b52524e2a1d4"],
Cell[229121, 5285, 5802, 153, 155, "Output",ExpressionUUID->"79d123a2-a727-1245-8d47-3d13f63780a9"],
Cell[234926, 5440, 2811, 74, 59, "Output",ExpressionUUID->"cfc079d3-0727-fb45-a390-ecf32d7946b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[237774, 5519, 177, 2, 28, "Input",ExpressionUUID->"6f2f0334-a6ae-1c45-8f9b-8fb06cd08c0e"],
Cell[237954, 5523, 1799, 55, 114, "Output",ExpressionUUID->"03de9e34-7df0-e24b-a514-5bc8f1fe8c57"]
}, Open  ]],
Cell[CellGroupData[{
Cell[239790, 5583, 456, 12, 28, "Input",ExpressionUUID->"95345ecb-f096-e143-8943-bfb81f2032c3"],
Cell[240249, 5597, 2119, 61, 58, "Output",ExpressionUUID->"9a5f84e9-58cc-c349-beb2-ee1100ddee30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[242405, 5663, 1949, 51, 94, "Input",ExpressionUUID->"8733b388-29b0-5440-89f6-d7906eb9b957"],
Cell[244357, 5716, 63553, 1635, 282, "Output",ExpressionUUID->"cd848394-4315-7f43-a0ad-c73751feeae3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[307947, 7356, 214, 3, 48, "Input",ExpressionUUID->"db98f108-002b-ba41-8acc-23d17118515c"],
Cell[308164, 7361, 2179, 65, 58, "Output",ExpressionUUID->"cb2212e2-478a-914c-b1db-6b943ce58062"],
Cell[310346, 7428, 2431, 73, 58, "Output",ExpressionUUID->"40c40e6e-4636-2448-99b6-f18e8c9a6293"]
}, Open  ]],
Cell[312792, 7504, 260, 6, 35, "Text",ExpressionUUID->"88ccb73d-179b-6d41-9b07-a9e23a66d893"],
Cell[313055, 7512, 15564, 261, 45, "Input",ExpressionUUID->"ace34631-9dbb-5a4a-be25-f1849051d1be"],
Cell[328622, 7775, 14595, 245, 49, "Input",ExpressionUUID->"4d0221ac-c552-424a-be9c-5d906686d9f2"],
Cell[343220, 8022, 5074, 125, 164, "Input",ExpressionUUID->"0697a9bc-f232-3849-affe-2a4960e46dea"],
Cell[CellGroupData[{
Cell[348319, 8151, 2644, 70, 181, "Input",ExpressionUUID->"56629b9f-85ef-2743-9e21-4ef0f6018d50"],
Cell[350966, 8223, 10818, 301, 166, "Output",ExpressionUUID->"f240b0a3-5849-dd48-a5e8-40616649c9eb"],
Cell[361787, 8526, 13452, 355, 130, "Output",ExpressionUUID->"fa577eb8-e822-c344-9bbb-ce977ed33ba3"],
Cell[375242, 8883, 5563, 149, 148, "Output",ExpressionUUID->"72666932-fa77-4444-b14c-24d7d1ca7498"],
Cell[380808, 9034, 8469, 236, 230, "Output",ExpressionUUID->"760c9e12-45bb-9748-a274-efd989cd5917"]
}, Open  ]],
Cell[CellGroupData[{
Cell[389314, 9275, 1964, 51, 127, "Input",ExpressionUUID->"7cfdc42b-7ce0-504c-aff7-31dee3168f8d"],
Cell[391281, 9328, 1929, 58, 56, "Output",ExpressionUUID->"02d1fa48-185e-e84e-ac3b-39f3b6fd0125"],
Cell[393213, 9388, 494, 13, 50, "Output",ExpressionUUID->"69de6f97-c102-7347-bad9-907a27e55d73"],
Cell[393710, 9403, 282, 5, 32, "Output",ExpressionUUID->"e76d9078-40d6-7241-959a-50c4c6c6fa0a"],
Cell[393995, 9410, 2010, 62, 78, "Output",ExpressionUUID->"7c4d194f-fb3c-1f4c-aef4-e87ddec4d1ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[396042, 9477, 217, 4, 28, "Input",ExpressionUUID->"90fe1fdb-25ae-2944-a9bc-534d6b88f33d"],
Cell[396262, 9483, 1948, 61, 94, "Output",ExpressionUUID->"70f2a68e-9fdc-6745-8a88-2a2edcbc99c3"]
}, Open  ]],
Cell[398225, 9547, 175, 3, 35, "Text",ExpressionUUID->"d112a4c1-ceb0-994a-a230-a5a8300534e8"],
Cell[398403, 9552, 22681, 377, 60, "Input",ExpressionUUID->"9d9bb1de-cd1c-5945-a940-21aa53f3a1c5"],
Cell[CellGroupData[{
Cell[421109, 9933, 1606, 51, 110, "Input",ExpressionUUID->"d5a01250-c4b3-c442-b697-6594fc7880ca"],
Cell[422718, 9986, 182, 3, 32, "Output",ExpressionUUID->"c0d77639-cf01-3b49-b13e-3dd734c699e4"]
}, Open  ]],
Cell[422915, 9992, 2107, 64, 97, "Input",ExpressionUUID->"6653e569-f085-aa4c-9fc4-d17017fbacfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[425059, 10061, 193, 3, 38, "Subsection",ExpressionUUID->"839be787-367b-154b-ba82-10e63fb6cc78"],
Cell[CellGroupData[{
Cell[425277, 10068, 717, 20, 48, "Input",ExpressionUUID->"95135afd-cd20-bd4c-bc6d-9a5fd6c87817"],
Cell[425997, 10090, 304, 4, 32, "Output",ExpressionUUID->"87785ed9-9352-6647-abbc-c08a54ad6591"],
Cell[426304, 10096, 22567, 417, 232, "Output",ExpressionUUID->"dc737ec5-a9e3-954f-b897-aa4bfc8dc021"]
}, Open  ]],
Cell[448886, 10516, 6539, 113, 35, "Input",ExpressionUUID->"ef1f6bb4-14e6-b743-8a4a-cd0ca223a172"],
Cell[CellGroupData[{
Cell[455450, 10633, 1830, 53, 67, "Input",ExpressionUUID->"3e750fad-e195-0245-a9fb-b40fd2272208"],
Cell[457283, 10688, 53416, 993, 379, "Output",ExpressionUUID->"fd9b7e52-b61e-c84c-b3e6-1715b550479d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[510736, 11686, 2379, 65, 112, "Input",ExpressionUUID->"a3c4a65c-d541-4c4e-9a73-1746d97db1fa"],
Cell[513118, 11753, 53381, 994, 379, "Output",ExpressionUUID->"0f6bf3fa-8cb4-7448-af77-113f9ce25af9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[566536, 12752, 626, 19, 48, "Input",ExpressionUUID->"c5539291-4d9c-8642-b326-9883040e80e8"],
Cell[567165, 12773, 194, 3, 32, "Output",ExpressionUUID->"a9fbcc3d-75a6-4f48-a4bf-02d674ecc73d"],
Cell[567362, 12778, 195, 3, 32, "Output",ExpressionUUID->"3f735b27-6a30-cd48-97f8-7b5ef40e3886"]
}, Open  ]],
Cell[CellGroupData[{
Cell[567594, 12786, 328, 8, 28, "Input",ExpressionUUID->"ef1913ca-4be7-3f47-bb9c-f8731901db99"],
Cell[567925, 12796, 631, 20, 61, "Output",ExpressionUUID->"d1ad7a1e-938f-6a4f-a986-e8faa1436968"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[568617, 12823, 160, 3, 67, "Section",ExpressionUUID->"82081c17-8e14-7c47-ab20-6d5c6fef6964"],
Cell[CellGroupData[{
Cell[568802, 12830, 164, 3, 54, "Subsection",ExpressionUUID->"a656b9f2-6bb2-9348-a4b2-ddcf8350233d"],
Cell[CellGroupData[{
Cell[568991, 12837, 1171, 34, 66, "Input",ExpressionUUID->"ba481502-dce1-9b4e-867d-f80cce9b72f3"],
Cell[570165, 12873, 1732, 52, 70, "Output",ExpressionUUID->"f6bd4bc9-8444-1944-9be6-8de073b3907b"],
Cell[571900, 12927, 1150, 32, 32, "Output",ExpressionUUID->"f4786e5d-5063-9047-9efa-d556c09bea22"]
}, Open  ]],
Cell[CellGroupData[{
Cell[573087, 12964, 1122, 33, 66, "Input",ExpressionUUID->"7ce66d0b-c115-994c-8b4b-d525ac99737c"],
Cell[574212, 12999, 1666, 49, 56, "Output",ExpressionUUID->"7042984a-355d-a148-86e7-e149c8570688"],
Cell[575881, 13050, 941, 28, 55, "Output",ExpressionUUID->"b649b238-767b-8a45-af96-3782d3186a8e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[576859, 13083, 1518, 44, 50, "Input",ExpressionUUID->"685b80b8-8e04-0f4b-b89c-befd690c12c2"],
Cell[578380, 13129, 1751, 55, 75, "Output",ExpressionUUID->"fb89ea0c-7da9-3648-a465-2e86a4180b8b"],
Cell[580134, 13186, 716, 22, 50, "Output",ExpressionUUID->"058e370c-7385-1e46-bcd5-d79aec32030e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[580887, 13213, 414, 10, 48, "Input",ExpressionUUID->"20fdcc8c-80bf-7742-9d44-a2348e0b27db"],
Cell[581304, 13225, 3289, 93, 103, "Output",ExpressionUUID->"cded9316-6e55-8c4a-8102-d94e42d347a4"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[584642, 13324, 253, 4, 38, "Subsection",ExpressionUUID->"0e20ad41-7ddd-d04c-8b54-f53a278b1d7f"],
Cell[CellGroupData[{
Cell[584920, 13332, 1506, 47, 123, "Input",ExpressionUUID->"d6f18db1-a141-6c47-901b-42da362e7d4a"],
Cell[586429, 13381, 963, 27, 53, "Output",ExpressionUUID->"da05af59-8f49-0247-8eef-dcb23345fc0f"],
Cell[587395, 13410, 4288, 120, 119, "Output",ExpressionUUID->"b1d1acce-2eb3-b743-9bf1-9d98445cd0dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[591720, 13535, 546, 13, 48, "Input",ExpressionUUID->"70580529-5e6f-fa4c-a668-f75b2c4bfb55"],
Cell[592269, 13550, 1235, 39, 51, "Output",ExpressionUUID->"1a855a46-a8fa-0f4c-9bc2-854e7838567c"],
Cell[593507, 13591, 511, 15, 48, "Output",ExpressionUUID->"44ccb642-72a2-1546-a410-d55f2502f6b2"]
}, Open  ]],
Cell[594033, 13609, 611, 18, 61, "Input",ExpressionUUID->"6f076793-e703-844a-bd99-5576a71b834a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[594681, 13632, 237, 4, 54, "Subsection",ExpressionUUID->"2b7e281b-2ad6-a14b-a329-2b360ae71830"],
Cell[CellGroupData[{
Cell[594943, 13640, 778, 22, 48, "Input",ExpressionUUID->"62b440b8-75c3-804a-8047-1baa75c6de8f"],
Cell[595724, 13664, 534, 15, 48, "Output",ExpressionUUID->"035c85bd-b181-4e4b-bc0f-8c64174ea7b1"],
Cell[596261, 13681, 23563, 434, 230, "Output",ExpressionUUID->"c7aebd37-44f5-144f-9159-db841a2b5efd"]
}, Open  ]],
Cell[619839, 14118, 6539, 113, 35, "Input",ExpressionUUID->"19d0e505-0386-f741-b1d3-73a8b7ba2a43"],
Cell[CellGroupData[{
Cell[626403, 14235, 1882, 55, 67, "Input",ExpressionUUID->"7c792f20-d148-2349-8cd6-2c51106d053a"],
Cell[628288, 14292, 54254, 1011, 379, "Output",ExpressionUUID->"dc0e5737-cb4f-a745-8cf7-b473b8c36086"]
}, Open  ]],
Cell[CellGroupData[{
Cell[682579, 15308, 2426, 66, 112, "Input",ExpressionUUID->"966a5b58-0c08-f840-9ad0-8182c1d01d3a"],
Cell[685008, 15376, 54126, 1007, 379, "Output",ExpressionUUID->"d3f7abf1-a4c5-724e-864a-7475db8e1489"]
}, Open  ]],
Cell[CellGroupData[{
Cell[739171, 16388, 378, 9, 28, "Input",ExpressionUUID->"013de922-22d2-f54d-9b1e-864e945de037"],
Cell[739552, 16399, 395, 12, 52, "Output",ExpressionUUID->"c45d7bee-6e40-1646-b8ce-93d64662abf3"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[740008, 16418, 176, 3, 67, "Section",ExpressionUUID->"9deb4cb1-57f8-b141-814b-06f78324fe8f"],
Cell[CellGroupData[{
Cell[740209, 16425, 1501, 43, 67, "Input",ExpressionUUID->"cdcb542b-7267-ae41-8662-4e2dbc158bdf"],
Cell[741713, 16470, 40633, 757, 379, "Output",ExpressionUUID->"5ccdf733-b6b1-904d-8c55-d5254b5c0314"]
}, Open  ]],
Cell[CellGroupData[{
Cell[782383, 17232, 864, 26, 48, "Input",ExpressionUUID->"c8a28563-6f51-0a49-807b-ad9e9d0552c5"],
Cell[783250, 17260, 682, 23, 51, "Output",ExpressionUUID->"1ba53010-157b-5c4f-a8c7-c9cfd67c1ef0"],
Cell[783935, 17285, 25326, 458, 377, "Output",ExpressionUUID->"bfa58bfc-922c-ac49-80d3-118698bf99dd"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[809310, 17749, 273, 4, 67, "Section",ExpressionUUID->"dcaeb59b-58c8-374a-9763-b772e6179935"],
Cell[809586, 17755, 214, 4, 35, "Text",ExpressionUUID->"f4496d5c-547d-ad43-9226-209c55d67f5c"],
Cell[CellGroupData[{
Cell[809825, 17763, 3750, 104, 314, "Input",ExpressionUUID->"f7b2aba0-ec09-6a4b-ba72-2fbb26f151ed"],
Cell[813578, 17869, 1324, 35, 54, "Output",ExpressionUUID->"bd580adf-8a1b-6f4a-b22f-2aa564dca196"],
Cell[814905, 17906, 14577, 403, 210, "Output",ExpressionUUID->"dcb2607c-d0b5-dc4a-8b22-eccf171b45be"],
Cell[829485, 18311, 2462, 74, 106, "Output",ExpressionUUID->"ab268df2-b4ae-ef45-a0a9-231288dc9c32"],
Cell[831950, 18387, 26855, 711, 203, "Output",ExpressionUUID->"6e3199ee-c4ba-5a4d-817a-7f142401d664"],
Cell[858808, 19100, 4232, 123, 171, "Output",ExpressionUUID->"0ac5ae97-8e32-a94a-9394-37d213a164be"],
Cell[863043, 19225, 37944, 963, 200, "Output",ExpressionUUID->"6207e5bb-3ae8-5c4a-81c7-e9f315e4aa58"],
Cell[900990, 20190, 9836, 268, 251, "Output",ExpressionUUID->"e5da84b8-f105-3449-8ec0-8d733f72e34e"],
Cell[910829, 20460, 440, 9, 31, "Output",ExpressionUUID->"bec1ff90-0777-2349-b007-c2c84542c120"],
Cell[911272, 20471, 9625, 282, 251, "Output",ExpressionUUID->"45c24bc7-4a6f-2941-b602-16aeddabc5be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[920934, 20758, 782, 23, 88, "Input",ExpressionUUID->"9a1ca0c8-eb51-9e49-ace9-b4f503be9b29"],
Cell[921719, 20783, 9099, 262, 251, "Output",ExpressionUUID->"f1ab039e-731c-9e4c-8e4d-450c337c8829"],
Cell[930821, 21047, 1184, 36, 57, "Output",ExpressionUUID->"dbb0cb79-64ba-0d48-9365-19b051450e27"],
Cell[932008, 21085, 846, 26, 50, "Output",ExpressionUUID->"e9b33b7f-b94f-bb41-8eda-8dd7c683f3c3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[932891, 21116, 224, 6, 27, "Input",ExpressionUUID->"09b345fe-1fed-7d41-beee-a3ac4e99b261"],
Cell[933118, 21124, 1927, 60, 56, "Output",ExpressionUUID->"ee2cb1ca-e79d-1e48-af6d-5f6eb82a0c2b"]
}, Open  ]],
Cell[935060, 21187, 155, 3, 38, "Subsection",ExpressionUUID->"7852731f-e851-864c-b7da-9c7504ae2687"]
}, Closed]]
}, Open  ]]
}
]
*)

